/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification.tapchanger;

import com.powsybl.iidm.modification.tapchanger.AbstractTapPositionModification;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.PhaseTapChangerHolder;
import com.powsybl.iidm.network.ThreeSides;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.iidm.network.ValidationException;
import java.util.Objects;

public class PhaseTapPositionModification
extends AbstractTapPositionModification {
    public PhaseTapPositionModification(String transformerId, int tapPosition) {
        super(transformerId, tapPosition, null);
    }

    public PhaseTapPositionModification(String transformerId, int tapPosition, ThreeSides leg) {
        super(transformerId, tapPosition, Objects.requireNonNull(leg));
    }

    @Override
    protected void applyTwoWindingsTransformer(Network network, TwoWindingsTransformer twoWindingsTransformer, boolean throwException) {
        this.apply((PhaseTapChangerHolder)twoWindingsTransformer, throwException);
    }

    @Override
    protected void applyThreeWindingsTransformer(Network network, ThreeWindingsTransformer threeWindingsTransformer, boolean throwException) {
        this.apply((PhaseTapChangerHolder)this.getLeg(threeWindingsTransformer, PhaseTapChangerHolder::hasPhaseTapChanger, throwException), throwException);
    }

    public void apply(PhaseTapChangerHolder ptcHolder, boolean throwException) {
        if (ptcHolder == null) {
            this.logOrThrow(throwException, "Failed to apply : Transformer '" + this.getTransformerId());
            return;
        }
        if (!ptcHolder.hasPhaseTapChanger()) {
            this.logOrThrow(throwException, "Transformer '" + this.getTransformerId() + "' does not have a PhaseTapChanger");
            return;
        }
        try {
            ptcHolder.getPhaseTapChanger().setTapPosition(this.getTapPosition());
        }
        catch (ValidationException e) {
            this.logOrThrow(throwException, e.getMessage());
        }
    }
}

