/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification.topology;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.reporter.Reporter;
import com.powsybl.computation.ComputationManager;
import com.powsybl.iidm.modification.AbstractNetworkModification;
import com.powsybl.iidm.modification.topology.NamingStrategy;
import com.powsybl.iidm.modification.topology.TopologyModificationUtils;
import com.powsybl.iidm.modification.util.ModificationLogs;
import com.powsybl.iidm.modification.util.ModificationReports;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.BusbarSection;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.extensions.BusbarSectionPosition;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateCouplingDevice
extends AbstractNetworkModification {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateCouplingDevice.class);
    private final String busOrBbsId1;
    private final String busOrBbsId2;
    private String switchPrefixId;

    CreateCouplingDevice(String busOrBbsId1, String busOrBbsId2, String switchPrefixId) {
        this.busOrBbsId1 = Objects.requireNonNull(busOrBbsId1, "Busbar section 1 not defined");
        this.busOrBbsId2 = Objects.requireNonNull(busOrBbsId2, "Busbar section 2 not defined");
        this.switchPrefixId = switchPrefixId;
    }

    public String getBusOrBbsId1() {
        return this.busOrBbsId1;
    }

    @Deprecated(since="5.2.0")
    public String getBbsId1() {
        return this.getBusOrBbsId1();
    }

    public String getBusOrBbsId2() {
        return this.busOrBbsId2;
    }

    @Deprecated(since="5.2.0")
    public String getBbsId2() {
        return this.getBusOrBbsId2();
    }

    public Optional<String> getSwitchPrefixId() {
        return Optional.ofNullable(this.switchPrefixId);
    }

    @Override
    public void apply(Network network, NamingStrategy namingStrategy, boolean throwException, ComputationManager computationManager, Reporter reporter) {
        Identifiable busOrBbs2;
        Identifiable busOrBbs1 = network.getIdentifiable(this.busOrBbsId1);
        if (this.failBbs(busOrBbs1, busOrBbs2 = network.getIdentifiable(this.busOrBbsId2), reporter, throwException)) {
            return;
        }
        VoltageLevel voltageLevel1 = CreateCouplingDevice.getVoltageLevel(busOrBbs1, reporter, throwException);
        VoltageLevel voltageLevel2 = CreateCouplingDevice.getVoltageLevel(busOrBbs2, reporter, throwException);
        if (voltageLevel1 == null || voltageLevel2 == null) {
            LOGGER.error("Voltage level associated to {} or {} not found.", (Object)busOrBbs1, (Object)busOrBbs2);
            ModificationReports.notFoundBusOrBusbarSectionVoltageLevelReport(reporter, this.busOrBbsId1, this.busOrBbsId2);
            if (throwException) {
                throw new PowsyblException(String.format("Voltage level associated to %s or %s not found.", busOrBbs1, busOrBbs2));
            }
            return;
        }
        if (voltageLevel1 != voltageLevel2) {
            LOGGER.error("{} and {} are in two different voltage levels.", (Object)this.busOrBbsId1, (Object)this.busOrBbsId2);
            ModificationReports.unexpectedDifferentVoltageLevels(reporter, this.busOrBbsId1, this.busOrBbsId2);
            if (throwException) {
                throw new PowsyblException(String.format("%s and %s are in two different voltage levels.", this.busOrBbsId1, this.busOrBbsId2));
            }
            return;
        }
        if (busOrBbs1 instanceof Bus && busOrBbs2 instanceof Bus) {
            if (this.switchPrefixId == null) {
                this.switchPrefixId = voltageLevel1.getId();
            }
            TopologyModificationUtils.createBusBreakerSwitch(this.busOrBbsId1, this.busOrBbsId2, namingStrategy.getSwitchId(this.switchPrefixId), voltageLevel1.getBusBreakerView());
        } else if (busOrBbs1 instanceof BusbarSection) {
            BusbarSection bbs1 = (BusbarSection)busOrBbs1;
            if (busOrBbs2 instanceof BusbarSection) {
                BusbarSection bbs2 = (BusbarSection)busOrBbs2;
                this.applyOnBusbarSections(voltageLevel1, voltageLevel2, bbs1, bbs2, namingStrategy, reporter);
            }
        }
        LOGGER.info("New coupling device was added to voltage level {} between {} and {}", new Object[]{voltageLevel1.getId(), busOrBbs1, busOrBbs2});
        ModificationReports.newCouplingDeviceAddedReport(reporter, voltageLevel1.getId(), this.busOrBbsId1, this.busOrBbsId2);
    }

    private void applyOnBusbarSections(VoltageLevel voltageLevel1, VoltageLevel voltageLevel2, BusbarSection bbs1, BusbarSection bbs2, NamingStrategy namingStrategy, Reporter reporter) {
        boolean avoidLastBarOnFirstSide;
        if (this.switchPrefixId == null) {
            this.switchPrefixId = namingStrategy.getSwitchBaseId(voltageLevel1, bbs1, bbs2);
        }
        int breakerNode1 = voltageLevel1.getNodeBreakerView().getMaximumNodeIndex() + 1;
        int breakerNode2 = breakerNode1 + 1;
        int nbOpenDisconnectors = 0;
        TopologyModificationUtils.createNBBreaker(breakerNode1, breakerNode2, namingStrategy.getBreakerId(this.switchPrefixId), voltageLevel1.getNodeBreakerView(), false);
        BusbarSectionPosition position1 = (BusbarSectionPosition)bbs1.getExtension(BusbarSectionPosition.class);
        BusbarSectionPosition position2 = (BusbarSectionPosition)bbs2.getExtension(BusbarSectionPosition.class);
        boolean bbsOnSameSection = position1 != null && position2 != null && position1.getSectionIndex() == position2.getSectionIndex();
        boolean bl = avoidLastBarOnFirstSide = bbsOnSameSection && this.checkSides(voltageLevel1, position1, position2);
        if (position1 != null) {
            List<BusbarSection> bbsList1 = this.computeBbsListAndCreateTopology(voltageLevel1, bbs1, namingStrategy, bbsOnSameSection, breakerNode1, avoidLastBarOnFirstSide, 1);
            nbOpenDisconnectors += bbsList1.size() - 1;
        } else {
            TopologyModificationUtils.createDisconnectorTopology(voltageLevel1, breakerNode1, namingStrategy, this.switchPrefixId, List.of(bbs1), bbs1);
            LOGGER.warn("No busbar section position extension found on {}, only one disconnector is created.", (Object)bbs1.getId());
            ModificationReports.noBusbarSectionPositionExtensionReport(reporter, bbs1);
        }
        if (position2 != null) {
            List<BusbarSection> bbsList2 = this.computeBbsListAndCreateTopology(voltageLevel2, bbs2, namingStrategy, bbsOnSameSection, breakerNode2, !avoidLastBarOnFirstSide, 2);
            nbOpenDisconnectors += bbsList2.size() - 1;
        } else {
            TopologyModificationUtils.createDisconnectorTopology(voltageLevel2, breakerNode2, namingStrategy, this.switchPrefixId, List.of(bbs2), bbs2);
            LOGGER.warn("No busbar section position extension found on {}, only one disconnector is created.", (Object)bbs2.getId());
            ModificationReports.noBusbarSectionPositionExtensionReport(reporter, bbs2);
        }
        if (nbOpenDisconnectors > 0) {
            LOGGER.info("{} open disconnectors created on parallel busbar section in voltage level {}", (Object)nbOpenDisconnectors, (Object)voltageLevel1.getId());
            ModificationReports.openDisconnectorsAddedReport(reporter, voltageLevel1.getId(), nbOpenDisconnectors);
        }
    }

    private boolean checkSides(VoltageLevel voltageLevel, BusbarSectionPosition position1, BusbarSectionPosition position2) {
        OptionalInt minBbsIndex = TopologyModificationUtils.getParallelBusbarSections(voltageLevel, position1).stream().mapToInt(b -> ((BusbarSectionPosition)b.getExtension(BusbarSectionPosition.class)).getBusbarIndex()).min();
        OptionalInt maxBbsIndex = TopologyModificationUtils.getParallelBusbarSections(voltageLevel, position2).stream().mapToInt(b -> ((BusbarSectionPosition)b.getExtension(BusbarSectionPosition.class)).getBusbarIndex()).max();
        return position1.getBusbarIndex() == minBbsIndex.orElseThrow() || position2.getBusbarIndex() == maxBbsIndex.orElseThrow();
    }

    private List<BusbarSection> computeBbsListAndCreateTopology(VoltageLevel voltageLevel, BusbarSection bbs, NamingStrategy namingStrategy, boolean bbsOnSameSection, int breakerNode, boolean avoidLastBar, int side) {
        BusbarSectionPosition position = (BusbarSectionPosition)bbs.getExtension(BusbarSectionPosition.class);
        List<BusbarSection> bbsList = TopologyModificationUtils.getParallelBusbarSections(voltageLevel, position);
        if (bbsOnSameSection) {
            if (avoidLastBar) {
                int maxBbsIndex = bbsList.stream().mapToInt(b -> ((BusbarSectionPosition)b.getExtension(BusbarSectionPosition.class)).getBusbarIndex()).max().orElseThrow();
                bbsList = bbsList.stream().filter(b -> ((BusbarSectionPosition)b.getExtension(BusbarSectionPosition.class)).getBusbarIndex() != maxBbsIndex).toList();
            } else {
                int minBbsIndex = bbsList.stream().mapToInt(b -> ((BusbarSectionPosition)b.getExtension(BusbarSectionPosition.class)).getBusbarIndex()).min().orElseThrow();
                bbsList = bbsList.stream().filter(b -> ((BusbarSectionPosition)b.getExtension(BusbarSectionPosition.class)).getBusbarIndex() != minBbsIndex).toList();
            }
        }
        TopologyModificationUtils.createDisconnectorTopology(voltageLevel, breakerNode, namingStrategy, this.switchPrefixId, bbsList, bbs, bbsOnSameSection ? side : 0);
        return bbsList;
    }

    private boolean failBbs(Identifiable<?> bbs1, Identifiable<?> bbs2, Reporter reporter, boolean throwException) {
        if (bbs1 == null) {
            ModificationLogs.busOrBbsDoesNotExist(this.busOrBbsId1, reporter, throwException);
            return true;
        }
        if (bbs2 == null) {
            ModificationLogs.busOrBbsDoesNotExist(this.busOrBbsId2, reporter, throwException);
            return true;
        }
        if (bbs1 == bbs2) {
            LOGGER.error("No coupling device can be created on a same busbar section or bus ({})", (Object)this.busOrBbsId1);
            ModificationReports.noCouplingDeviceOnSameBusOrBusbarSection(reporter, this.busOrBbsId1);
            if (throwException) {
                throw new PowsyblException(String.format("No coupling device can be created on a same bus or busbar section (%s)", this.busOrBbsId1));
            }
            return true;
        }
        return false;
    }

    private static VoltageLevel getVoltageLevel(Identifiable<?> identifiable, Reporter reporter, boolean throwException) {
        if (identifiable instanceof Bus) {
            Bus bus = (Bus)identifiable;
            return bus.getVoltageLevel();
        }
        if (identifiable instanceof BusbarSection) {
            BusbarSection bbs = (BusbarSection)identifiable;
            return bbs.getTerminal().getVoltageLevel();
        }
        LOGGER.error("Unexpected type of identifiable {}: {}", (Object)identifiable.getId(), (Object)identifiable.getType());
        ModificationReports.unexpectedIdentifiableType(reporter, identifiable);
        if (throwException) {
            throw new PowsyblException("Unexpected type of identifiable " + identifiable.getId() + ": " + identifiable.getType());
        }
        return null;
    }
}

