/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification;

import com.powsybl.commons.reporter.Reporter;
import com.powsybl.computation.ComputationManager;
import com.powsybl.iidm.modification.AbstractNetworkModification;
import com.powsybl.iidm.modification.topology.NamingStrategy;
import com.powsybl.iidm.modification.util.ModificationReports;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.util.SwitchPredicates;
import java.util.Objects;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectableConnection
extends AbstractNetworkModification {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectableConnection.class);
    final String connectableId;
    final Predicate<Switch> isTypeSwitchToOperate;

    ConnectableConnection(String connectableId, boolean openFictitiousSwitches, boolean operateOnlyBreakers) {
        this.connectableId = Objects.requireNonNull(connectableId);
        Predicate predicate = SwitchPredicates.IS_NON_NULL;
        if (!openFictitiousSwitches) {
            predicate = predicate.and(SwitchPredicates.IS_NONFICTIONAL);
        }
        if (operateOnlyBreakers) {
            predicate = predicate.and(SwitchPredicates.IS_BREAKER);
        }
        this.isTypeSwitchToOperate = predicate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(Network network, NamingStrategy namingStrategy, boolean throwException, ComputationManager computationManager, Reporter reporter) {
        boolean hasBeenConnected;
        Connectable connectable = network.getConnectable(this.connectableId);
        network.getReporterContext().pushReporter(reporter);
        try {
            hasBeenConnected = connectable.connect(this.isTypeSwitchToOperate);
        }
        finally {
            network.getReporterContext().popReporter();
        }
        if (hasBeenConnected) {
            LOG.info("Connectable {} has been connected.", (Object)this.connectableId);
        } else {
            LOG.info("Connectable {} has NOT been connected.", (Object)this.connectableId);
        }
        ModificationReports.connectableConnectionReport(reporter, connectable, hasBeenConnected);
    }
}

