/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification.tapchanger;

import com.powsybl.iidm.modification.tapchanger.AbstractTapPositionModification;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.RatioTapChangerHolder;
import com.powsybl.iidm.network.ThreeSides;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.iidm.network.ValidationException;
import java.util.Objects;

public class RatioTapPositionModification
extends AbstractTapPositionModification {
    public RatioTapPositionModification(String transformerId, int tapPosition) {
        super(transformerId, tapPosition, null);
    }

    public RatioTapPositionModification(String transformerId, int tapPosition, ThreeSides leg) {
        super(transformerId, tapPosition, Objects.requireNonNull(leg));
    }

    @Override
    protected void applyTwoWindingsTransformer(Network network, TwoWindingsTransformer twoWindingsTransformer, boolean throwException) {
        this.apply((RatioTapChangerHolder)twoWindingsTransformer, throwException);
    }

    @Override
    protected void applyThreeWindingsTransformer(Network network, ThreeWindingsTransformer threeWindingsTransformer, boolean throwException) {
        this.apply((RatioTapChangerHolder)this.getLeg(threeWindingsTransformer, RatioTapChangerHolder::hasRatioTapChanger, throwException), throwException);
    }

    public void apply(RatioTapChangerHolder rtcHolder, boolean throwException) {
        if (rtcHolder == null) {
            this.logOrThrow(throwException, "Failed to apply : Transformer '" + this.getTransformerId());
            return;
        }
        if (!rtcHolder.hasRatioTapChanger()) {
            this.logOrThrow(throwException, "Transformer '" + this.getTransformerId() + "' does not have a RatioTapChanger");
            return;
        }
        try {
            rtcHolder.getRatioTapChanger().setTapPosition(this.getTapPosition());
        }
        catch (ValidationException e) {
            this.logOrThrow(throwException, e.getMessage());
        }
    }
}

