/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification.topology;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.reporter.Reporter;
import com.powsybl.iidm.modification.AbstractNetworkModification;
import com.powsybl.iidm.modification.util.ModificationLogs;
import com.powsybl.iidm.modification.util.ModificationReports;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.BusbarSection;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Line;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.VoltageLevel;
import java.util.Objects;
import org.slf4j.Logger;

abstract class AbstractLineConnectionModification<M extends AbstractLineConnectionModification<M>>
extends AbstractNetworkModification {
    protected final String bbsOrBusId;
    protected final Line line;
    protected String line1Id;
    protected String line1Name;
    protected String line2Id;
    protected String line2Name;
    protected double positionPercent;
    protected VoltageLevel voltageLevel;

    protected AbstractLineConnectionModification(double positionPercent, String bbsOrBusId, String line1Id, String line1Name, String line2Id, String line2Name, Line line) {
        this.positionPercent = positionPercent;
        this.bbsOrBusId = Objects.requireNonNull(bbsOrBusId);
        this.line1Id = Objects.requireNonNull(line1Id);
        this.line1Name = line1Name;
        this.line2Id = Objects.requireNonNull(line2Id);
        this.line2Name = line2Name;
        this.line = Objects.requireNonNull(line);
    }

    public M setLine1Id(String line1Id) {
        this.line1Id = Objects.requireNonNull(line1Id);
        return (M)this;
    }

    public M setLine1Name(String line1Name) {
        this.line1Name = line1Name;
        return (M)this;
    }

    public M setLine2Id(String line2Id) {
        this.line2Id = Objects.requireNonNull(line2Id);
        return (M)this;
    }

    public M setLine2Name(String line2Name) {
        this.line2Name = line2Name;
        return (M)this;
    }

    public M setPositionPercent(double positionPercent) {
        this.positionPercent = positionPercent;
        return (M)this;
    }

    public double getPositionPercent() {
        return this.positionPercent;
    }

    public String getBbsOrBusId() {
        return this.bbsOrBusId;
    }

    public Line getLine() {
        return this.line;
    }

    public String getLine1Id() {
        return this.line1Id;
    }

    public String getLine1Name() {
        return this.line1Name;
    }

    public String getLine2Id() {
        return this.line2Id;
    }

    public String getLine2Name() {
        return this.line2Name;
    }

    private static boolean checkPositionPercent(double positionPercent, boolean throwException, Reporter reporter, Logger logger) {
        if (Double.isNaN(positionPercent)) {
            logger.error("Percent should not be undefined");
            ModificationReports.undefinedPercent(reporter);
            if (throwException) {
                throw new PowsyblException("Percent should not be undefined");
            }
            return false;
        }
        return true;
    }

    protected boolean failChecks(Network network, boolean throwException, Reporter reporter, Logger logger) {
        Identifiable identifiable = network.getIdentifiable(this.bbsOrBusId);
        if (identifiable == null) {
            ModificationLogs.busOrBbsDoesNotExist(this.bbsOrBusId, reporter, throwException);
            return true;
        }
        if (!AbstractLineConnectionModification.checkPositionPercent(this.positionPercent, throwException, reporter, logger)) {
            return true;
        }
        this.voltageLevel = AbstractLineConnectionModification.getVoltageLevel(identifiable, throwException, reporter, logger);
        return this.voltageLevel == null;
    }

    private static VoltageLevel getVoltageLevel(Identifiable<?> identifiable, boolean throwException, Reporter reporter, Logger logger) {
        if (identifiable instanceof Bus) {
            Bus bus = (Bus)identifiable;
            return bus.getVoltageLevel();
        }
        if (identifiable instanceof BusbarSection) {
            BusbarSection bbs = (BusbarSection)identifiable;
            return bbs.getTerminal().getVoltageLevel();
        }
        logger.error("Unexpected type of identifiable {}: {}", (Object)identifiable.getId(), (Object)identifiable.getType());
        ModificationReports.unexpectedIdentifiableType(reporter, identifiable);
        if (throwException) {
            throw new PowsyblException("Unexpected type of identifiable " + identifiable.getId() + ": " + identifiable.getType());
        }
        return null;
    }
}

