/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification.topology;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.reporter.Report;
import com.powsybl.commons.reporter.Reporter;
import com.powsybl.commons.reporter.TypedValue;
import com.powsybl.computation.ComputationManager;
import com.powsybl.iidm.modification.topology.AbstractLineConnectionModification;
import com.powsybl.iidm.modification.topology.NamingStrategy;
import com.powsybl.iidm.modification.topology.TopologyModificationUtils;
import com.powsybl.iidm.modification.util.ModificationReports;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.BusAdder;
import com.powsybl.iidm.network.BusbarSection;
import com.powsybl.iidm.network.Line;
import com.powsybl.iidm.network.LineAdder;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.SubstationAdder;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.TwoSides;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.VoltageLevelAdder;
import com.powsybl.iidm.network.extensions.BusbarSectionPosition;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateLineOnLine
extends AbstractLineConnectionModification<CreateLineOnLine> {
    private static final Logger LOG = LoggerFactory.getLogger(CreateLineOnLine.class);
    private final LineAdder lineAdder;
    private String fictitiousVlId;
    private String fictitiousVlName;
    private boolean createFictSubstation;
    private String fictitiousSubstationId;
    private String fictitiousSubstationName;

    CreateLineOnLine(double positionPercent, String bbsOrBusId, String fictitiousVlId, String fictitiousVlName, boolean createFictSubstation, String fictitiousSubstationId, String fictitiousSubstationName, String line1Id, String line1Name, String line2Id, String line2Name, Line line, LineAdder lineAdder) {
        super(positionPercent, bbsOrBusId, line1Id, line1Name, line2Id, line2Name, line);
        this.fictitiousVlId = Objects.requireNonNull(fictitiousVlId);
        this.fictitiousVlName = fictitiousVlName;
        this.createFictSubstation = createFictSubstation;
        this.fictitiousSubstationId = fictitiousSubstationId;
        this.fictitiousSubstationName = fictitiousSubstationName;
        this.lineAdder = Objects.requireNonNull(lineAdder);
    }

    private static boolean checkFictitiousSubstationId(boolean createFictSubstation, String fictitiousSubstationId, boolean throwException, Reporter reporter) {
        if (createFictSubstation && fictitiousSubstationId == null) {
            LOG.error("Fictitious substation ID must be defined if a fictitious substation is to be created");
            ModificationReports.undefinedFictitiousSubstationId(reporter);
            if (throwException) {
                throw new PowsyblException("Fictitious substation ID must be defined if a fictitious substation is to be created");
            }
            return false;
        }
        return true;
    }

    public CreateLineOnLine setFictitiousVlId(String fictitiousVlId) {
        this.fictitiousVlId = Objects.requireNonNull(fictitiousVlId);
        return this;
    }

    public CreateLineOnLine setFictitiousVlName(String fictitiousVlName) {
        this.fictitiousVlName = fictitiousVlName;
        return this;
    }

    public CreateLineOnLine setCreateFictSubstation(boolean createFictSubstation) {
        this.createFictSubstation = createFictSubstation;
        return this;
    }

    public CreateLineOnLine setFictitiousSubstationId(String fictitiousSubstationId) {
        this.fictitiousSubstationId = fictitiousSubstationId;
        return this;
    }

    public CreateLineOnLine setFictitiousSubstationName(String fictitiousSubstationName) {
        this.fictitiousSubstationName = fictitiousSubstationName;
        return this;
    }

    @Override
    public void apply(Network network, NamingStrategy namingStrategy, boolean throwException, ComputationManager computationManager, Reporter reporter) {
        if (this.failChecks(network, throwException, reporter, LOG)) {
            return;
        }
        if (!CreateLineOnLine.checkFictitiousSubstationId(this.createFictSubstation, this.fictitiousSubstationId, throwException, reporter)) {
            return;
        }
        VoltageLevel fictitiousVl = this.createFictSubstation ? ((VoltageLevelAdder)((VoltageLevelAdder)((VoltageLevelAdder)((SubstationAdder)((SubstationAdder)((SubstationAdder)network.newSubstation().setId(this.fictitiousSubstationId)).setName(this.fictitiousSubstationName)).setFictitious(true)).add().newVoltageLevel().setId(this.fictitiousVlId)).setName(this.fictitiousVlName)).setFictitious(true)).setNominalV(this.line.getTerminal1().getVoltageLevel().getNominalV()).setTopologyKind(TopologyKind.NODE_BREAKER).add() : ((VoltageLevelAdder)((VoltageLevelAdder)((VoltageLevelAdder)network.newVoltageLevel().setId(this.fictitiousVlId)).setName(this.fictitiousVlName)).setFictitious(true)).setNominalV(this.line.getTerminal1().getVoltageLevel().getNominalV()).setTopologyKind(TopologyKind.NODE_BREAKER).add();
        LineAdder adder1 = TopologyModificationUtils.createLineAdder(this.positionPercent, this.line1Id, this.line1Name, this.line.getTerminal1().getVoltageLevel().getId(), this.fictitiousVlId, network, this.line);
        LineAdder adder2 = TopologyModificationUtils.createLineAdder(100.0 - this.positionPercent, this.line2Id, this.line2Name, this.fictitiousVlId, this.line.getTerminal2().getVoltageLevel().getId(), network, this.line);
        TopologyModificationUtils.attachLine(this.line.getTerminal1(), adder1, (bus, adder) -> adder.setConnectableBus1(bus.getId()), (bus, adder) -> adder.setBus1(bus.getId()), (node, adder) -> adder.setNode1(node.intValue()));
        TopologyModificationUtils.attachLine(this.line.getTerminal2(), adder2, (bus, adder) -> adder.setConnectableBus2(bus.getId()), (bus, adder) -> adder.setBus2(bus.getId()), (node, adder) -> adder.setNode2(node.intValue()));
        TopologyModificationUtils.LoadingLimitsBags limits1 = new TopologyModificationUtils.LoadingLimitsBags(() -> ((Line)this.line).getActivePowerLimits1(), () -> ((Line)this.line).getApparentPowerLimits1(), () -> ((Line)this.line).getCurrentLimits1());
        TopologyModificationUtils.LoadingLimitsBags limits2 = new TopologyModificationUtils.LoadingLimitsBags(() -> ((Line)this.line).getActivePowerLimits2(), () -> ((Line)this.line).getApparentPowerLimits2(), () -> ((Line)this.line).getCurrentLimits2());
        String originalLineId = this.line.getId();
        this.line.remove();
        Line line1 = ((LineAdder)adder1.setNode2(0)).add();
        Line line2 = ((LineAdder)adder2.setNode1(2)).add();
        TopologyModificationUtils.addLoadingLimits(line1, limits1, TwoSides.ONE);
        TopologyModificationUtils.addLoadingLimits(line2, limits2, TwoSides.TWO);
        fictitiousVl.getNodeBreakerView().newInternalConnection().setNode1(0).setNode2(1).add();
        fictitiousVl.getNodeBreakerView().newInternalConnection().setNode1(1).setNode2(2).add();
        fictitiousVl.getNodeBreakerView().newInternalConnection().setNode1(1).setNode2(3).add();
        ((LineAdder)((LineAdder)this.lineAdder.setNode1(3)).setVoltageLevel1(this.fictitiousVlId)).setVoltageLevel2(this.voltageLevel.getId());
        TopologyKind topologyKind = this.voltageLevel.getTopologyKind();
        if (topologyKind == TopologyKind.BUS_BREAKER) {
            Bus bus2 = network.getBusBreakerView().getBus(this.bbsOrBusId);
            Bus bus1 = ((BusAdder)this.voltageLevel.getBusBreakerView().newBus().setId(namingStrategy.getBusId(originalLineId))).add();
            this.lineAdder.setBus2(bus1.getId());
            ((VoltageLevel.BusBreakerView.SwitchAdder)this.voltageLevel.getBusBreakerView().newSwitch().setId(namingStrategy.getSwitchId(originalLineId))).setOpen(false).setBus1(bus1.getId()).setBus2(bus2.getId()).add();
        } else if (topologyKind == TopologyKind.NODE_BREAKER) {
            int firstAvailableNode = this.voltageLevel.getNodeBreakerView().getMaximumNodeIndex() + 1;
            this.lineAdder.setNode2(firstAvailableNode);
            BusbarSection bbs = network.getBusbarSection(this.bbsOrBusId);
            BusbarSectionPosition position = (BusbarSectionPosition)bbs.getExtension(BusbarSectionPosition.class);
            if (position == null) {
                TopologyModificationUtils.createNodeBreakerSwitchesTopology(this.voltageLevel, firstAvailableNode, firstAvailableNode + 1, namingStrategy, originalLineId, bbs);
                LOG.warn("No busbar section position extension found on {}, only one disconnector is created.", (Object)bbs.getId());
                ModificationReports.noBusbarSectionPositionExtensionReport(reporter, bbs);
            } else {
                List<BusbarSection> bbsList = TopologyModificationUtils.getParallelBusbarSections(this.voltageLevel, position);
                TopologyModificationUtils.createNodeBreakerSwitchesTopology(this.voltageLevel, firstAvailableNode, firstAvailableNode + 1, namingStrategy, originalLineId, bbsList, bbs);
            }
        } else {
            throw new IllegalStateException();
        }
        Line newLine = this.lineAdder.add();
        LOG.info("New line {} was created and connected on a tee point to lines {} and {} replacing line {}", new Object[]{newLine.getId(), this.line1Id, this.line2Id, originalLineId});
        reporter.report(Report.builder().withKey("newLineOnLineCreated").withDefaultMessage("New line ${newLineId} was created and connected on a tee point to lines ${line1Id} and ${line2Id} replacing line ${originalLineId}.").withValue("newLineId", newLine.getId()).withValue("line1Id", this.line1Id).withValue("line2Id", this.line2Id).withValue("originalLineId", originalLineId).withSeverity(TypedValue.INFO_SEVERITY).build());
    }

    public LineAdder getLineAdder() {
        return this.lineAdder;
    }

    public String getFictitiousVlId() {
        return this.fictitiousVlId;
    }

    public String getFictitiousVlName() {
        return this.fictitiousVlName;
    }

    public boolean isCreateFictSubstation() {
        return this.createFictSubstation;
    }

    public String getFictitiousSubstationId() {
        return this.fictitiousSubstationId;
    }

    public String getFictitiousSubstationName() {
        return this.fictitiousSubstationName;
    }
}

