/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification.scalable;

import com.powsybl.iidm.modification.scalable.AbstractScalable;
import com.powsybl.iidm.modification.scalable.Scalable;
import com.powsybl.iidm.modification.scalable.ScalingParameters;
import com.powsybl.iidm.network.Injection;
import com.powsybl.iidm.network.Network;
import java.util.List;
import java.util.Objects;

class UpDownScalable
extends AbstractScalable {
    private final Scalable upScalable;
    private final Scalable downScalable;
    private final double minValue;
    private final double maxValue;

    public UpDownScalable(Scalable upScalable, Scalable downScalable) {
        this(upScalable, downScalable, -1.7976931348623157E308, Double.MAX_VALUE);
    }

    public UpDownScalable(Scalable upScalable, Scalable downScalable, double minValue, double maxValue) {
        this.upScalable = Objects.requireNonNull(upScalable);
        this.downScalable = Objects.requireNonNull(downScalable);
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    @Override
    public double initialValue(Network n) {
        return this.upScalable.initialValue(n) + this.downScalable.initialValue(n);
    }

    @Override
    public void reset(Network n) {
        this.upScalable.reset(n);
        this.downScalable.reset(n);
    }

    @Override
    public double maximumValue(Network n, Scalable.ScalingConvention scalingConvention) {
        if (scalingConvention == Scalable.ScalingConvention.LOAD) {
            return Math.min(this.downScalable.maximumValue(n, scalingConvention) - this.upScalable.initialValue(n), this.maxValue);
        }
        return Math.min(this.upScalable.maximumValue(n, scalingConvention) + this.downScalable.initialValue(n), this.maxValue);
    }

    @Override
    public double minimumValue(Network n, Scalable.ScalingConvention scalingConvention) {
        if (scalingConvention == Scalable.ScalingConvention.LOAD) {
            return Math.max(this.upScalable.minimumValue(n, scalingConvention) - this.downScalable.initialValue(n), this.minValue);
        }
        return Math.max(this.downScalable.minimumValue(n, scalingConvention) + this.upScalable.initialValue(n), this.minValue);
    }

    @Override
    public void filterInjections(Network network, List<Injection> injections, List<String> notFound) {
        this.upScalable.filterInjections(network, injections, notFound);
        this.downScalable.filterInjections(network, injections, notFound);
    }

    @Override
    public double scale(Network n, double asked, ScalingParameters parameters) {
        double minWithConvention = parameters.getScalingConvention() == Scalable.ScalingConvention.GENERATOR ? this.minValue : -this.maxValue;
        double maxWithConvention = parameters.getScalingConvention() == Scalable.ScalingConvention.GENERATOR ? this.maxValue : -this.minValue;
        double boundedAsked = asked > 0.0 ? Math.min(asked, maxWithConvention - this.getSteadyStatePower(n, asked, parameters.getScalingConvention())) : Math.max(asked, minWithConvention - this.getSteadyStatePower(n, asked, parameters.getScalingConvention()));
        return asked > 0.0 ? this.upScalable.scale(n, boundedAsked, parameters) : this.downScalable.scale(n, boundedAsked, parameters);
    }

    @Override
    public double getSteadyStatePower(Network network, double asked, Scalable.ScalingConvention scalingConvention) {
        return asked > 0.0 ? this.upScalable.getSteadyStatePower(network, asked, scalingConvention) : this.downScalable.getSteadyStatePower(network, asked, scalingConvention);
    }
}

