/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification.topology;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.computation.ComputationManager;
import com.powsybl.iidm.modification.AbstractNetworkModification;
import com.powsybl.iidm.modification.topology.NamingStrategy;
import com.powsybl.iidm.modification.topology.TopologyModificationUtils;
import com.powsybl.iidm.modification.util.ModificationReports;
import com.powsybl.iidm.network.BusAdder;
import com.powsybl.iidm.network.BusbarSection;
import com.powsybl.iidm.network.BusbarSectionAdder;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.SwitchKind;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.extensions.BusbarSectionPositionAdder;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateVoltageLevelTopology
extends AbstractNetworkModification {
    private static final Logger LOG = LoggerFactory.getLogger(CreateVoltageLevelTopology.class);
    private final String voltageLevelId;
    private final int lowBusOrBusbarIndex;
    private final int alignedBusesOrBusbarCount;
    private final int lowSectionIndex;
    private final int sectionCount;
    private final String busOrBusbarSectionPrefixId;
    private final String switchPrefixId;
    private final List<SwitchKind> switchKinds;

    CreateVoltageLevelTopology(String voltageLevelId, int lowBusOrBusbarIndex, Integer alignedBusesOrBusbarCount, int lowSectionIndex, Integer sectionCount, String busOrBusbarSectionPrefixId, String switchPrefixId, List<SwitchKind> switchKinds) {
        this.voltageLevelId = Objects.requireNonNull(voltageLevelId, "Undefined voltage level ID");
        this.lowBusOrBusbarIndex = lowBusOrBusbarIndex;
        this.alignedBusesOrBusbarCount = Objects.requireNonNull(alignedBusesOrBusbarCount, "Undefined aligned buses or busbars count");
        this.lowSectionIndex = lowSectionIndex;
        this.sectionCount = Objects.requireNonNull(sectionCount, "Undefined section count");
        this.busOrBusbarSectionPrefixId = Objects.requireNonNull(busOrBusbarSectionPrefixId, "Undefined busbar section prefix ID");
        this.switchPrefixId = Objects.requireNonNull(switchPrefixId, "Undefined switch prefix ID");
        this.switchKinds = switchKinds;
    }

    private static boolean checkCountAttributes(Integer count, String type, int min, ReportNode reportNode, boolean throwException) {
        if (count < min) {
            LOG.error("{} must be >= {}", (Object)type, (Object)min);
            ModificationReports.countLowerThanMin(reportNode, type, min);
            if (throwException) {
                throw new PowsyblException(type + " must be >= " + min);
            }
            return false;
        }
        return true;
    }

    private boolean checkCountAttributes(int lowBusOrBusbarIndex, int alignedBusesOrBusbarCount, int lowSectionIndex, int sectionCount, boolean throwException, ReportNode reportNode) {
        return CreateVoltageLevelTopology.checkCountAttributes(lowBusOrBusbarIndex, "low busbar index", 0, reportNode, throwException) && CreateVoltageLevelTopology.checkCountAttributes(alignedBusesOrBusbarCount, "busbar count", 1, reportNode, throwException) && CreateVoltageLevelTopology.checkCountAttributes(lowSectionIndex, "low section index", 0, reportNode, throwException) && CreateVoltageLevelTopology.checkCountAttributes(sectionCount, "section count", 1, reportNode, throwException);
    }

    private static boolean checkSwitchKinds(List<SwitchKind> switchKinds, int sectionCount, ReportNode reportNode, boolean throwException) {
        Objects.requireNonNull(switchKinds, "Undefined switch kinds");
        if (switchKinds.size() != sectionCount - 1) {
            LOG.error("Unexpected switch kinds count ({}). Should be {}", (Object)switchKinds.size(), (Object)(sectionCount - 1));
            ModificationReports.unexpectedSwitchKindsCount(reportNode, switchKinds.size(), sectionCount - 1);
            if (throwException) {
                throw new PowsyblException("Unexpected switch kinds count (" + switchKinds.size() + "). Should be " + (sectionCount - 1));
            }
            return false;
        }
        if (switchKinds.contains(null)) {
            LOG.error("All switch kinds must be defined");
            ModificationReports.undefinedSwitchKind(reportNode);
            if (throwException) {
                throw new PowsyblException("All switch kinds must be defined");
            }
            return false;
        }
        if (switchKinds.stream().anyMatch(kind -> kind != SwitchKind.DISCONNECTOR && kind != SwitchKind.BREAKER)) {
            LOG.error("Switch kinds must be DISCONNECTOR or BREAKER");
            ModificationReports.wrongSwitchKind(reportNode);
            if (throwException) {
                throw new PowsyblException("Switch kinds must be DISCONNECTOR or BREAKER");
            }
            return false;
        }
        return true;
    }

    public String getVoltageLevelId() {
        return this.voltageLevelId;
    }

    public int getLowBusOrBusbarIndex() {
        return this.lowBusOrBusbarIndex;
    }

    public int getAlignedBusesOrBusbarCount() {
        return this.alignedBusesOrBusbarCount;
    }

    public int getLowSectionIndex() {
        return this.lowSectionIndex;
    }

    public int getSectionCount() {
        return this.sectionCount;
    }

    public List<SwitchKind> getSwitchKinds() {
        return Collections.unmodifiableList(this.switchKinds);
    }

    @Override
    public void apply(Network network, NamingStrategy namingStrategy, boolean throwException, ComputationManager computationManager, ReportNode reportNode) {
        if (!this.checkCountAttributes(this.lowBusOrBusbarIndex, this.alignedBusesOrBusbarCount, this.lowSectionIndex, this.sectionCount, throwException, reportNode)) {
            return;
        }
        VoltageLevel voltageLevel = network.getVoltageLevel(this.voltageLevelId);
        if (voltageLevel == null) {
            LOG.error("Voltage level {} is not found", (Object)this.voltageLevelId);
            ModificationReports.notFoundVoltageLevelReport(reportNode, this.voltageLevelId);
            if (throwException) {
                throw new PowsyblException(String.format("Voltage level %s is not found", this.voltageLevelId));
            }
            return;
        }
        TopologyKind topologyKind = voltageLevel.getTopologyKind();
        if (topologyKind == TopologyKind.BUS_BREAKER) {
            if (!this.switchKinds.isEmpty()) {
                LOG.warn("Voltage level {} is BUS_BREAKER. Switchkinds is ignored.", (Object)this.voltageLevelId);
            }
            this.createBuses(voltageLevel, namingStrategy);
            this.createBusBreakerSwitches(voltageLevel, namingStrategy);
        } else {
            if (!CreateVoltageLevelTopology.checkSwitchKinds(this.switchKinds, this.sectionCount, reportNode, throwException)) {
                return;
            }
            this.createBusbarSections(voltageLevel, namingStrategy);
            this.createSwitches(voltageLevel, namingStrategy);
        }
        LOG.info("New symmetrical topology in voltage level {}: creation of {} bus(es) or busbar(s) with {} section(s) each.", new Object[]{this.voltageLevelId, this.alignedBusesOrBusbarCount, this.sectionCount});
        ModificationReports.createdNewSymmetricalTopology(reportNode, this.voltageLevelId, this.alignedBusesOrBusbarCount, this.sectionCount);
    }

    private void createBusbarSections(VoltageLevel voltageLevel, NamingStrategy namingStrategy) {
        int node = 0;
        for (int sectionNum = this.lowSectionIndex; sectionNum < this.lowSectionIndex + this.sectionCount; ++sectionNum) {
            for (int busbarNum = this.lowBusOrBusbarIndex; busbarNum < this.lowBusOrBusbarIndex + this.alignedBusesOrBusbarCount; ++busbarNum) {
                BusbarSection bbs = ((BusbarSectionAdder)voltageLevel.getNodeBreakerView().newBusbarSection().setId(namingStrategy.getBusbarId(this.busOrBusbarSectionPrefixId, this.switchKinds, busbarNum, sectionNum))).setNode(node).add();
                ((BusbarSectionPositionAdder)bbs.newExtension(BusbarSectionPositionAdder.class)).withBusbarIndex(busbarNum).withSectionIndex(sectionNum).add();
                ++node;
            }
        }
    }

    private void createBuses(VoltageLevel voltageLevel, NamingStrategy namingStrategy) {
        for (int sectionNum = this.lowSectionIndex; sectionNum < this.lowSectionIndex + this.sectionCount; ++sectionNum) {
            for (int busNum = this.lowBusOrBusbarIndex; busNum < this.lowBusOrBusbarIndex + this.alignedBusesOrBusbarCount; ++busNum) {
                ((BusAdder)voltageLevel.getBusBreakerView().newBus().setId(namingStrategy.getBusbarId(this.busOrBusbarSectionPrefixId, busNum, sectionNum))).add();
            }
        }
    }

    private void createBusBreakerSwitches(VoltageLevel voltageLevel, NamingStrategy namingStrategy) {
        for (int sectionNum = this.lowSectionIndex; sectionNum < this.lowSectionIndex + this.sectionCount - 1; ++sectionNum) {
            for (int busNum = this.lowBusOrBusbarIndex; busNum < this.lowSectionIndex + this.alignedBusesOrBusbarCount; ++busNum) {
                String bus1Id = namingStrategy.getBusbarId(this.busOrBusbarSectionPrefixId, busNum, sectionNum);
                String bus2Id = namingStrategy.getBusbarId(this.busOrBusbarSectionPrefixId, busNum, sectionNum + 1);
                TopologyModificationUtils.createBusBreakerSwitch(bus1Id, bus2Id, namingStrategy.getSwitchId(this.switchPrefixId, busNum, sectionNum), voltageLevel.getBusBreakerView());
            }
        }
    }

    private void createSwitches(VoltageLevel voltageLevel, NamingStrategy namingStrategy) {
        for (int sectionNum = this.lowSectionIndex; sectionNum < this.lowSectionIndex + this.sectionCount - 1; ++sectionNum) {
            SwitchKind switchKind = this.switchKinds.get(sectionNum - 1);
            for (int busBarNum = this.lowBusOrBusbarIndex; busBarNum < this.lowBusOrBusbarIndex + this.alignedBusesOrBusbarCount; ++busBarNum) {
                BusbarSection bbs1 = voltageLevel.getNodeBreakerView().getBusbarSection(namingStrategy.getBusbarId(this.busOrBusbarSectionPrefixId, this.switchKinds, busBarNum, sectionNum));
                BusbarSection bbs2 = voltageLevel.getNodeBreakerView().getBusbarSection(namingStrategy.getBusbarId(this.busOrBusbarSectionPrefixId, this.switchKinds, busBarNum, sectionNum + 1));
                int node1 = CreateVoltageLevelTopology.getNode(bbs1.getId(), voltageLevel);
                int node2 = CreateVoltageLevelTopology.getNode(bbs2.getId(), voltageLevel);
                if (switchKind == SwitchKind.BREAKER) {
                    int newNode1 = voltageLevel.getNodeBreakerView().getMaximumNodeIndex() + 1;
                    int newNode2 = newNode1 + 1;
                    String chunkingPrefixId = namingStrategy.getChunkPrefix(this.switchPrefixId, this.switchKinds, busBarNum, sectionNum, sectionNum + 1);
                    TopologyModificationUtils.createNBDisconnector(node1, newNode1, namingStrategy.getDisconnectorBetweenChunksId(bbs1, chunkingPrefixId, node1, newNode1), voltageLevel.getNodeBreakerView(), false);
                    TopologyModificationUtils.createNBBreaker(newNode1, newNode2, namingStrategy.getBreakerId(chunkingPrefixId, busBarNum, sectionNum), voltageLevel.getNodeBreakerView(), false);
                    TopologyModificationUtils.createNBDisconnector(newNode2, node2, namingStrategy.getDisconnectorBetweenChunksId(bbs2, chunkingPrefixId, newNode2, node2), voltageLevel.getNodeBreakerView(), false);
                    continue;
                }
                if (switchKind != SwitchKind.DISCONNECTOR) continue;
                String sectioningPrefix = namingStrategy.getSectioningPrefix(this.switchPrefixId, bbs1, busBarNum, sectionNum, sectionNum + 1);
                TopologyModificationUtils.createNBDisconnector(node1, node2, namingStrategy.getDisconnectorId(sectioningPrefix, node1, node2), voltageLevel.getNodeBreakerView(), false);
            }
        }
    }

    private static int getNode(String busBarSectionId, VoltageLevel voltageLevel) {
        return voltageLevel.getNodeBreakerView().getBusbarSection(busBarSectionId).getTerminal().getNodeBreakerView().getNode();
    }
}

