/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification.tripping;

import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.modification.tripping.AbstractTripping;
import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.Terminal;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;

public class BranchTripping
extends AbstractTripping {
    protected final String voltageLevelId;
    private final BiFunction<Network, String, Branch<?>> supplier;

    public BranchTripping(String branchId) {
        this(branchId, null);
    }

    public BranchTripping(String branchId, String voltageLevelId) {
        this(branchId, voltageLevelId, Network::getBranch);
    }

    protected BranchTripping(String branchId, String voltageLevelId, BiFunction<Network, String, Branch<?>> supplier) {
        super(branchId);
        this.voltageLevelId = voltageLevelId;
        this.supplier = supplier;
    }

    protected String getVoltageLevelId() {
        return this.voltageLevelId;
    }

    @Override
    public void traverse(Network network, Set<Switch> switchesToOpen, Set<Terminal> terminalsToDisconnect, Set<Terminal> traversedTerminals) {
        Objects.requireNonNull(network);
        Branch<?> branch = this.supplier.apply(network, this.id);
        if (branch == null) {
            throw this.createNotFoundException();
        }
        this.traverseDoubleSidedEquipment(this.voltageLevelId, branch.getTerminal1(), branch.getTerminal2(), switchesToOpen, terminalsToDisconnect, traversedTerminals, branch.getType().name());
    }

    protected PowsyblException createNotFoundException() {
        return new PowsyblException("Branch '" + this.id + "' not found");
    }

    protected PowsyblException createNotConnectedException() {
        return new PowsyblException("VoltageLevel '" + this.voltageLevelId + "' not connected to branch '" + this.id + "'");
    }
}

