/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification.tripping;

import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.modification.tripping.AbstractTripping;
import com.powsybl.iidm.modification.tripping.TrippingTopologyTraverser;
import com.powsybl.iidm.network.BusbarSection;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.Terminal;
import java.util.Objects;
import java.util.Set;

public class BusbarSectionTripping
extends AbstractTripping {
    public BusbarSectionTripping(String busbarSectionId) {
        super(busbarSectionId);
    }

    @Override
    public void traverse(Network network, Set<Switch> switchesToOpen, Set<Terminal> terminalsToDisconnect, Set<Terminal> traversedTerminals) {
        Objects.requireNonNull(network);
        BusbarSection busbarSection = network.getBusbarSection(this.id);
        if (busbarSection == null) {
            throw new PowsyblException("Busbar section '" + this.id + "' not found");
        }
        TrippingTopologyTraverser.traverse(busbarSection.getTerminal(), switchesToOpen, terminalsToDisconnect, traversedTerminals);
    }
}

