/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification.tripping;

import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.modification.tripping.AbstractTripping;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.TieLine;
import java.util.Objects;
import java.util.Set;

public class TieLineTripping
extends AbstractTripping {
    private final String voltageLevelId;

    public TieLineTripping(String tieLineId) {
        this(tieLineId, null);
    }

    public TieLineTripping(String tieLineId, String voltageLevelId) {
        super(tieLineId);
        this.voltageLevelId = voltageLevelId;
    }

    @Override
    public void traverse(Network network, Set<Switch> switchesToOpen, Set<Terminal> terminalsToDisconnect, Set<Terminal> traversedTerminals) {
        Objects.requireNonNull(network);
        TieLine tieLine = network.getTieLine(this.id);
        if (tieLine == null) {
            throw new PowsyblException("Tie line '" + this.id + "' not found");
        }
        Terminal terminal1 = tieLine.getDanglingLine1().getTerminal();
        Terminal terminal2 = tieLine.getDanglingLine2().getTerminal();
        this.traverseDoubleSidedEquipment(this.voltageLevelId, terminal1, terminal2, switchesToOpen, terminalsToDisconnect, traversedTerminals, tieLine.getType().name());
    }
}

