/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification.util;

import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.IdentifiableType;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.ShuntCompensator;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalDouble;
import java.util.stream.Stream;

public final class VoltageRegulationUtils {
    private VoltageRegulationUtils() {
    }

    public static Stream<Generator> getRegulatingGenerators(Network network, Bus controlledBus) {
        if (controlledBus != null) {
            return network.getGeneratorStream().filter(Generator::isVoltageRegulatorOn).filter(g -> g.getRegulatingTerminal().getBusView().getBus() != null).filter(g -> controlledBus.equals(g.getRegulatingTerminal().getBusView().getBus()));
        }
        return Stream.empty();
    }

    public static Stream<ShuntCompensator> getRegulatingShuntCompensators(Network network, Bus controlledBus) {
        if (controlledBus != null) {
            return network.getShuntCompensatorStream().filter(ShuntCompensator::isVoltageRegulatorOn).filter(sh -> sh.getRegulatingTerminal().getBusView().getBus() != null).filter(sh -> controlledBus.equals(sh.getRegulatingTerminal().getBusView().getBus()));
        }
        return Stream.empty();
    }

    public static OptionalDouble getTargetVForRegulatingElement(Network network, Bus controlledBus, String regulatingElementId, IdentifiableType identifiableType) {
        ArrayList targets;
        switch (identifiableType) {
            case GENERATOR: {
                List<Object> list = VoltageRegulationUtils.getRegulatingGenerators(network, controlledBus).filter(g -> !g.getId().equals(regulatingElementId)).map(Generator::getTargetV).distinct().toList();
                break;
            }
            case SHUNT_COMPENSATOR: {
                List<Object> list = VoltageRegulationUtils.getRegulatingShuntCompensators(network, controlledBus).filter(g -> !g.getId().equals(regulatingElementId)).map(ShuntCompensator::getTargetV).distinct().toList();
                break;
            }
            default: {
                List<Object> list = targets = new ArrayList();
            }
        }
        if (targets.isEmpty() || targets.size() > 1) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of((Double)targets.get(0));
    }
}

