/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.computation.ComputationManager;
import com.powsybl.iidm.modification.AbstractLoadModification;
import com.powsybl.iidm.modification.topology.NamingStrategy;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.Network;
import java.util.Objects;

public class DanglingLineModification
extends AbstractLoadModification {
    private final String danglingLineId;

    public DanglingLineModification(String danglingLineId, boolean relativeValue, Double p0, Double q0) {
        super(p0, q0, relativeValue);
        this.danglingLineId = Objects.requireNonNull(danglingLineId);
    }

    public DanglingLineModification(String danglingLineId, Double targetP0, Double targetQ0) {
        this(danglingLineId, false, targetP0, targetQ0);
    }

    public String getDanglingLineId() {
        return this.danglingLineId;
    }

    @Override
    public void apply(Network network, NamingStrategy namingStrategy, boolean throwException, ComputationManager computationManager, ReportNode reportNode) {
        DanglingLine danglingLine = network.getDanglingLine(this.getDanglingLineId());
        if (danglingLine == null) {
            this.logOrThrow(throwException, "DanglingLine '" + this.getDanglingLineId() + "' not found");
            return;
        }
        this.getP0().ifPresent(value -> danglingLine.setP0((this.isRelativeValue() ? danglingLine.getP0() : 0.0) + value));
        this.getQ0().ifPresent(value -> danglingLine.setQ0((this.isRelativeValue() ? danglingLine.getQ0() : 0.0) + value));
    }
}

