/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.computation.ComputationManager;
import com.powsybl.iidm.modification.AbstractLoadModification;
import com.powsybl.iidm.modification.topology.NamingStrategy;
import com.powsybl.iidm.network.Load;
import com.powsybl.iidm.network.Network;
import java.util.Objects;

public class LoadModification
extends AbstractLoadModification {
    private final String loadId;

    public LoadModification(String loadId, boolean relativeValue, Double p0, Double q0) {
        super(p0, q0, relativeValue);
        this.loadId = Objects.requireNonNull(loadId);
    }

    public LoadModification(String loadId, Double targetP0, Double targetQ0) {
        this(loadId, false, targetP0, targetQ0);
    }

    public String getLoadId() {
        return this.loadId;
    }

    @Override
    public void apply(Network network, NamingStrategy namingStrategy, boolean throwException, ComputationManager computationManager, ReportNode reportNode) {
        Load load = network.getLoad(this.getLoadId());
        if (load == null) {
            this.logOrThrow(throwException, "Load '" + this.getLoadId() + "' not found");
            return;
        }
        this.getP0().ifPresent(value -> load.setP0((this.isRelativeValue() ? load.getP0() : 0.0) + value));
        this.getQ0().ifPresent(value -> load.setQ0((this.isRelativeValue() ? load.getQ0() : 0.0) + value));
    }
}

