/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.computation.ComputationManager;
import com.powsybl.iidm.modification.AbstractNetworkModification;
import com.powsybl.iidm.modification.topology.NamingStrategy;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.PhaseTapChanger;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import java.util.Objects;

public class PhaseShifterShiftTap
extends AbstractNetworkModification {
    private final String phaseShifterId;
    private final int tapDelta;

    public PhaseShifterShiftTap(String phaseShifterId, int tapDelta) {
        this.phaseShifterId = Objects.requireNonNull(phaseShifterId);
        this.tapDelta = tapDelta;
    }

    public int getTapDelta() {
        return this.tapDelta;
    }

    @Override
    public void apply(Network network, NamingStrategy namingStrategy, boolean throwException, ComputationManager computationManager, ReportNode reportNode) {
        Objects.requireNonNull(network);
        TwoWindingsTransformer phaseShifter = network.getTwoWindingsTransformer(this.phaseShifterId);
        if (phaseShifter == null) {
            throw new PowsyblException("Transformer '" + this.phaseShifterId + "' not found");
        }
        PhaseTapChanger phaseTapChanger = phaseShifter.getPhaseTapChanger();
        if (phaseTapChanger == null) {
            throw new PowsyblException("Transformer '" + this.phaseShifterId + "' is not a phase shifter");
        }
        this.adjustTapPosition(phaseTapChanger);
        phaseTapChanger.setRegulating(false);
        phaseTapChanger.setRegulationMode(PhaseTapChanger.RegulationMode.FIXED_TAP);
    }

    private void adjustTapPosition(PhaseTapChanger phaseTapChanger) {
        phaseTapChanger.setTapPosition(Math.min(Math.max(phaseTapChanger.getTapPosition() + this.tapDelta, phaseTapChanger.getLowTapPosition()), phaseTapChanger.getHighTapPosition()));
    }
}

