/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.computation.ComputationManager;
import com.powsybl.iidm.modification.AbstractNetworkModification;
import com.powsybl.iidm.modification.topology.NamingStrategy;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import java.util.Objects;

public class ThreeWindingsTransformerModification
extends AbstractNetworkModification {
    private final String transformerId;
    private final Double ratedU0;

    public ThreeWindingsTransformerModification(String transformerId, double ratedU0) {
        this.transformerId = Objects.requireNonNull(transformerId);
        this.ratedU0 = ratedU0;
    }

    @Override
    public void apply(Network network, NamingStrategy namingStrategy, boolean throwException, ComputationManager computationManager, ReportNode reportNode) {
        ThreeWindingsTransformer t3wt = network.getThreeWindingsTransformer(this.transformerId);
        if (t3wt == null) {
            this.logOrThrow(throwException, "ThreeWindingsTransformer '" + this.transformerId + "' not found");
            return;
        }
        if (this.ratedU0 > 0.0) {
            t3wt.getLeg1().setRatedU(ThreeWindingsTransformerModification.calculateNewRatedU(t3wt.getLeg1().getRatedU(), t3wt.getRatedU0(), this.ratedU0));
            t3wt.getLeg2().setRatedU(ThreeWindingsTransformerModification.calculateNewRatedU(t3wt.getLeg2().getRatedU(), t3wt.getRatedU0(), this.ratedU0));
            t3wt.getLeg3().setRatedU(ThreeWindingsTransformerModification.calculateNewRatedU(t3wt.getLeg3().getRatedU(), t3wt.getRatedU0(), this.ratedU0));
            t3wt.setRatedU0(this.ratedU0.doubleValue());
        }
    }

    private static double calculateNewRatedU(double ratedU, double ratedU0, double newRatedU0) {
        return ratedU * newRatedU0 / ratedU0;
    }

    public String getTransformerId() {
        return this.transformerId;
    }

    public Double getRatedU0() {
        return this.ratedU0;
    }
}

