/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification.scalable.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.iidm.modification.scalable.Scalable;
import com.powsybl.iidm.modification.scalable.ScalingParameters;
import java.io.IOException;
import java.util.HashSet;

public class ScalingParametersDeserializer
extends StdDeserializer<ScalingParameters> {
    private static final String CONTEXT_NAME = "ScalingParameters";

    ScalingParametersDeserializer() {
        super(ScalingParameters.class);
    }

    public ScalingParameters deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        return this.deserialize(parser, context, new ScalingParameters());
    }

    public ScalingParameters deserialize(JsonParser parser, DeserializationContext context, ScalingParameters parameters) throws IOException {
        String version = null;
        block18: while (parser.nextToken() != JsonToken.END_OBJECT) {
            switch (parser.getCurrentName()) {
                case "version": {
                    parser.nextToken();
                    version = parser.getValueAsString();
                    continue block18;
                }
                case "scalingConvention": {
                    parser.nextToken();
                    parameters.setScalingConvention((Scalable.ScalingConvention)((Object)JsonUtil.readValue((DeserializationContext)context, (JsonParser)parser, Scalable.ScalingConvention.class)));
                    continue block18;
                }
                case "constantPowerFactor": {
                    parser.nextToken();
                    parameters.setConstantPowerFactor((Boolean)parser.readValueAs(Boolean.class));
                    continue block18;
                }
                case "reconnect": {
                    parser.nextToken();
                    parameters.setReconnect((Boolean)parser.readValueAs(Boolean.class));
                    continue block18;
                }
                case "iterative": {
                    JsonUtil.assertLessThanReferenceVersion((String)CONTEXT_NAME, (String)"Tag: iterative", version, (String)"1.1");
                    parser.nextToken();
                    parameters.setPriority(Boolean.TRUE.equals(parser.readValueAs(Boolean.class)) ? ScalingParameters.Priority.RESPECT_OF_VOLUME_ASKED : ScalingParameters.Priority.ONESHOT);
                    continue block18;
                }
                case "priority": {
                    JsonUtil.assertGreaterOrEqualThanReferenceVersion((String)CONTEXT_NAME, (String)"Tag: priority", version, (String)"1.1");
                    parser.nextToken();
                    parameters.setPriority((ScalingParameters.Priority)((Object)JsonUtil.readValue((DeserializationContext)context, (JsonParser)parser, ScalingParameters.Priority.class)));
                    continue block18;
                }
                case "ignoredInjectionIds": {
                    JsonUtil.assertGreaterOrEqualThanReferenceVersion((String)CONTEXT_NAME, (String)"Tag: ignoredInjectionIds", version, (String)"1.2");
                    parameters.setIgnoredInjectionIds(new HashSet<String>(JsonUtil.parseStringArray((JsonParser)parser)));
                    continue block18;
                }
            }
            throw new IllegalStateException("Unexpected field: " + parser.getCurrentName());
        }
        return parameters;
    }
}

