/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification.topology;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.computation.ComputationManager;
import com.powsybl.iidm.modification.AbstractNetworkModification;
import com.powsybl.iidm.modification.topology.NamingStrategy;
import com.powsybl.iidm.modification.topology.TopologyModificationUtils;
import com.powsybl.iidm.modification.util.ModificationLogs;
import com.powsybl.iidm.modification.util.ModificationReports;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.BusbarSection;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.extensions.BusbarSectionPosition;
import com.powsybl.iidm.network.extensions.ConnectablePosition;
import com.powsybl.iidm.network.extensions.ConnectablePositionAdder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.Range;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractCreateConnectableFeederBays
extends AbstractNetworkModification {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractCreateConnectableFeederBays.class);
    protected final int[] sides;

    protected abstract String getBusOrBusbarSectionId(int var1);

    protected abstract void setBus(int var1, Bus var2, String var3);

    protected abstract void setNode(int var1, int var2, String var3);

    protected abstract Connectable<?> add();

    protected abstract VoltageLevel getVoltageLevel(int var1, Connectable<?> var2);

    protected abstract Integer getPositionOrder(int var1);

    protected abstract Optional<String> getFeederName(int var1);

    protected abstract ConnectablePosition.Direction getDirection(int var1);

    protected abstract int getNode(int var1, Connectable<?> var2);

    protected abstract ConnectablePositionAdder.FeederAdder<?> getFeederAdder(int var1, ConnectablePositionAdder<?> var2);

    protected AbstractCreateConnectableFeederBays(int ... sides) {
        this.sides = Arrays.copyOf(sides, sides.length);
    }

    @Override
    public void apply(Network network, NamingStrategy namingStrategy, boolean throwException, ComputationManager computationManager, ReportNode reportNode) {
        if (!this.setAdderConnectivity(network, reportNode, throwException)) {
            return;
        }
        Connectable<?> connectable = this.add();
        if (!AbstractCreateConnectableFeederBays.checkNetworks(connectable, network, reportNode, throwException)) {
            return;
        }
        LOGGER.info("New connectable {} of type {} created", (Object)connectable.getId(), (Object)connectable.getType());
        ModificationReports.createdConnectable(reportNode, connectable);
        this.createExtensionAndTopology(connectable, network, namingStrategy, reportNode);
    }

    private boolean checkOrders(int side, VoltageLevel voltageLevel, ReportNode reportNode, boolean throwException) {
        TopologyKind topologyKind = voltageLevel.getTopologyKind();
        Integer positionOrder = this.getPositionOrder(side);
        if (topologyKind == TopologyKind.NODE_BREAKER) {
            if (positionOrder == null) {
                ModificationReports.unexpectedNullPositionOrder(reportNode, voltageLevel.getId());
                LOGGER.error("Position order is null for attachment in node-breaker voltage level {}", (Object)voltageLevel.getId());
                if (throwException) {
                    throw new PowsyblException("Position order is null for attachment in node-breaker voltage level " + voltageLevel.getId());
                }
                return false;
            }
            if (positionOrder < 0) {
                ModificationReports.unexpectedNegativePositionOrder(reportNode, positionOrder, voltageLevel.getId());
                LOGGER.error("Position order is negative ({}) for attachment in node-breaker voltage level {}", (Object)positionOrder, (Object)voltageLevel.getId());
                if (throwException) {
                    throw new PowsyblException("Position order is negative for attachment in node-breaker voltage level " + voltageLevel.getId() + ": " + positionOrder);
                }
                return false;
            }
        }
        if (positionOrder != null && topologyKind == TopologyKind.BUS_BREAKER) {
            ModificationReports.ignoredPositionOrder(reportNode, positionOrder, voltageLevel);
            LOGGER.warn("Voltage level {} is BUS_BREAKER. Position order {} is ignored", (Object)voltageLevel.getId(), (Object)positionOrder);
        }
        return true;
    }

    private boolean checkOrderValue(int side, BusbarSection busbarSection, Set<Integer> takenFeederPositions, ReportNode reportNode) {
        Integer positionOrder = this.getPositionOrder(side);
        if (takenFeederPositions.contains(positionOrder)) {
            LOGGER.warn("PositionOrder {} already taken. No position extension created.", (Object)positionOrder);
            ModificationReports.positionOrderAlreadyTakenReport(reportNode, positionOrder);
            return false;
        }
        Optional<Range<Integer>> positionRangeForSection = TopologyModificationUtils.getPositionRange(busbarSection);
        if (positionRangeForSection.isEmpty()) {
            LOGGER.warn("Positions of adjacent busbar sections do not leave slots for new positions on busbar section '{}'. No position extension created.", (Object)busbarSection.getId());
            ModificationReports.positionNoSlotLeftByAdjacentBbsReport(reportNode, busbarSection.getId());
            return false;
        }
        int minValue = (Integer)positionRangeForSection.get().getMinimum();
        if (positionOrder < minValue) {
            LOGGER.warn("PositionOrder {} too low (<{}). No position extension created.", (Object)positionOrder, (Object)minValue);
            ModificationReports.positionOrderTooLowReport(reportNode, minValue, positionOrder);
            return false;
        }
        int maxValue = (Integer)positionRangeForSection.get().getMaximum();
        if (positionOrder > maxValue) {
            LOGGER.warn("PositionOrder {} too high (>{}). No position extension created.", (Object)positionOrder, (Object)maxValue);
            ModificationReports.positionOrderTooHighReport(reportNode, maxValue, positionOrder);
            return false;
        }
        return true;
    }

    private boolean setAdderConnectivity(Network network, ReportNode reportNode, boolean throwException) {
        HashMap<VoltageLevel, Integer> firstAvailableNodes = new HashMap<VoltageLevel, Integer>();
        for (int side : this.sides) {
            String busOrBusbarSectionId = this.getBusOrBusbarSectionId(side);
            Identifiable busOrBusbarSection = network.getIdentifiable(busOrBusbarSectionId);
            if (busOrBusbarSection == null) {
                ModificationLogs.busOrBbsDoesNotExist(busOrBusbarSectionId, reportNode, throwException);
                return false;
            }
            if (busOrBusbarSection instanceof Bus) {
                Bus bus = (Bus)busOrBusbarSection;
                this.checkOrders(side, bus.getVoltageLevel(), reportNode, throwException);
                this.setBus(side, bus, bus.getVoltageLevel().getId());
                continue;
            }
            if (busOrBusbarSection instanceof BusbarSection) {
                BusbarSection bbs = (BusbarSection)busOrBusbarSection;
                VoltageLevel voltageLevel = bbs.getTerminal().getVoltageLevel();
                if (!this.checkOrders(side, voltageLevel, reportNode, throwException)) {
                    return false;
                }
                int connectableNode = firstAvailableNodes.compute(voltageLevel, this::getNextAvailableNode);
                this.setNode(side, connectableNode, voltageLevel.getId());
                continue;
            }
            LOGGER.error("Unsupported type {} for identifiable {}", (Object)busOrBusbarSection.getType(), (Object)busOrBusbarSectionId);
            ModificationReports.unsupportedIdentifiableType(reportNode, busOrBusbarSection.getType(), busOrBusbarSectionId);
            if (throwException) {
                throw new PowsyblException(String.format("Unsupported type %s for identifiable %s", busOrBusbarSection.getType(), busOrBusbarSectionId));
            }
            return false;
        }
        return true;
    }

    private int getNextAvailableNode(VoltageLevel vl, Integer node) {
        return node == null ? vl.getNodeBreakerView().getMaximumNodeIndex() + 1 : node + 1;
    }

    private static boolean checkNetworks(Connectable<?> connectable, Network network, ReportNode reportNode, boolean throwException) {
        if (connectable.getNetwork() != network) {
            connectable.remove();
            LOGGER.error("Network given in parameters and in connectableAdder are different. Connectable '{}' of type {} was added then removed", (Object)connectable.getId(), (Object)connectable.getType());
            ModificationReports.networkMismatchReport(reportNode, connectable.getId(), connectable.getType());
            if (throwException) {
                throw new PowsyblException("Network given in parameters and in connectableAdder are different. Connectable was added then removed");
            }
            return false;
        }
        return true;
    }

    private void createExtensionAndTopology(Connectable<?> connectable, Network network, NamingStrategy namingStrategy, ReportNode reportNode) {
        String connectableId = connectable.getId();
        boolean createConnectablePosition = false;
        ConnectablePositionAdder connectablePositionAdder = (ConnectablePositionAdder)connectable.newExtension(ConnectablePositionAdder.class);
        for (int side : this.sides) {
            VoltageLevel voltageLevel = this.getVoltageLevel(side, connectable);
            String busOrBusbarSectionId = this.getBusOrBusbarSectionId(side);
            Identifiable busOrBusbarSection = network.getIdentifiable(busOrBusbarSectionId);
            if (voltageLevel.getTopologyKind() != TopologyKind.NODE_BREAKER) continue;
            Set<Integer> takenFeederPositions = TopologyModificationUtils.getFeederPositions(voltageLevel);
            int positionOrder = this.getPositionOrder(side);
            if (!takenFeederPositions.isEmpty() || voltageLevel.getConnectableStream().filter(c -> !(c instanceof BusbarSection)).count() == 1L) {
                if (this.checkOrderValue(side, (BusbarSection)busOrBusbarSection, takenFeederPositions, reportNode)) {
                    this.getFeederAdder(side, connectablePositionAdder).withDirection(this.getDirection(side)).withOrder(positionOrder).withName(this.getFeederName(side).orElse(connectableId)).add();
                    createConnectablePosition = true;
                }
            } else {
                LOGGER.warn("No order positions found on voltageLevel {}. The extension is not created.", (Object)voltageLevel.getId());
                ModificationReports.noConnectablePositionExtension(reportNode, voltageLevel);
            }
            this.createTopology(side, network, voltageLevel, connectable, namingStrategy, reportNode);
        }
        if (createConnectablePosition) {
            connectablePositionAdder.add();
        }
    }

    private void createTopology(int side, Network network, VoltageLevel voltageLevel, Connectable<?> connectable, NamingStrategy namingStrategy, ReportNode reportNode) {
        int connectableNode = this.getNode(side, connectable);
        int forkNode = voltageLevel.getNodeBreakerView().getMaximumNodeIndex() + 1;
        String baseId = namingStrategy.getSwitchBaseId(connectable, side);
        String bbsId = this.getBusOrBusbarSectionId(side);
        BusbarSection bbs = network.getBusbarSection(bbsId);
        BusbarSectionPosition position = (BusbarSectionPosition)bbs.getExtension(BusbarSectionPosition.class);
        int parallelBbsNumber = 0;
        if (position == null) {
            TopologyModificationUtils.createNodeBreakerSwitchesTopology(voltageLevel, connectableNode, forkNode, namingStrategy, baseId, bbs);
            LOGGER.warn("No busbar section position extension found on {}, only one disconnector is created.", (Object)bbs.getId());
            ModificationReports.noBusbarSectionPositionExtensionReport(reportNode, bbs);
        } else {
            List<BusbarSection> bbsList = TopologyModificationUtils.getParallelBusbarSections(voltageLevel, position);
            parallelBbsNumber = bbsList.size() - 1;
            TopologyModificationUtils.createNodeBreakerSwitchesTopology(voltageLevel, connectableNode, forkNode, namingStrategy, baseId, bbsList, bbs);
        }
        LOGGER.info("New feeder bay associated to {} of type {} was created and connected to voltage level {} on busbar section {} with a closed disconnector and on {} parallel busbar sections with an open disconnector.", new Object[]{connectable.getId(), connectable.getType(), voltageLevel.getId(), bbsId, parallelBbsNumber});
        ModificationReports.createdNodeBreakerFeederBay(reportNode, voltageLevel.getId(), bbsId, connectable, parallelBbsNumber);
    }
}

