/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification.topology;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.computation.ComputationManager;
import com.powsybl.iidm.modification.AbstractNetworkModification;
import com.powsybl.iidm.modification.topology.NamingStrategy;
import com.powsybl.iidm.modification.topology.RemoveFeederBayBuilder;
import com.powsybl.iidm.modification.topology.RemoveHvdcLineBuilder;
import com.powsybl.iidm.modification.util.ModificationReports;
import com.powsybl.iidm.network.HvdcConverterStation;
import com.powsybl.iidm.network.Injection;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.VoltageLevel;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveVoltageLevel
extends AbstractNetworkModification {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoveVoltageLevel.class);
    private final String voltageLevelId;

    public RemoveVoltageLevel(String voltageLevelId) {
        this.voltageLevelId = Objects.requireNonNull(voltageLevelId);
    }

    @Override
    public void apply(Network network, NamingStrategy namingStrategy, boolean throwException, ComputationManager computationManager, ReportNode reportNode) {
        VoltageLevel voltageLevel = network.getVoltageLevel(this.voltageLevelId);
        if (voltageLevel == null) {
            LOGGER.error("Voltage level {} not found", (Object)this.voltageLevelId);
            ModificationReports.notFoundVoltageLevelReport(reportNode, this.voltageLevelId);
            if (throwException) {
                throw new PowsyblException("Voltage level not found: " + this.voltageLevelId);
            }
            return;
        }
        voltageLevel.getConnectables(HvdcConverterStation.class).forEach(hcs -> {
            if (hcs.getHvdcLine() != null) {
                new RemoveHvdcLineBuilder().withHvdcLineId(hcs.getHvdcLine().getId()).build().apply(network, throwException, computationManager, reportNode);
            }
        });
        voltageLevel.getConnectables().forEach(connectable -> {
            if (connectable instanceof Injection) {
                String connectableId = connectable.getId();
                connectable.remove();
                ModificationReports.removedConnectableReport(reportNode, connectableId);
                LOGGER.info("Connectable {} removed", (Object)connectableId);
            } else {
                new RemoveFeederBayBuilder().withConnectableId(connectable.getId()).build().apply(network, throwException, computationManager, reportNode);
            }
        });
        voltageLevel.remove();
        ModificationReports.removedVoltageLevelReport(reportNode, this.voltageLevelId);
        LOGGER.info("Voltage level {}, its equipments and the branches it is connected to have been removed", (Object)this.voltageLevelId);
    }
}

