/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification.scalable;

import com.powsybl.iidm.modification.scalable.AbstractScalable;
import com.powsybl.iidm.modification.scalable.Scalable;
import com.powsybl.iidm.network.Injection;
import com.powsybl.iidm.network.Network;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

abstract class AbstractCompoundScalable
extends AbstractScalable {
    protected double minValue = -1.7976931348623157E308;
    protected double maxValue = Double.MAX_VALUE;

    AbstractCompoundScalable() {
    }

    abstract Collection<Scalable> getScalables();

    @Override
    public double initialValue(Network n) {
        Objects.requireNonNull(n);
        double value = 0.0;
        for (Scalable scalable : this.getScalables()) {
            value += scalable.initialValue(n);
        }
        return value;
    }

    @Override
    public void reset(Network n) {
        Objects.requireNonNull(n);
        this.getScalables().forEach(scalable -> scalable.reset(n));
    }

    @Override
    public double maximumValue(Network n) {
        return this.maximumValue(n, Scalable.ScalingConvention.GENERATOR);
    }

    @Override
    public double maximumValue(Network n, Scalable.ScalingConvention powerConvention) {
        Objects.requireNonNull(n);
        Objects.requireNonNull(powerConvention);
        double value = 0.0;
        for (Scalable scalable : this.getScalables()) {
            value += scalable.maximumValue(n, powerConvention);
        }
        return powerConvention == Scalable.ScalingConvention.GENERATOR ? Math.min(this.maxValue, value) : Math.min(-this.minValue, value);
    }

    @Override
    public double minimumValue(Network n) {
        return this.minimumValue(n, Scalable.ScalingConvention.GENERATOR);
    }

    @Override
    public double minimumValue(Network n, Scalable.ScalingConvention powerConvention) {
        Objects.requireNonNull(n);
        double value = 0.0;
        for (Scalable scalable : this.getScalables()) {
            value += scalable.minimumValue(n, powerConvention);
        }
        return powerConvention == Scalable.ScalingConvention.GENERATOR ? Math.max(this.minValue, value) : Math.max(-this.maxValue, value);
    }

    @Override
    public void filterInjections(Network n, List<Injection> injections, List<String> notFoundInjections) {
        for (Scalable scalable : this.getScalables()) {
            scalable.filterInjections(n, injections, notFoundInjections);
        }
    }

    protected double getBoundedVariation(double variationAsked, double currentGlobalPower, Scalable.ScalingConvention scalingConvention) {
        double minWithConvention = scalingConvention == Scalable.ScalingConvention.GENERATOR ? this.minValue : -this.maxValue;
        double maxWithConvention = scalingConvention == Scalable.ScalingConvention.GENERATOR ? this.maxValue : -this.minValue;
        return Math.min(maxWithConvention - currentGlobalPower, Math.max(minWithConvention - currentGlobalPower, variationAsked));
    }
}

