/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.computation.ComputationManager;
import com.powsybl.iidm.modification.AbstractNetworkModification;
import com.powsybl.iidm.modification.NetworkModificationImpact;
import com.powsybl.iidm.modification.topology.NamingStrategy;
import com.powsybl.iidm.modification.util.VoltageRegulationUtils;
import com.powsybl.iidm.network.IdentifiableType;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.ShuntCompensator;
import com.powsybl.iidm.network.Terminal;
import java.util.Objects;

public class ShuntCompensatorModification
extends AbstractNetworkModification {
    private final String shuntCompensatorId;
    private final Boolean connect;
    private final Integer sectionCount;

    public ShuntCompensatorModification(String shuntCompensatorId, Boolean connect, Integer sectionCount) {
        this.shuntCompensatorId = Objects.requireNonNull(shuntCompensatorId);
        this.connect = connect;
        this.sectionCount = sectionCount;
    }

    @Override
    public String getName() {
        return "ShuntCompensatorModification";
    }

    @Override
    public void apply(Network network, NamingStrategy namingStrategy, boolean throwException, ComputationManager computationManager, ReportNode reportNode) {
        ShuntCompensator shuntCompensator = network.getShuntCompensator(this.shuntCompensatorId);
        if (shuntCompensator == null) {
            this.logOrThrow(throwException, "Shunt Compensator '" + this.shuntCompensatorId + "' not found");
            return;
        }
        if (this.connect != null) {
            Terminal t = shuntCompensator.getTerminal();
            if (this.connect.booleanValue()) {
                t.connect();
                ShuntCompensatorModification.setTargetV(shuntCompensator);
            } else {
                t.disconnect();
            }
        }
        if (this.sectionCount != null) {
            shuntCompensator.setSectionCount(this.sectionCount.intValue());
        }
    }

    @Override
    public NetworkModificationImpact hasImpactOnNetwork(Network network) {
        this.impact = DEFAULT_IMPACT;
        ShuntCompensator shuntCompensator = network.getShuntCompensator(this.shuntCompensatorId);
        if (shuntCompensator == null || this.sectionCount != null && (this.sectionCount > shuntCompensator.getMaximumSectionCount() || this.sectionCount < 0)) {
            this.impact = NetworkModificationImpact.CANNOT_BE_APPLIED;
        } else if (!(this.connect != null && this.connect.booleanValue() != shuntCompensator.getTerminal().isConnected() || this.sectionCount != null && this.sectionCount.intValue() != shuntCompensator.getSectionCount())) {
            this.impact = NetworkModificationImpact.NO_IMPACT_ON_NETWORK;
        }
        return this.impact;
    }

    private static void setTargetV(ShuntCompensator shuntCompensator) {
        if (shuntCompensator.isVoltageRegulatorOn()) {
            VoltageRegulationUtils.getTargetVForRegulatingElement(shuntCompensator.getNetwork(), shuntCompensator.getRegulatingTerminal().getBusView().getBus(), shuntCompensator.getId(), IdentifiableType.SHUNT_COMPENSATOR).ifPresent(arg_0 -> ((ShuntCompensator)shuntCompensator).setTargetV(arg_0));
        }
    }

    public Boolean getConnect() {
        return this.connect;
    }

    public Integer getSectionCount() {
        return this.sectionCount;
    }

    public String getShuntCompensatorId() {
        return this.shuntCompensatorId;
    }
}

