/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification.topology;

import com.powsybl.iidm.modification.AbstractNetworkModification;
import com.powsybl.iidm.modification.NetworkModificationImpact;
import com.powsybl.iidm.modification.topology.TopologyModificationUtils;
import com.powsybl.iidm.network.Line;
import com.powsybl.iidm.network.Network;
import java.util.Objects;

public abstract class AbstractLineDisconnectionModification<M extends AbstractLineDisconnectionModification<M>>
extends AbstractNetworkModification {
    protected String oldLine1Id;
    protected String oldLine2Id;
    protected String lineToRemoveId;

    protected AbstractLineDisconnectionModification(String oldLine1Id, String oldLine2Id, String lineToRemoveId) {
        this.oldLine1Id = Objects.requireNonNull(oldLine1Id);
        this.oldLine2Id = Objects.requireNonNull(oldLine2Id);
        this.lineToRemoveId = Objects.requireNonNull(lineToRemoveId);
    }

    @Override
    public NetworkModificationImpact hasImpactOnNetwork(Network network) {
        this.impact = DEFAULT_IMPACT;
        Line line1Id = network.getLine(this.oldLine1Id);
        Line line2Id = network.getLine(this.oldLine2Id);
        Line lineToBeDeleted = network.getLine(this.lineToRemoveId);
        if (line1Id == null || line2Id == null || lineToBeDeleted == null || TopologyModificationUtils.findTeePoint(line1Id, line2Id, lineToBeDeleted) == null) {
            this.impact = NetworkModificationImpact.CANNOT_BE_APPLIED;
        }
        return this.impact;
    }
}

