/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.iidm.modification.AbstractConnectDisconnectModification;
import com.powsybl.iidm.modification.util.ModificationReports;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.HvdcLine;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.ThreeSides;
import com.powsybl.iidm.network.TieLine;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDisconnection
extends AbstractConnectDisconnectModification {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDisconnection.class);
    final Predicate<Switch> openableSwitches;

    AbstractDisconnection(String identifiableId, Predicate<Switch> openableSwitches, ThreeSides side) {
        super(identifiableId, side, false);
        this.openableSwitches = openableSwitches;
    }

    public void applyModification(Network network, boolean isPlanned, boolean throwException, ReportNode reportNode) {
        network.getReportNodeContext().pushReportNode(reportNode);
        Identifiable identifiable = network.getIdentifiable(this.identifiableId);
        if (identifiable == null) {
            this.logOrThrow(throwException, "Identifiable '" + this.identifiableId + "' not found");
        } else {
            this.disconnectIdentifiable(identifiable, network, isPlanned, throwException, reportNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnectIdentifiable(Identifiable<?> identifiable, Network network, boolean isPlanned, boolean throwException, ReportNode reportNode) {
        boolean hasBeenDisconnected;
        try {
            hasBeenDisconnected = this.disconnect(identifiable, throwException);
        }
        finally {
            network.getReportNodeContext().popReportNode();
        }
        if (hasBeenDisconnected) {
            LOG.info("Identifiable {} has been disconnected ({} disconnection) {}.", new Object[]{this.identifiableId, isPlanned ? "planned" : "unplanned", this.side == null ? "on each side" : "on side " + this.side.getNum()});
        } else {
            LOG.info("Identifiable {} has NOT been disconnected ({} disconnection) {}.", new Object[]{this.identifiableId, isPlanned ? "planned" : "unplanned", this.side == null ? "on each side" : "on side " + this.side.getNum()});
        }
        ModificationReports.identifiableDisconnectionReport(reportNode, identifiable, hasBeenDisconnected, isPlanned, this.side);
    }

    private boolean disconnect(Identifiable<?> identifiable, boolean throwException) {
        boolean hasBeenDisconnected = false;
        if (identifiable instanceof Connectable) {
            Connectable connectable = (Connectable)identifiable;
            hasBeenDisconnected = connectable.disconnect(this.openableSwitches, this.side);
        } else if (identifiable instanceof TieLine) {
            TieLine tieLine = (TieLine)identifiable;
            hasBeenDisconnected = tieLine.disconnectDanglingLines(this.openableSwitches, this.side == null ? null : this.side.toTwoSides());
        } else if (identifiable instanceof HvdcLine) {
            HvdcLine hvdcLine = (HvdcLine)identifiable;
            hasBeenDisconnected = hvdcLine.disconnectConverterStations(this.openableSwitches, this.side == null ? null : this.side.toTwoSides());
        } else {
            this.logOrThrow(throwException, String.format("Disconnection not implemented for identifiable '%s'", this.identifiableId));
        }
        return hasBeenDisconnected;
    }
}

