/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.computation.ComputationManager;
import com.powsybl.iidm.modification.AbstractNetworkModification;
import com.powsybl.iidm.modification.NetworkModificationImpact;
import com.powsybl.iidm.modification.topology.NamingStrategy;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.PhaseTapChanger;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import java.util.Objects;

public class PhaseShifterSetAsFixedTap
extends AbstractNetworkModification {
    private final String phaseShifterId;
    private final int tapPosition;

    public PhaseShifterSetAsFixedTap(String phaseShifterId, int tapPosition) {
        this.phaseShifterId = Objects.requireNonNull(phaseShifterId);
        this.tapPosition = tapPosition;
    }

    @Override
    public String getName() {
        return "PhaseShifterSetAsFixedTap";
    }

    @Override
    public void apply(Network network, NamingStrategy namingStrategy, boolean throwException, ComputationManager computationManager, ReportNode reportNode) {
        Objects.requireNonNull(network);
        TwoWindingsTransformer phaseShifter = network.getTwoWindingsTransformer(this.phaseShifterId);
        if (phaseShifter == null) {
            throw new PowsyblException("Transformer '" + this.phaseShifterId + "' not found");
        }
        if (!phaseShifter.hasPhaseTapChanger()) {
            throw new PowsyblException("Transformer '" + this.phaseShifterId + "' is not a phase shifter");
        }
        phaseShifter.getPhaseTapChanger().setTapPosition(this.tapPosition);
        phaseShifter.getPhaseTapChanger().setRegulating(false);
        phaseShifter.getPhaseTapChanger().setRegulationMode(PhaseTapChanger.RegulationMode.FIXED_TAP);
    }

    @Override
    public NetworkModificationImpact hasImpactOnNetwork(Network network) {
        this.impact = DEFAULT_IMPACT;
        TwoWindingsTransformer phaseShifter = network.getTwoWindingsTransformer(this.phaseShifterId);
        if (phaseShifter == null || !phaseShifter.hasPhaseTapChanger() || this.tapPosition > phaseShifter.getPhaseTapChanger().getHighTapPosition() || this.tapPosition < phaseShifter.getPhaseTapChanger().getLowTapPosition()) {
            this.impact = NetworkModificationImpact.CANNOT_BE_APPLIED;
        } else if (this.areValuesEqual(this.tapPosition, phaseShifter.getPhaseTapChanger().getTapPosition(), false) && !phaseShifter.getPhaseTapChanger().isRegulating() && phaseShifter.getPhaseTapChanger().getRegulationMode() == PhaseTapChanger.RegulationMode.FIXED_TAP) {
            this.impact = NetworkModificationImpact.NO_IMPACT_ON_NETWORK;
        }
        return this.impact;
    }
}

