/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification;

import com.powsybl.commons.extensions.Extension;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.computation.ComputationManager;
import com.powsybl.iidm.modification.AbstractNetworkModification;
import com.powsybl.iidm.modification.topology.NamingStrategy;
import com.powsybl.iidm.modification.util.ModificationReports;
import com.powsybl.iidm.modification.util.RegulatedTerminalControllers;
import com.powsybl.iidm.modification.util.TransformerUtils;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.BusAdder;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.PhaseTapChanger;
import com.powsybl.iidm.network.RatioTapChanger;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.ThreeSides;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.iidm.network.TwoWindingsTransformerAdder;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.VoltageLevelAdder;
import com.powsybl.iidm.network.extensions.ThreeWindingsTransformerFortescue;
import com.powsybl.iidm.network.extensions.ThreeWindingsTransformerPhaseAngleClock;
import com.powsybl.iidm.network.extensions.ThreeWindingsTransformerToBeEstimated;
import com.powsybl.iidm.network.extensions.TwoWindingsTransformerFortescueAdder;
import com.powsybl.iidm.network.extensions.TwoWindingsTransformerPhaseAngleClockAdder;
import com.powsybl.iidm.network.extensions.TwoWindingsTransformerToBeEstimatedAdder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplaceThreeWindingsTransformersBy3TwoWindingsTransformers
extends AbstractNetworkModification {
    private static final Logger LOG = LoggerFactory.getLogger(ReplaceThreeWindingsTransformersBy3TwoWindingsTransformers.class);
    private static final String THREE_WINDINGS_TRANSFORMER = "ThreeWindingsTransformer";
    private static final String CGMES_OPERATIONAL_LIMIT_SET = "CGMES.OperationalLimitSet_";
    private final List<String> transformersToBeReplaced;

    public ReplaceThreeWindingsTransformersBy3TwoWindingsTransformers() {
        this.transformersToBeReplaced = null;
    }

    public ReplaceThreeWindingsTransformersBy3TwoWindingsTransformers(List<String> transformersToBeReplaced) {
        this.transformersToBeReplaced = Objects.requireNonNull(transformersToBeReplaced);
    }

    @Override
    public String getName() {
        return "ReplaceThreeWindingsTransformersBy3TwoWindingsTransformers";
    }

    @Override
    public void apply(Network network, NamingStrategy namingStrategy, boolean throwException, ComputationManager computationManager, ReportNode reportNode) {
        RegulatedTerminalControllers regulatedTerminalControllers = new RegulatedTerminalControllers(network);
        network.getThreeWindingsTransformerStream().filter(t3w -> ReplaceThreeWindingsTransformersBy3TwoWindingsTransformers.isGoingToBeReplaced(this.transformersToBeReplaced, t3w.getId())).toList().forEach(t3w -> this.replaceThreeWindingsTransformerBy3TwoWindingsTransformer((ThreeWindingsTransformer)t3w, regulatedTerminalControllers, throwException, reportNode));
    }

    private static boolean isGoingToBeReplaced(List<String> transformersToBeReplaced, String t3wId) {
        return transformersToBeReplaced == null || transformersToBeReplaced.contains(t3wId);
    }

    private void replaceThreeWindingsTransformerBy3TwoWindingsTransformer(ThreeWindingsTransformer t3w, RegulatedTerminalControllers regulatedTerminalControllers, boolean throwException, ReportNode reportNode) {
        VoltageLevel starVoltageLevel = this.createStarVoltageLevel(t3w, throwException);
        if (starVoltageLevel == null) {
            return;
        }
        ReplaceThreeWindingsTransformersBy3TwoWindingsTransformers.createTopologyInsideStarVoltageLevel(t3w, starVoltageLevel);
        TwoWindingsTransformer t2wLeg1 = ReplaceThreeWindingsTransformersBy3TwoWindingsTransformers.createTwoWindingsTransformer(t3w, t3w.getLeg1(), starVoltageLevel);
        TwoWindingsTransformer t2wLeg2 = ReplaceThreeWindingsTransformersBy3TwoWindingsTransformers.createTwoWindingsTransformer(t3w, t3w.getLeg2(), starVoltageLevel);
        TwoWindingsTransformer t2wLeg3 = ReplaceThreeWindingsTransformersBy3TwoWindingsTransformers.createTwoWindingsTransformer(t3w, t3w.getLeg3(), starVoltageLevel);
        ThreeT2wsR threeT2ws = new ThreeT2wsR(t2wLeg1, t2wLeg2, t2wLeg3);
        regulatedTerminalControllers.replaceRegulatedTerminal(t3w.getLeg1().getTerminal(), threeT2ws.t2wOne.getTerminal1());
        regulatedTerminalControllers.replaceRegulatedTerminal(t3w.getLeg2().getTerminal(), threeT2ws.t2wTwo.getTerminal1());
        regulatedTerminalControllers.replaceRegulatedTerminal(t3w.getLeg3().getTerminal(), threeT2ws.t2wThree.getTerminal1());
        ReplaceThreeWindingsTransformersBy3TwoWindingsTransformers.replaceRegulatedTerminal(threeT2ws.t2wOne, t3w, threeT2ws);
        ReplaceThreeWindingsTransformersBy3TwoWindingsTransformers.replaceRegulatedTerminal(threeT2ws.t2wTwo, t3w, threeT2ws);
        ReplaceThreeWindingsTransformersBy3TwoWindingsTransformers.replaceRegulatedTerminal(threeT2ws.t2wThree, t3w, threeT2ws);
        TransformerUtils.copyTerminalActiveAndReactivePower(threeT2ws.t2wOne.getTerminal1(), t3w.getLeg1().getTerminal());
        TransformerUtils.copyTerminalActiveAndReactivePower(threeT2ws.t2wTwo.getTerminal1(), t3w.getLeg2().getTerminal());
        TransformerUtils.copyTerminalActiveAndReactivePower(threeT2ws.t2wThree.getTerminal1(), t3w.getLeg3().getTerminal());
        List<String> lostProperties = ReplaceThreeWindingsTransformersBy3TwoWindingsTransformers.copyProperties(t3w, threeT2ws, starVoltageLevel);
        List<String> lostExtensions = ReplaceThreeWindingsTransformersBy3TwoWindingsTransformers.copyExtensions(t3w, threeT2ws);
        String t3wId = t3w.getId();
        List<AliasR> t3wAliases = ReplaceThreeWindingsTransformersBy3TwoWindingsTransformers.getAliases(t3w);
        t3w.remove();
        List<AliasR> lostAliases = ReplaceThreeWindingsTransformersBy3TwoWindingsTransformers.copyAliases(t3wAliases, threeT2ws);
        if (!lostProperties.isEmpty()) {
            lostProperties.forEach(propertyName -> LOG.warn("Property '{}' of threeWindingsTransformer '{}' was not transferred", propertyName, (Object)t3wId));
        }
        if (!lostExtensions.isEmpty()) {
            lostExtensions.forEach(extensionName -> LOG.warn("Extension '{}' of threeWindingsTransformer '{}' was not transferred", extensionName, (Object)t3wId));
        }
        if (!lostAliases.isEmpty()) {
            lostAliases.forEach(aliasR -> LOG.warn("Alias '{}' '{}' of threeWindingsTransformer '{}' was not transferred", new Object[]{aliasR.alias, aliasR.aliasType, t3wId}));
        }
        ReplaceThreeWindingsTransformersBy3TwoWindingsTransformers.createReportNode(reportNode, t3wId, lostProperties, lostExtensions, lostAliases, starVoltageLevel.getId(), threeT2ws);
    }

    private VoltageLevel createStarVoltageLevel(ThreeWindingsTransformer t3w, boolean throwException) {
        Optional substation = t3w.getSubstation();
        if (substation.isEmpty()) {
            this.logOrThrow(throwException, "ThreeWindingsTransformer'" + t3w.getId() + "' without substation");
            return null;
        }
        TopologyKind topologykind = t3w.getLeg1().getTerminal().getVoltageLevel().getTopologyKind() == TopologyKind.BUS_BREAKER && t3w.getLeg2().getTerminal().getVoltageLevel().getTopologyKind() == TopologyKind.BUS_BREAKER && t3w.getLeg3().getTerminal().getVoltageLevel().getTopologyKind() == TopologyKind.BUS_BREAKER ? TopologyKind.BUS_BREAKER : TopologyKind.NODE_BREAKER;
        return ((VoltageLevelAdder)((VoltageLevelAdder)((Substation)substation.get()).newVoltageLevel().setId(t3w.getId() + "-Star-VL")).setName(t3w.getNameOrId() + "-Star-VL")).setNominalV(t3w.getRatedU0()).setTopologyKind(topologykind).add();
    }

    private static void createTopologyInsideStarVoltageLevel(ThreeWindingsTransformer t3w, VoltageLevel starVoltageLevel) {
        if (starVoltageLevel.getTopologyKind() == TopologyKind.BUS_BREAKER) {
            ((BusAdder)((BusAdder)starVoltageLevel.getBusBreakerView().newBus().setId(t3w.getId() + "-Star-Bus")).setName(t3w.getNameOrId() + "-Star-Bus")).add();
        } else {
            starVoltageLevel.getNodeBreakerView().newInternalConnection().setNode1(1).setNode2(0).add();
            starVoltageLevel.getNodeBreakerView().newInternalConnection().setNode1(2).setNode2(0).add();
            starVoltageLevel.getNodeBreakerView().newInternalConnection().setNode1(3).setNode2(0).add();
        }
    }

    private static TwoWindingsTransformer createTwoWindingsTransformer(ThreeWindingsTransformer t3w, ThreeWindingsTransformer.Leg leg, VoltageLevel starVoltageLevel) {
        TwoWindingsTransformerAdder t2wAdder = (TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((Substation)starVoltageLevel.getSubstation().orElseThrow()).newTwoWindingsTransformer().setEnsureIdUnicity(true)).setId(t3w.getId() + "-Leg" + leg.getSide().getNum())).setName(t3w.getNameOrId() + "-Leg" + leg.getSide().getNum())).setRatedU1(leg.getRatedU()).setRatedU2(starVoltageLevel.getNominalV()).setR(leg.getR()).setX(leg.getX()).setG(leg.getG()).setB(leg.getB()).setRatedS(leg.getRatedS()).setVoltageLevel1(leg.getTerminal().getVoltageLevel().getId())).setVoltageLevel2(starVoltageLevel.getId());
        ReplaceThreeWindingsTransformersBy3TwoWindingsTransformers.connect(t2wAdder, ReplaceThreeWindingsTransformersBy3TwoWindingsTransformers.getConnectivityLegAfterCreatingInternalConnection(leg), ReplaceThreeWindingsTransformersBy3TwoWindingsTransformers.getConnectivityStar(leg.getSide().getNum(), starVoltageLevel));
        TwoWindingsTransformer t2w = t2wAdder.add();
        leg.getOptionalRatioTapChanger().ifPresent(rtc -> TransformerUtils.copyAndAddRatioTapChanger(t2w.newRatioTapChanger(), rtc));
        leg.getOptionalPhaseTapChanger().ifPresent(rtc -> TransformerUtils.copyAndAddPhaseTapChanger(t2w.newPhaseTapChanger(), rtc));
        leg.getOperationalLimitsGroups().forEach(operationalLimitGroup -> TransformerUtils.copyOperationalLimitsGroup(t2w.newOperationalLimitsGroup1(operationalLimitGroup.getId()), operationalLimitGroup));
        return t2w;
    }

    private static void connect(TwoWindingsTransformerAdder t2wAdder, ConnectivityR connectivityEnd1, ConnectivityR connectivityEnd2) {
        if (connectivityEnd1.node != null) {
            t2wAdder.setNode1(connectivityEnd1.node.intValue());
        } else {
            t2wAdder.setConnectableBus1(connectivityEnd1.connectableBus.getId());
            if (connectivityEnd1.bus != null) {
                t2wAdder.setBus1(connectivityEnd1.bus.getId());
            }
        }
        if (connectivityEnd2.node != null) {
            t2wAdder.setNode2(connectivityEnd2.node.intValue());
        } else {
            t2wAdder.setConnectableBus2(connectivityEnd2.connectableBus.getId());
            if (connectivityEnd2.bus != null) {
                t2wAdder.setBus2(connectivityEnd2.bus.getId());
            }
        }
    }

    private static ConnectivityR getConnectivityLegAfterCreatingInternalConnection(ThreeWindingsTransformer.Leg leg) {
        if (leg.getTerminal().getVoltageLevel().getTopologyKind() == TopologyKind.NODE_BREAKER) {
            int newNode = leg.getTerminal().getVoltageLevel().getNodeBreakerView().getMaximumNodeIndex() + 1;
            leg.getTerminal().getVoltageLevel().getNodeBreakerView().newInternalConnection().setNode1(leg.getTerminal().getNodeBreakerView().getNode()).setNode2(newNode).add();
            return new ConnectivityR(newNode, null, null);
        }
        return new ConnectivityR(null, leg.getTerminal().getBusBreakerView().getBus(), leg.getTerminal().getBusBreakerView().getConnectableBus());
    }

    private static ConnectivityR getConnectivityStar(int node, VoltageLevel startVoltageLevel) {
        if (startVoltageLevel.getTopologyKind() == TopologyKind.NODE_BREAKER) {
            return new ConnectivityR(node, null, null);
        }
        Bus bus = (Bus)startVoltageLevel.getBusBreakerView().getBuses().iterator().next();
        return new ConnectivityR(null, bus, bus);
    }

    private static void replaceRegulatedTerminal(TwoWindingsTransformer t2w, ThreeWindingsTransformer t3w, ThreeT2wsR threeT2ws) {
        t2w.getOptionalRatioTapChanger().ifPresent(rtc -> ReplaceThreeWindingsTransformersBy3TwoWindingsTransformers.findNewRegulatedTerminal(rtc.getRegulationTerminal(), t3w, threeT2ws).ifPresent(arg_0 -> ((RatioTapChanger)rtc).setRegulationTerminal(arg_0)));
        t2w.getOptionalPhaseTapChanger().ifPresent(ptc -> ReplaceThreeWindingsTransformersBy3TwoWindingsTransformers.findNewRegulatedTerminal(ptc.getRegulationTerminal(), t3w, threeT2ws).ifPresent(arg_0 -> ((PhaseTapChanger)ptc).setRegulationTerminal(arg_0)));
    }

    private static Optional<Terminal> findNewRegulatedTerminal(Terminal regulatedTerminal, ThreeWindingsTransformer t3w, ThreeT2wsR threeT2ws) {
        if (regulatedTerminal != null && regulatedTerminal.getConnectable().getId().equals(t3w.getId())) {
            return switch (regulatedTerminal.getSide()) {
                default -> throw new IncompatibleClassChangeError();
                case ThreeSides.ONE -> Optional.of(threeT2ws.t2wOne.getTerminal1());
                case ThreeSides.TWO -> Optional.of(threeT2ws.t2wTwo.getTerminal1());
                case ThreeSides.THREE -> Optional.of(threeT2ws.t2wThree.getTerminal1());
            };
        }
        return Optional.empty();
    }

    private static List<String> copyProperties(ThreeWindingsTransformer t3w, ThreeT2wsR threeT2ws, VoltageLevel starVoltageLevel) {
        ArrayList<String> lostProperties = new ArrayList<String>();
        t3w.getPropertyNames().forEach(propertyName -> {
            boolean copied = ReplaceThreeWindingsTransformersBy3TwoWindingsTransformers.copyProperty(propertyName, t3w.getProperty(propertyName), threeT2ws, starVoltageLevel);
            if (!copied) {
                lostProperties.add((String)propertyName);
            }
        });
        return lostProperties;
    }

    private static boolean copyProperty(String propertyName, String property, ThreeT2wsR threeT2ws, VoltageLevel starVoltageLevel) {
        boolean copied = true;
        if ("v".equals(propertyName)) {
            ((Bus)starVoltageLevel.getBusView().getBuses().iterator().next()).setV(Double.parseDouble(property));
        } else if ("angle".equals(propertyName)) {
            ((Bus)starVoltageLevel.getBusView().getBuses().iterator().next()).setAngle(Double.parseDouble(property));
        } else if (propertyName.startsWith(CGMES_OPERATIONAL_LIMIT_SET)) {
            if (threeT2ws.t2wOne.getOperationalLimitsGroups1().stream().anyMatch(operationalLimitsGroup -> propertyName.equals(CGMES_OPERATIONAL_LIMIT_SET + operationalLimitsGroup.getId()))) {
                threeT2ws.t2wOne.setProperty(propertyName, property);
            } else if (threeT2ws.t2wTwo.getOperationalLimitsGroups1().stream().anyMatch(operationalLimitsGroup -> propertyName.equals(CGMES_OPERATIONAL_LIMIT_SET + operationalLimitsGroup.getId()))) {
                threeT2ws.t2wTwo.setProperty(propertyName, property);
            } else if (threeT2ws.t2wThree.getOperationalLimitsGroups1().stream().anyMatch(operationalLimitsGroup -> propertyName.equals(CGMES_OPERATIONAL_LIMIT_SET + operationalLimitsGroup.getId()))) {
                threeT2ws.t2wThree.setProperty(propertyName, property);
            } else {
                copied = false;
            }
        } else {
            threeT2ws.t2wOne.setProperty(propertyName, property);
            threeT2ws.t2wTwo.setProperty(propertyName, property);
            threeT2ws.t2wThree.setProperty(propertyName, property);
        }
        return copied;
    }

    private static List<String> copyExtensions(ThreeWindingsTransformer t3w, ThreeT2wsR threeT2w) {
        ArrayList<String> lostExtensions = new ArrayList<String>();
        t3w.getExtensions().stream().map(Extension::getName).forEach(extensionName -> {
            boolean copied = ReplaceThreeWindingsTransformersBy3TwoWindingsTransformers.copyExtension(extensionName, t3w, threeT2w);
            if (!copied) {
                lostExtensions.add((String)extensionName);
            }
        });
        return lostExtensions;
    }

    private static boolean copyExtension(String extensionName, ThreeWindingsTransformer t3w, ThreeT2wsR threeT2ws) {
        boolean copied = true;
        switch (extensionName) {
            case "threeWindingsTransformerFortescue": {
                ThreeWindingsTransformerFortescue extension = (ThreeWindingsTransformerFortescue)t3w.getExtension(ThreeWindingsTransformerFortescue.class);
                TransformerUtils.copyAndAddFortescue((TwoWindingsTransformerFortescueAdder)threeT2ws.t2wOne.newExtension(TwoWindingsTransformerFortescueAdder.class), extension.getLeg1());
                TransformerUtils.copyAndAddFortescue((TwoWindingsTransformerFortescueAdder)threeT2ws.t2wTwo.newExtension(TwoWindingsTransformerFortescueAdder.class), extension.getLeg2());
                TransformerUtils.copyAndAddFortescue((TwoWindingsTransformerFortescueAdder)threeT2ws.t2wThree.newExtension(TwoWindingsTransformerFortescueAdder.class), extension.getLeg3());
                break;
            }
            case "threeWindingsTransformerPhaseAngleClock": {
                ThreeWindingsTransformerPhaseAngleClock extension = (ThreeWindingsTransformerPhaseAngleClock)t3w.getExtension(ThreeWindingsTransformerPhaseAngleClock.class);
                TransformerUtils.copyAndAddPhaseAngleClock((TwoWindingsTransformerPhaseAngleClockAdder)threeT2ws.t2wTwo.newExtension(TwoWindingsTransformerPhaseAngleClockAdder.class), extension.getPhaseAngleClockLeg2());
                TransformerUtils.copyAndAddPhaseAngleClock((TwoWindingsTransformerPhaseAngleClockAdder)threeT2ws.t2wThree.newExtension(TwoWindingsTransformerPhaseAngleClockAdder.class), extension.getPhaseAngleClockLeg3());
                break;
            }
            case "threeWindingsTransformerToBeEstimated": {
                ThreeWindingsTransformerToBeEstimated extension = (ThreeWindingsTransformerToBeEstimated)t3w.getExtension(ThreeWindingsTransformerToBeEstimated.class);
                TransformerUtils.copyAndAddToBeEstimated((TwoWindingsTransformerToBeEstimatedAdder)threeT2ws.t2wOne.newExtension(TwoWindingsTransformerToBeEstimatedAdder.class), extension.shouldEstimateRatioTapChanger1(), extension.shouldEstimatePhaseTapChanger1());
                TransformerUtils.copyAndAddToBeEstimated((TwoWindingsTransformerToBeEstimatedAdder)threeT2ws.t2wTwo.newExtension(TwoWindingsTransformerToBeEstimatedAdder.class), extension.shouldEstimateRatioTapChanger2(), extension.shouldEstimatePhaseTapChanger2());
                TransformerUtils.copyAndAddToBeEstimated((TwoWindingsTransformerToBeEstimatedAdder)threeT2ws.t2wThree.newExtension(TwoWindingsTransformerToBeEstimatedAdder.class), extension.shouldEstimateRatioTapChanger3(), extension.shouldEstimatePhaseTapChanger3());
                break;
            }
            default: {
                copied = false;
            }
        }
        return copied;
    }

    private static List<AliasR> getAliases(ThreeWindingsTransformer t3w) {
        return t3w.getAliases().stream().map(alias -> new AliasR((String)alias, t3w.getAliasType(alias).orElse(""))).toList();
    }

    private static List<AliasR> copyAliases(List<AliasR> t3wAliases, ThreeT2wsR threeT2w) {
        ArrayList<AliasR> lostAliases = new ArrayList<AliasR>();
        t3wAliases.forEach(aliasR -> {
            boolean copied = ReplaceThreeWindingsTransformersBy3TwoWindingsTransformers.copyAlias(aliasR.alias, aliasR.aliasType, threeT2w);
            if (!copied) {
                lostAliases.add((AliasR)aliasR);
            }
        });
        return lostAliases;
    }

    private static boolean copyAlias(String alias, String aliasType, ThreeT2wsR threeT2ws) {
        return ReplaceThreeWindingsTransformersBy3TwoWindingsTransformers.copyLegAlias(alias, aliasType, "1", threeT2ws.t2wOne) || ReplaceThreeWindingsTransformersBy3TwoWindingsTransformers.copyLegAlias(alias, aliasType, "2", threeT2ws.t2wTwo) || ReplaceThreeWindingsTransformersBy3TwoWindingsTransformers.copyLegAlias(alias, aliasType, "3", threeT2ws.t2wThree);
    }

    private static boolean copyLegAlias(String alias, String aliasType, String legEnd, TwoWindingsTransformer t2wLeg) {
        boolean copied = true;
        if (aliasType.equals("CGMES.TransformerEnd" + legEnd)) {
            t2wLeg.addAlias(alias, "CGMES.TransformerEnd1", true);
        } else if (aliasType.equals("CGMES.Terminal" + legEnd)) {
            t2wLeg.addAlias(alias, "CGMES.Terminal1", true);
        } else if (aliasType.equals("CGMES.RatioTapChanger" + legEnd)) {
            t2wLeg.addAlias(alias, "CGMES.RatioTapChanger1", true);
        } else if (aliasType.equals("CGMES.PhaseTapChanger" + legEnd)) {
            t2wLeg.addAlias(alias, "CGMES.PhaseTapChanger1", true);
        } else {
            copied = false;
        }
        return copied;
    }

    private static void createReportNode(ReportNode reportNode, String t3wId, List<String> lostProperties, List<String> lostExtensions, List<AliasR> lostAliases, String starVoltageLevelId, ThreeT2wsR threeT2ws) {
        ReportNode reportNodeReplacement = ModificationReports.replaceThreeWindingsTransformersBy3TwoWindingsTransformersReport(reportNode);
        ModificationReports.removedThreeWindingsTransformerReport(reportNodeReplacement, t3wId);
        if (!lostProperties.isEmpty()) {
            String properties = String.join((CharSequence)",", lostProperties);
            ModificationReports.lostThreeWindingsTransformerProperties(reportNodeReplacement, properties, t3wId);
        }
        if (!lostExtensions.isEmpty()) {
            String extensions = String.join((CharSequence)",", lostExtensions);
            ModificationReports.lostThreeWindingsTransformerExtensions(reportNodeReplacement, extensions, t3wId);
        }
        if (!lostAliases.isEmpty()) {
            String aliases = lostAliases.stream().map(AliasR::alias).collect(Collectors.joining(","));
            ModificationReports.lostThreeWindingsTransformerAliases(reportNodeReplacement, aliases, t3wId);
        }
        ModificationReports.createdVoltageLevelReport(reportNodeReplacement, starVoltageLevelId);
        ModificationReports.createdTwoWindingsTransformerReport(reportNodeReplacement, threeT2ws.t2wOne.getId());
        ModificationReports.createdTwoWindingsTransformerReport(reportNodeReplacement, threeT2ws.t2wTwo.getId());
        ModificationReports.createdTwoWindingsTransformerReport(reportNodeReplacement, threeT2ws.t2wThree.getId());
    }

    private record ThreeT2wsR(TwoWindingsTransformer t2wOne, TwoWindingsTransformer t2wTwo, TwoWindingsTransformer t2wThree) {
    }

    private record ConnectivityR(Integer node, Bus bus, Bus connectableBus) {
    }

    private record AliasR(String alias, String aliasType) {
    }
}

