/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.computation.ComputationManager;
import com.powsybl.iidm.modification.AbstractNetworkModification;
import com.powsybl.iidm.modification.NetworkModificationImpact;
import com.powsybl.iidm.modification.topology.NamingStrategy;
import com.powsybl.iidm.modification.util.ModificationReports;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.Network;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetGeneratorToLocalRegulation
extends AbstractNetworkModification {
    private final String generatorId;
    private static final Logger LOG = LoggerFactory.getLogger(SetGeneratorToLocalRegulation.class);

    public SetGeneratorToLocalRegulation(String generatorId) {
        this.generatorId = Objects.requireNonNull(generatorId);
    }

    @Override
    public String getName() {
        return "SetGeneratorToLocalRegulation";
    }

    @Override
    public void apply(Network network, NamingStrategy namingStrategy, boolean throwException, ComputationManager computationManager, ReportNode reportNode) {
        Generator generator = network.getGenerator(this.generatorId);
        if (generator == null) {
            this.logOrThrow(throwException, "Generator '" + this.generatorId + "' not found");
        } else if (!generator.getId().equals(generator.getRegulatingTerminal().getConnectable().getId())) {
            this.setLocalRegulation(generator, reportNode);
        }
    }

    private void setLocalRegulation(Generator generator, ReportNode reportNode) {
        double remoteTargetV = generator.getTargetV();
        double remoteNominalV = generator.getRegulatingTerminal().getVoltageLevel().getNominalV();
        double localNominalV = generator.getTerminal().getVoltageLevel().getNominalV();
        double localTargetV = localNominalV * remoteTargetV / remoteNominalV;
        generator.setRegulatingTerminal(generator.getTerminal());
        generator.setTargetV(localTargetV);
        LOG.info("Changed regulation for generator: {} to local instead of remote", (Object)generator.getId());
        ModificationReports.generatorLocalRegulationReport(reportNode, generator.getId());
    }

    @Override
    public NetworkModificationImpact hasImpactOnNetwork(Network network) {
        Generator generator = network.getGenerator(this.generatorId);
        this.impact = generator == null ? NetworkModificationImpact.CANNOT_BE_APPLIED : (generator.getId().equals(generator.getRegulatingTerminal().getConnectable().getId()) ? NetworkModificationImpact.NO_IMPACT_ON_NETWORK : DEFAULT_IMPACT);
        return this.impact;
    }
}

