/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification.scalable;

import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.modification.scalable.AbstractScalable;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Injection;
import com.powsybl.iidm.network.Network;
import java.util.Objects;

abstract class AbstractInjectionScalable
extends AbstractScalable {
    protected final String id;
    protected final double minValue;
    protected final double maxValue;

    AbstractInjectionScalable(String id) {
        this(id, -1.7976931348623157E308, Double.MAX_VALUE);
    }

    AbstractInjectionScalable(String id, double minValue, double maxValue) {
        this.id = Objects.requireNonNull(id);
        if (maxValue < minValue) {
            throw new PowsyblException("Error creating Scalable " + id + " : maxValue should be bigger than minValue");
        }
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    private Injection getInjectionOrNull(Network n) {
        Identifiable identifiable = n.getIdentifiable(this.id);
        if (identifiable instanceof Injection) {
            Injection injection = (Injection)identifiable;
            return injection;
        }
        return null;
    }

    @Override
    public double initialValue(Network n) {
        Objects.requireNonNull(n);
        Injection injection = this.getInjectionOrNull(n);
        if (injection != null) {
            return !Double.isNaN(injection.getTerminal().getP()) ? injection.getTerminal().getP() : 0.0;
        }
        return 0.0;
    }
}

