/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification.scalable;

import com.powsybl.iidm.modification.scalable.AbstractInjectionScalable;
import com.powsybl.iidm.modification.scalable.Scalable;
import com.powsybl.iidm.modification.scalable.ScalingParameters;
import com.powsybl.iidm.network.Injection;
import com.powsybl.iidm.network.Load;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Terminal;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LoadScalable
extends AbstractInjectionScalable {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadScalable.class);

    LoadScalable(String id) {
        super(id, 0.0, Double.MAX_VALUE);
    }

    LoadScalable(String id, double maxValue) {
        super(id, 0.0, maxValue);
    }

    LoadScalable(String id, double minValue, double maxValue) {
        super(id, minValue, maxValue);
    }

    @Override
    public void reset(Network n) {
        Objects.requireNonNull(n);
        Load l = n.getLoad(this.id);
        if (l != null) {
            l.setP0(0.0);
        }
    }

    @Override
    public double maximumValue(Network n, Scalable.ScalingConvention scalingConvention) {
        Objects.requireNonNull(n);
        Objects.requireNonNull(scalingConvention);
        Load l = n.getLoad(this.id);
        if (l != null) {
            return scalingConvention == Scalable.ScalingConvention.LOAD ? this.maxValue : -this.minValue;
        }
        return 0.0;
    }

    @Override
    public double minimumValue(Network n, Scalable.ScalingConvention scalingConvention) {
        Objects.requireNonNull(n);
        Objects.requireNonNull(scalingConvention);
        Load l = n.getLoad(this.id);
        if (l != null) {
            return scalingConvention == Scalable.ScalingConvention.LOAD ? this.minValue : -this.maxValue;
        }
        return 0.0;
    }

    @Override
    public void filterInjections(Network n, List<Injection> injections, List<String> notFoundInjections) {
        Objects.requireNonNull(n);
        Objects.requireNonNull(injections);
        Load load = n.getLoad(this.id);
        if (load != null) {
            injections.add((Injection)load);
        } else if (notFoundInjections != null) {
            notFoundInjections.add(this.id);
        }
    }

    @Override
    public double scale(Network n, double asked, ScalingParameters parameters) {
        Objects.requireNonNull(n);
        Objects.requireNonNull(parameters);
        if (parameters.getIgnoredInjectionIds().contains(this.id)) {
            LOGGER.info("Scaling parameters' injections to be ignored contains load {}, discarded from scaling", (Object)this.id);
            return 0.0;
        }
        Load l = n.getLoad(this.id);
        if (l == null) {
            LOGGER.warn("Load {} not found", (Object)this.id);
            return 0.0;
        }
        Terminal t = l.getTerminal();
        if (!t.isConnected()) {
            if (parameters.isReconnect()) {
                t.connect();
                LOGGER.info("Connecting {}", (Object)l.getId());
            } else {
                LOGGER.info("Load {} is not connected, discarded from scaling", (Object)l.getId());
                return 0.0;
            }
        }
        return this.shiftLoad(asked, parameters, l);
    }

    private double shiftLoad(double asked, ScalingParameters parameters, Load l) {
        double done;
        double oldP0 = l.getP0();
        double oldQ0 = l.getQ0();
        if (oldP0 < this.minValue || oldP0 > this.maxValue) {
            LOGGER.error("Error scaling LoadScalable {}: Initial P is not in the range [Pmin, Pmax]", (Object)this.id);
            return 0.0;
        }
        double availableDown = oldP0 - this.minValue;
        double availableUp = this.maxValue - oldP0;
        if (parameters.getScalingConvention() == Scalable.ScalingConvention.LOAD) {
            done = asked > 0.0 ? Math.min(asked, availableUp) : -Math.min(-asked, availableDown);
            l.setP0(oldP0 + done);
        } else {
            done = asked > 0.0 ? Math.min(asked, availableDown) : -Math.min(-asked, availableUp);
            l.setP0(oldP0 - done);
        }
        LOGGER.info("Change active power setpoint of {} from {} to {} ", new Object[]{l.getId(), oldP0, l.getP0()});
        if (parameters.isConstantPowerFactor() && oldP0 != 0.0) {
            l.setQ0(l.getP0() * oldQ0 / oldP0);
            LOGGER.info("Change reactive power setpoint of {} from {} to {} ", new Object[]{l.getId(), oldQ0, l.getQ0()});
        }
        return done;
    }

    @Override
    public double getSteadyStatePower(Network network, double asked, Scalable.ScalingConvention scalingConvention) {
        Load load = network.getLoad(this.id);
        if (load == null) {
            LOGGER.warn("Load {} not found", (Object)this.id);
            return 0.0;
        }
        return scalingConvention == Scalable.ScalingConvention.LOAD ? load.getP0() : -load.getP0();
    }
}

