/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification.tapchanger;

import com.powsybl.iidm.modification.NetworkModificationImpact;
import com.powsybl.iidm.modification.tapchanger.AbstractTapPositionModification;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.PhaseTapChangerHolder;
import com.powsybl.iidm.network.ThreeSides;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.iidm.network.ValidationException;
import java.util.Objects;

public class PhaseTapPositionModification
extends AbstractTapPositionModification {
    private boolean isRelative = false;

    public PhaseTapPositionModification(String transformerId, int tapPosition) {
        super(transformerId, tapPosition, null);
    }

    public PhaseTapPositionModification(String transformerId, int tapPosition, ThreeSides leg) {
        super(transformerId, tapPosition, Objects.requireNonNull(leg));
    }

    public PhaseTapPositionModification(String transformerId, int tapPosition, boolean isRelative) {
        super(transformerId, tapPosition, null);
        this.isRelative = isRelative;
    }

    public PhaseTapPositionModification(String transformerId, int tapPosition, ThreeSides leg, boolean isRelative) {
        super(transformerId, tapPosition, Objects.requireNonNull(leg));
        this.isRelative = isRelative;
    }

    @Override
    public String getName() {
        return "PhaseTapPositionModification";
    }

    @Override
    protected void applyTwoWindingsTransformer(Network network, TwoWindingsTransformer twoWindingsTransformer, boolean throwException) {
        this.apply((PhaseTapChangerHolder)twoWindingsTransformer, throwException);
    }

    @Override
    protected void applyThreeWindingsTransformer(Network network, ThreeWindingsTransformer threeWindingsTransformer, boolean throwException) {
        this.apply((PhaseTapChangerHolder)this.getLeg(threeWindingsTransformer, PhaseTapChangerHolder::hasPhaseTapChanger, throwException), throwException);
    }

    public void apply(PhaseTapChangerHolder ptcHolder, boolean throwException) {
        if (ptcHolder == null) {
            this.logOrThrow(throwException, "Failed to apply : Transformer '" + this.getTransformerId());
            return;
        }
        if (!ptcHolder.hasPhaseTapChanger()) {
            this.logOrThrow(throwException, "Transformer '" + this.getTransformerId() + "' does not have a PhaseTapChanger");
            return;
        }
        try {
            int newTapPosition = (this.isRelative ? ptcHolder.getPhaseTapChanger().getTapPosition() : 0) + this.getTapPosition();
            ptcHolder.getPhaseTapChanger().setTapPosition(newTapPosition);
        }
        catch (ValidationException e) {
            this.logOrThrow(throwException, e.getMessage());
        }
    }

    @Override
    public NetworkModificationImpact hasImpactOnNetwork(Network network) {
        this.impact = DEFAULT_IMPACT;
        TwoWindingsTransformer twoWindingsTransformer = network.getTwoWindingsTransformer(this.getTransformerId());
        ThreeWindingsTransformer threeWindingsTransformer = network.getThreeWindingsTransformer(this.getTransformerId());
        if (twoWindingsTransformer == null && threeWindingsTransformer == null) {
            this.impact = NetworkModificationImpact.CANNOT_BE_APPLIED;
        } else if (twoWindingsTransformer != null) {
            if (this.cannotApplyModification(twoWindingsTransformer)) {
                this.impact = NetworkModificationImpact.CANNOT_BE_APPLIED;
            } else if (this.areValuesEqual(this.getTapPosition(), twoWindingsTransformer.getPhaseTapChanger().getTapPosition(), this.isRelative)) {
                this.impact = NetworkModificationImpact.NO_IMPACT_ON_NETWORK;
            }
        } else {
            ThreeWindingsTransformer.Leg ptcHolder = this.getLeg(threeWindingsTransformer, PhaseTapChangerHolder::hasPhaseTapChanger, false);
            if (this.cannotApplyModification((PhaseTapChangerHolder)ptcHolder)) {
                this.impact = NetworkModificationImpact.CANNOT_BE_APPLIED;
            } else if (this.areValuesEqual(this.getTapPosition(), ptcHolder.getPhaseTapChanger().getTapPosition(), this.isRelative)) {
                this.impact = NetworkModificationImpact.NO_IMPACT_ON_NETWORK;
            }
        }
        return this.impact;
    }

    private boolean cannotApplyModification(TwoWindingsTransformer twoWindingsTransformer) {
        return !twoWindingsTransformer.hasPhaseTapChanger() || this.isValueOutsideRange(this.getTapPosition() + (this.isRelative ? twoWindingsTransformer.getPhaseTapChanger().getTapPosition() : 0), twoWindingsTransformer.getPhaseTapChanger().getLowTapPosition(), twoWindingsTransformer.getPhaseTapChanger().getHighTapPosition());
    }

    private boolean cannotApplyModification(PhaseTapChangerHolder ptcHolder) {
        return !ptcHolder.hasPhaseTapChanger() || this.isValueOutsideRange(this.getTapPosition() + (this.isRelative ? ptcHolder.getPhaseTapChanger().getTapPosition() : 0), ptcHolder.getPhaseTapChanger().getLowTapPosition(), ptcHolder.getPhaseTapChanger().getHighTapPosition());
    }
}

