/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification.tapchanger;

import com.powsybl.iidm.modification.NetworkModificationImpact;
import com.powsybl.iidm.modification.tapchanger.AbstractTapPositionModification;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.RatioTapChangerHolder;
import com.powsybl.iidm.network.ThreeSides;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.iidm.network.ValidationException;
import java.util.Objects;

public class RatioTapPositionModification
extends AbstractTapPositionModification {
    public RatioTapPositionModification(String transformerId, int tapPosition) {
        super(transformerId, tapPosition, null);
    }

    public RatioTapPositionModification(String transformerId, int tapPosition, ThreeSides leg) {
        super(transformerId, tapPosition, Objects.requireNonNull(leg));
    }

    @Override
    public String getName() {
        return "RatioTapPositionModification";
    }

    @Override
    protected void applyTwoWindingsTransformer(Network network, TwoWindingsTransformer twoWindingsTransformer, boolean throwException) {
        this.apply((RatioTapChangerHolder)twoWindingsTransformer, throwException);
    }

    @Override
    protected void applyThreeWindingsTransformer(Network network, ThreeWindingsTransformer threeWindingsTransformer, boolean throwException) {
        this.apply((RatioTapChangerHolder)this.getLeg(threeWindingsTransformer, RatioTapChangerHolder::hasRatioTapChanger, throwException), throwException);
    }

    public void apply(RatioTapChangerHolder rtcHolder, boolean throwException) {
        if (rtcHolder == null) {
            this.logOrThrow(throwException, "Failed to apply : Transformer '" + this.getTransformerId());
            return;
        }
        if (!rtcHolder.hasRatioTapChanger()) {
            this.logOrThrow(throwException, "Transformer '" + this.getTransformerId() + "' does not have a RatioTapChanger");
            return;
        }
        try {
            rtcHolder.getRatioTapChanger().setTapPosition(this.getTapPosition());
        }
        catch (ValidationException e) {
            this.logOrThrow(throwException, e.getMessage());
        }
    }

    @Override
    public NetworkModificationImpact hasImpactOnNetwork(Network network) {
        this.impact = DEFAULT_IMPACT;
        TwoWindingsTransformer twoWindingsTransformer = network.getTwoWindingsTransformer(this.getTransformerId());
        ThreeWindingsTransformer threeWindingsTransformer = network.getThreeWindingsTransformer(this.getTransformerId());
        if (twoWindingsTransformer == null && threeWindingsTransformer == null) {
            this.impact = NetworkModificationImpact.CANNOT_BE_APPLIED;
        } else if (twoWindingsTransformer != null) {
            if (!twoWindingsTransformer.hasRatioTapChanger() || this.isValueOutsideRange(this.getTapPosition(), twoWindingsTransformer.getRatioTapChanger().getLowTapPosition(), twoWindingsTransformer.getRatioTapChanger().getHighTapPosition())) {
                this.impact = NetworkModificationImpact.CANNOT_BE_APPLIED;
            } else if (this.areValuesEqual(this.getTapPosition(), twoWindingsTransformer.getRatioTapChanger().getTapPosition(), false)) {
                this.impact = NetworkModificationImpact.NO_IMPACT_ON_NETWORK;
            }
        } else {
            ThreeWindingsTransformer.Leg rtcHolder = this.getLeg(threeWindingsTransformer, RatioTapChangerHolder::hasRatioTapChanger, false);
            if (!rtcHolder.hasRatioTapChanger() || this.isValueOutsideRange(this.getTapPosition(), rtcHolder.getRatioTapChanger().getLowTapPosition(), rtcHolder.getRatioTapChanger().getHighTapPosition())) {
                this.impact = NetworkModificationImpact.CANNOT_BE_APPLIED;
            } else if (this.areValuesEqual(this.getTapPosition(), rtcHolder.getRatioTapChanger().getTapPosition(), false)) {
                this.impact = NetworkModificationImpact.NO_IMPACT_ON_NETWORK;
            }
        }
        return this.impact;
    }
}

