/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification.topology;

import com.powsybl.iidm.modification.topology.AbstractCreateConnectableFeederBays;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.Injection;
import com.powsybl.iidm.network.InjectionAdder;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.extensions.ConnectablePosition;
import com.powsybl.iidm.network.extensions.ConnectablePositionAdder;
import java.util.Objects;
import java.util.Optional;

public class CreateFeederBay
extends AbstractCreateConnectableFeederBays {
    private final InjectionAdder<?, ?> injectionAdder;
    private final String busOrBbsId;
    private final Integer injectionPositionOrder;
    private final String injectionFeederName;
    private final ConnectablePosition.Direction injectionDirection;

    CreateFeederBay(InjectionAdder<?, ?> injectionAdder, String busOrBbsId, Integer injectionPositionOrder, String injectionFeederName, ConnectablePosition.Direction injectionDirection) {
        super(0);
        this.injectionAdder = Objects.requireNonNull(injectionAdder);
        this.busOrBbsId = Objects.requireNonNull(busOrBbsId);
        this.injectionPositionOrder = injectionPositionOrder;
        this.injectionFeederName = injectionFeederName;
        this.injectionDirection = Objects.requireNonNull(injectionDirection);
    }

    @Override
    public String getName() {
        return "CreateFeederBay";
    }

    @Override
    protected String getBusOrBusbarSectionId(int side) {
        return this.busOrBbsId;
    }

    @Override
    protected void setBus(int side, Bus bus, String voltageLevelId) {
        this.injectionAdder.setConnectableBus(bus.getId()).setBus(bus.getId());
    }

    @Override
    protected void setNode(int side, int node, String voltageLevelId) {
        this.injectionAdder.setNode(node);
    }

    @Override
    protected Connectable<?> add() {
        return this.injectionAdder.add();
    }

    @Override
    protected VoltageLevel getVoltageLevel(int side, Connectable<?> connectable) {
        return ((Injection)connectable).getTerminal().getVoltageLevel();
    }

    @Override
    protected Integer getPositionOrder(int side) {
        return this.injectionPositionOrder;
    }

    @Override
    protected Optional<String> getFeederName(int side) {
        return Optional.ofNullable(this.injectionFeederName);
    }

    @Override
    protected ConnectablePosition.Direction getDirection(int side) {
        return this.injectionDirection;
    }

    @Override
    protected int getNode(int side, Connectable<?> connectable) {
        return ((Injection)connectable).getTerminal().getNodeBreakerView().getNode();
    }

    @Override
    protected ConnectablePositionAdder.FeederAdder<?> getFeederAdder(int side, ConnectablePositionAdder<?> connectablePositionAdder) {
        return connectablePositionAdder.newFeeder();
    }
}

