/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification.topology;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.computation.ComputationManager;
import com.powsybl.iidm.modification.AbstractNetworkModification;
import com.powsybl.iidm.modification.NetworkModificationImpact;
import com.powsybl.iidm.modification.topology.NamingStrategy;
import com.powsybl.iidm.modification.util.ModificationReports;
import com.powsybl.iidm.network.BusbarSection;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.math.graph.TraverseResult;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.alg.util.Pair;
import org.jgrapht.graph.Pseudograph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveFeederBay
extends AbstractNetworkModification {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoveFeederBay.class);
    private final String connectableId;

    public RemoveFeederBay(String connectableId) {
        this.connectableId = Objects.requireNonNull(connectableId);
    }

    @Override
    public String getName() {
        return "RemoveFeederBay";
    }

    @Override
    public void apply(Network network, NamingStrategy namingStrategy, boolean throwException, ComputationManager computationManager, ReportNode reportNode) {
        Connectable connectable = network.getConnectable(this.connectableId);
        if (!this.checkConnectable(throwException, reportNode, connectable)) {
            return;
        }
        for (Terminal t : connectable.getTerminals()) {
            if (t.getVoltageLevel().getTopologyKind() != TopologyKind.NODE_BREAKER) continue;
            Graph<Integer, Object> graph = this.createGraphFromTerminal(t);
            int node = t.getNodeBreakerView().getNode();
            this.cleanTopology(t.getVoltageLevel().getNodeBreakerView(), graph, node, reportNode);
        }
        connectable.remove();
        ModificationReports.removedConnectableReport(reportNode, this.connectableId);
        LOGGER.info("Connectable {} removed", (Object)this.connectableId);
    }

    @Override
    public NetworkModificationImpact hasImpactOnNetwork(Network network) {
        this.impact = DEFAULT_IMPACT;
        Connectable connectable = network.getConnectable(this.connectableId);
        if (connectable == null || connectable instanceof BusbarSection) {
            this.impact = NetworkModificationImpact.CANNOT_BE_APPLIED;
        }
        return this.impact;
    }

    private Graph<Integer, Object> createGraphFromTerminal(Terminal terminal) {
        Pseudograph graph = new Pseudograph(Object.class);
        int node = terminal.getNodeBreakerView().getNode();
        VoltageLevel.NodeBreakerView vlNbv = terminal.getVoltageLevel().getNodeBreakerView();
        graph.addVertex((Object)node);
        vlNbv.traverse(node, (arg_0, arg_1, arg_2) -> RemoveFeederBay.lambda$createGraphFromTerminal$1(vlNbv, (Graph)graph, arg_0, arg_1, arg_2));
        return graph;
    }

    private void cleanTopology(VoltageLevel.NodeBreakerView nbv, Graph<Integer, Object> graph, int node, ReportNode reportNode) {
        Set edges = graph.edgesOf((Object)node);
        if (edges.size() == 1) {
            Object edge = edges.iterator().next();
            Integer oppositeNode = RemoveFeederBay.getOppositeNode(graph, node, edge);
            RemoveFeederBay.removeSwitchOrInternalConnection(nbv, graph, edge, reportNode);
            this.cleanTopology(nbv, graph, oppositeNode, reportNode);
        } else if (edges.size() > 1) {
            this.cleanFork(nbv, graph, node, edges, reportNode);
        }
    }

    private void cleanMixedTopology(VoltageLevel.NodeBreakerView nbv, Graph<Integer, Object> graph, int node, ReportNode reportNode) {
        Set edges = graph.edgesOf((Object)node);
        Object edge = edges.iterator().next();
        Integer oppositeNode = RemoveFeederBay.getOppositeNode(graph, node, edge);
        RemoveFeederBay.removeSwitchOrInternalConnection(nbv, graph, edge, reportNode);
        ArrayList connectables = new ArrayList();
        nbv.getOptionalTerminal(oppositeNode.intValue()).map(Terminal::getConnectable).ifPresent(connectables::add);
        if (graph.edgesOf((Object)oppositeNode).size() == 1 && connectables.isEmpty()) {
            this.cleanMixedTopology(nbv, graph, oppositeNode, reportNode);
        }
    }

    private void cleanFork(VoltageLevel.NodeBreakerView nbv, Graph<Integer, Object> graph, int node, Set<Object> edges, ReportNode reportNode) {
        ArrayList<Object> toBusesOnly = new ArrayList<Object>();
        ArrayList<Object> mixed = new ArrayList<Object>();
        for (Object edge : edges) {
            List<Connectable<?>> connectables = this.getLinkedConnectables(nbv, graph, node, edge);
            if (connectables.stream().allMatch(BusbarSection.class::isInstance)) {
                toBusesOnly.add(edge);
                continue;
            }
            if (connectables.stream().noneMatch(BusbarSection.class::isInstance)) {
                String otherConnectableId = connectables.stream().map(Identifiable::getId).findFirst().orElse("none");
                ModificationReports.removeFeederBayAborted(reportNode, this.connectableId, node, otherConnectableId);
                LOGGER.info("Remove feeder bay of {} cannot go further node {}, as it is connected to {}", new Object[]{this.connectableId, node, otherConnectableId});
                return;
            }
            mixed.add(edge);
        }
        for (Object edge : toBusesOnly) {
            this.removeAllSwitchesAndInternalConnections(nbv, graph, node, edge, reportNode);
        }
        if (mixed.size() == 1) {
            this.cleanMixedTopology(nbv, graph, node, reportNode);
        }
    }

    private List<Connectable<?>> getLinkedConnectables(VoltageLevel.NodeBreakerView nbv, Graph<Integer, Object> graph, Integer node, Object edge) {
        HashSet<Integer> visitedNodes = new HashSet<Integer>();
        visitedNodes.add(node);
        ArrayList connectables = new ArrayList();
        this.searchConnectables(nbv, graph, RemoveFeederBay.getOppositeNode(graph, node, edge), visitedNodes, connectables);
        return connectables;
    }

    private void searchConnectables(VoltageLevel.NodeBreakerView nbv, Graph<Integer, Object> graph, Integer node, Set<Integer> visitedNodes, List<Connectable<?>> connectables) {
        if (visitedNodes.contains(node)) {
            return;
        }
        nbv.getOptionalTerminal(node.intValue()).map(Terminal::getConnectable).ifPresent(connectables::add);
        if (!RemoveFeederBay.isBusbarSection(nbv, node)) {
            visitedNodes.add(node);
            for (Object e : graph.edgesOf((Object)node)) {
                this.searchConnectables(nbv, graph, RemoveFeederBay.getOppositeNode(graph, node, e), visitedNodes, connectables);
            }
        }
    }

    private void removeAllSwitchesAndInternalConnections(VoltageLevel.NodeBreakerView nbv, Graph<Integer, Object> graph, int originNode, Object edge, ReportNode reportNode) {
        Integer oppositeNode = RemoveFeederBay.getOppositeNode(graph, originNode, edge);
        RemoveFeederBay.removeSwitchOrInternalConnection(nbv, graph, edge, reportNode);
        if (!RemoveFeederBay.isBusbarSection(nbv, oppositeNode)) {
            for (Object otherEdge : new ArrayList(graph.edgesOf((Object)oppositeNode))) {
                this.removeAllSwitchesAndInternalConnections(nbv, graph, oppositeNode, otherEdge, reportNode);
            }
        }
    }

    private static boolean isBusbarSection(VoltageLevel.NodeBreakerView nbv, Integer node) {
        Optional<Connectable> c = nbv.getOptionalTerminal(node.intValue()).map(Terminal::getConnectable);
        return c.isPresent() && c.get() instanceof BusbarSection;
    }

    private static void removeSwitchOrInternalConnection(VoltageLevel.NodeBreakerView nbv, Graph<Integer, Object> graph, Object edge, ReportNode reportNode) {
        if (edge instanceof Switch) {
            Switch sw = (Switch)edge;
            String switchId = sw.getId();
            nbv.removeSwitch(switchId);
            ModificationReports.removedSwitchReport(reportNode, switchId);
            LOGGER.info("Switch {} removed", (Object)switchId);
        } else {
            Pair ic = (Pair)edge;
            nbv.removeInternalConnections(((Integer)ic.getFirst()).intValue(), ((Integer)ic.getSecond()).intValue());
            ModificationReports.removedInternalConnectionReport(reportNode, (Integer)ic.getFirst(), (Integer)ic.getSecond());
            LOGGER.info("Internal connection between {} and {} removed", ic.getFirst(), ic.getSecond());
        }
        graph.removeEdge(edge);
    }

    private static Integer getOppositeNode(Graph<Integer, Object> graph, int node, Object e) {
        Integer edgeSource = (Integer)graph.getEdgeSource(e);
        return edgeSource == node ? (Integer)graph.getEdgeTarget(e) : edgeSource;
    }

    private boolean checkConnectable(boolean throwException, ReportNode reportNode, Connectable<?> connectable) {
        if (connectable instanceof BusbarSection) {
            LOGGER.error("BusbarSection connectables are not allowed as RemoveFeederBay input: {}", (Object)this.connectableId);
            ModificationReports.removeFeederBayBusbarSectionReport(reportNode, this.connectableId);
            if (throwException) {
                throw new PowsyblException("BusbarSection connectables are not allowed as RemoveFeederBay input: " + this.connectableId);
            }
            return false;
        }
        if (connectable == null) {
            LOGGER.error("Connectable {} not found", (Object)this.connectableId);
            ModificationReports.notFoundConnectableReport(reportNode, this.connectableId);
            if (throwException) {
                throw new PowsyblException("Connectable not found: " + this.connectableId);
            }
            return false;
        }
        return true;
    }

    private static /* synthetic */ TraverseResult lambda$createGraphFromTerminal$1(VoltageLevel.NodeBreakerView vlNbv, Graph graph, int node1, Switch sw, int node2) {
        TraverseResult result = vlNbv.getOptionalTerminal(node2).map(Terminal::getConnectable).filter(BusbarSection.class::isInstance).map(c -> TraverseResult.TERMINATE_PATH).orElse(TraverseResult.CONTINUE);
        graph.addVertex((Object)node2);
        graph.addEdge((Object)node1, (Object)node2, sw != null ? sw : Pair.of((Object)node1, (Object)node2));
        return result;
    }
}

