/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification.tripping;

import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.modification.tripping.AbstractTripping;
import com.powsybl.iidm.modification.tripping.TrippingTopologyTraverser;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import java.util.Objects;
import java.util.Set;

public class ThreeWindingsTransformerTripping
extends AbstractTripping {
    public ThreeWindingsTransformerTripping(String id) {
        super(id);
    }

    @Override
    public String getName() {
        return "ThreeWindingsTransformerTripping";
    }

    @Override
    public void traverse(Network network, Set<Switch> switchesToOpen, Set<Terminal> terminalsToDisconnect, Set<Terminal> traversedTerminals) {
        Objects.requireNonNull(network);
        ThreeWindingsTransformer twt3 = network.getThreeWindingsTransformer(this.id);
        if (twt3 == null) {
            throw this.createNotFoundException();
        }
        TrippingTopologyTraverser.traverse(twt3.getLeg1().getTerminal(), switchesToOpen, terminalsToDisconnect, traversedTerminals);
        TrippingTopologyTraverser.traverse(twt3.getLeg2().getTerminal(), switchesToOpen, terminalsToDisconnect, traversedTerminals);
        TrippingTopologyTraverser.traverse(twt3.getLeg3().getTerminal(), switchesToOpen, terminalsToDisconnect, traversedTerminals);
    }

    protected PowsyblException createNotFoundException() {
        return new PowsyblException("ThreeWindingsTransformer '" + this.id + "' not found");
    }
}

