/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.computation.ComputationManager;
import com.powsybl.iidm.modification.AbstractNetworkModification;
import com.powsybl.iidm.modification.NetworkModificationImpact;
import com.powsybl.iidm.modification.topology.NamingStrategy;
import com.powsybl.iidm.modification.util.ModificationLogs;
import com.powsybl.iidm.network.Load;
import com.powsybl.iidm.network.Network;
import java.util.Objects;

public class PercentChangeLoadModification
extends AbstractNetworkModification {
    private String loadId;
    private double q0PercentChange;
    private double p0PercentChange;

    public PercentChangeLoadModification(String loadId, double p0PercentChange, double q0PercentChange) {
        this.loadId = Objects.requireNonNull(loadId);
        if (p0PercentChange < -100.0) {
            throw new PowsyblException("The active power of " + loadId + " cannot decrease by more than 100% (current value: " + p0PercentChange + ")");
        }
        if (q0PercentChange < -100.0) {
            throw new PowsyblException("The reactive power of " + loadId + " cannot decrease by more than 100% (current value: " + q0PercentChange + ")");
        }
        this.p0PercentChange = p0PercentChange;
        this.q0PercentChange = q0PercentChange;
    }

    @Override
    public String getName() {
        return "PercentChangeLoadModification";
    }

    @Override
    public void apply(Network network, NamingStrategy namingStrategy, boolean throwException, ComputationManager computationManager, ReportNode reportNode) {
        Load load = network.getLoad(this.loadId);
        if (load == null) {
            ModificationLogs.logOrThrow(throwException, "Load '" + this.loadId + "' not found");
        } else {
            double p0 = load.getP0();
            load.setP0(p0 + p0 * this.p0PercentChange / 100.0);
            double q0 = load.getQ0();
            load.setQ0(q0 + q0 * this.q0PercentChange / 100.0);
        }
    }

    @Override
    public NetworkModificationImpact hasImpactOnNetwork(Network network) {
        this.impact = DEFAULT_IMPACT;
        Load load = network.getLoad(this.loadId);
        if (load == null) {
            this.impact = NetworkModificationImpact.CANNOT_BE_APPLIED;
        } else if (this.p0PercentChange == 0.0 && this.q0PercentChange == 0.0) {
            this.impact = NetworkModificationImpact.NO_IMPACT_ON_NETWORK;
        }
        return this.impact;
    }

    public String getMessageHeader() {
        return this.getName();
    }
}

