/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.computation.ComputationManager;
import com.powsybl.iidm.modification.AbstractNetworkModification;
import com.powsybl.iidm.modification.LoadFlowBasedPhaseShifterOptimizer;
import com.powsybl.iidm.modification.topology.NamingStrategy;
import com.powsybl.iidm.modification.util.ModificationLogs;
import com.powsybl.iidm.network.Network;
import java.util.Objects;

public class PhaseShifterOptimizeTap
extends AbstractNetworkModification {
    private final String phaseShifterId;

    public PhaseShifterOptimizeTap(String phaseShifterId) {
        this.phaseShifterId = Objects.requireNonNull(phaseShifterId);
    }

    @Override
    public String getName() {
        return "PhaseShifterOptimizeTap";
    }

    @Override
    public void apply(Network network, NamingStrategy namingStrategy, boolean throwException, ComputationManager computationManager, ReportNode reportNode) {
        try {
            new LoadFlowBasedPhaseShifterOptimizer(computationManager).findMaximalFlowTap(network, this.phaseShifterId);
        }
        catch (PowsyblException powsyblException) {
            ModificationLogs.logOrThrow(throwException, "Unable to find maximal flow tap");
        }
    }
}

