/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.computation.ComputationManager;
import com.powsybl.iidm.modification.AbstractNetworkModification;
import com.powsybl.iidm.modification.NetworkModificationImpact;
import com.powsybl.iidm.modification.topology.NamingStrategy;
import com.powsybl.iidm.modification.util.ModificationLogs;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.PhaseTapChanger;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import java.util.Objects;

public class PhaseShifterShiftTap
extends AbstractNetworkModification {
    private final String phaseShifterId;
    private final int tapDelta;

    public PhaseShifterShiftTap(String phaseShifterId, int tapDelta) {
        this.phaseShifterId = Objects.requireNonNull(phaseShifterId);
        this.tapDelta = tapDelta;
    }

    @Override
    public String getName() {
        return "PhaseShifterShiftTap";
    }

    public int getTapDelta() {
        return this.tapDelta;
    }

    @Override
    public void apply(Network network, NamingStrategy namingStrategy, boolean throwException, ComputationManager computationManager, ReportNode reportNode) {
        Objects.requireNonNull(network);
        TwoWindingsTransformer phaseShifter = network.getTwoWindingsTransformer(this.phaseShifterId);
        if (phaseShifter == null) {
            ModificationLogs.logOrThrow(throwException, "Transformer '" + this.phaseShifterId + "' not found");
        } else {
            PhaseTapChanger phaseTapChanger = phaseShifter.getPhaseTapChanger();
            if (phaseTapChanger == null) {
                ModificationLogs.logOrThrow(throwException, "Transformer '" + this.phaseShifterId + "' is not a phase shifter");
            } else {
                this.adjustTapPosition(phaseTapChanger);
                phaseTapChanger.setRegulating(false);
                phaseTapChanger.setRegulationMode(PhaseTapChanger.RegulationMode.FIXED_TAP);
            }
        }
    }

    private void adjustTapPosition(PhaseTapChanger phaseTapChanger) {
        phaseTapChanger.setTapPosition(Math.min(Math.max(phaseTapChanger.getTapPosition() + this.tapDelta, phaseTapChanger.getLowTapPosition()), phaseTapChanger.getHighTapPosition()));
    }

    @Override
    public NetworkModificationImpact hasImpactOnNetwork(Network network) {
        this.impact = DEFAULT_IMPACT;
        TwoWindingsTransformer phaseShifter = network.getTwoWindingsTransformer(this.phaseShifterId);
        if (phaseShifter == null || !phaseShifter.hasPhaseTapChanger()) {
            this.impact = NetworkModificationImpact.CANNOT_BE_APPLIED;
        } else {
            PhaseTapChanger phaseTapChanger = phaseShifter.getPhaseTapChanger();
            int tapPosition = Math.min(Math.max(phaseTapChanger.getTapPosition() + this.tapDelta, phaseTapChanger.getLowTapPosition()), phaseTapChanger.getHighTapPosition());
            if (this.areValuesEqual(tapPosition, phaseTapChanger.getTapPosition(), false) && !phaseTapChanger.isRegulating() && phaseTapChanger.getRegulationMode() == PhaseTapChanger.RegulationMode.FIXED_TAP) {
                this.impact = NetworkModificationImpact.NO_IMPACT_ON_NETWORK;
            }
        }
        return this.impact;
    }
}

