/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification.scalable;

import com.powsybl.iidm.modification.ConnectGenerator;
import com.powsybl.iidm.modification.scalable.AbstractInjectionScalable;
import com.powsybl.iidm.modification.scalable.Scalable;
import com.powsybl.iidm.modification.scalable.ScalingParameters;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.Injection;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Terminal;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneratorScalable
extends AbstractInjectionScalable {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeneratorScalable.class);

    protected GeneratorScalable(String id) {
        super(id);
    }

    protected GeneratorScalable(String id, double minValue, double maxValue) {
        super(id, minValue, maxValue);
    }

    @Override
    public void reset(Network n) {
        Objects.requireNonNull(n);
        Generator g = n.getGenerator(this.id);
        if (g != null) {
            this.setTargetP(g, 0.0);
        }
    }

    @Override
    public double maximumValue(Network n, Scalable.ScalingConvention scalingConvention) {
        Objects.requireNonNull(n);
        Objects.requireNonNull(scalingConvention);
        Generator g = n.getGenerator(this.id);
        if (g != null) {
            return scalingConvention == Scalable.ScalingConvention.GENERATOR ? this.maximumTargetP(g) : -this.minimumTargetP(g);
        }
        return 0.0;
    }

    @Override
    public double minimumValue(Network n, Scalable.ScalingConvention scalingConvention) {
        Objects.requireNonNull(n);
        Objects.requireNonNull(scalingConvention);
        Generator g = n.getGenerator(this.id);
        if (g != null) {
            return scalingConvention == Scalable.ScalingConvention.GENERATOR ? this.minimumTargetP(g) : -this.maximumTargetP(g);
        }
        return 0.0;
    }

    private double minimumTargetP(Generator gen) {
        return Math.max(gen.getMinP(), this.minValue);
    }

    private double maximumTargetP(Generator gen) {
        return Math.min(gen.getMaxP(), this.maxValue);
    }

    @Override
    public void filterInjections(Network n, List<Injection> injections, List<String> notFoundInjections) {
        Objects.requireNonNull(n);
        Objects.requireNonNull(injections);
        Generator generator = n.getGenerator(this.id);
        if (generator != null) {
            injections.add((Injection)generator);
        } else if (notFoundInjections != null) {
            notFoundInjections.add(this.id);
        }
    }

    @Override
    public double scale(Network n, double asked, ScalingParameters parameters) {
        Objects.requireNonNull(n);
        Objects.requireNonNull(parameters);
        if (parameters.getIgnoredInjectionIds().contains(this.id)) {
            LOGGER.info("Scaling parameters' injections to be ignored contains generator {}, discarded from scaling", (Object)this.id);
            return 0.0;
        }
        Generator g = n.getGenerator(this.id);
        double done = 0.0;
        if (g == null) {
            LOGGER.warn("Generator {} not found", (Object)this.id);
            return done;
        }
        Terminal t = g.getTerminal();
        if (!t.isConnected()) {
            if (parameters.isReconnect()) {
                new ConnectGenerator(g.getId()).apply(n);
                LOGGER.info("Connecting {}", (Object)g.getId());
            } else {
                LOGGER.info("Generator {} is not connected, discarded from scaling", (Object)g.getId());
                return 0.0;
            }
        }
        double oldTargetP = this.getTargetP(g);
        double minimumTargetP = this.minimumTargetP(g);
        double maximumTargetP = this.maximumTargetP(g);
        if (!parameters.isAllowsGeneratorOutOfActivePowerLimits() && (oldTargetP < minimumTargetP || oldTargetP > maximumTargetP)) {
            LOGGER.error("Error scaling GeneratorScalable {}: Initial P is not in the range [Pmin, Pmax], skipped", (Object)this.id);
            return 0.0;
        }
        double availableUp = maximumTargetP - oldTargetP;
        double availableDown = oldTargetP - minimumTargetP;
        if (parameters.getScalingConvention() == Scalable.ScalingConvention.GENERATOR) {
            done = asked > 0.0 ? Math.min(asked, availableUp) : -Math.min(-asked, availableDown);
            this.setTargetP(g, oldTargetP + done);
        } else {
            done = asked > 0.0 ? Math.min(asked, availableDown) : -Math.min(-asked, availableUp);
            this.setTargetP(g, oldTargetP - done);
        }
        LOGGER.info("Change active power setpoint of {} from {} to {} (pmax={})", new Object[]{g.getId(), oldTargetP, this.getTargetP(g), g.getMaxP()});
        return done;
    }

    double availablePowerInPercentageOfAsked(Network network, double asked, double scalingPercentage, Scalable.ScalingConvention scalingConvention) {
        Generator generator = network.getGenerator(this.id);
        double askedPower = asked * scalingPercentage / 100.0;
        if (scalingConvention == Scalable.ScalingConvention.LOAD) {
            askedPower = -askedPower;
        }
        if (askedPower >= 0.0) {
            double availablePower = Math.min(generator.getMaxP(), this.maxValue) - this.getTargetP(generator);
            return askedPower > availablePower ? availablePower / askedPower : 100.0;
        }
        double availablePower = Math.max(generator.getMinP(), this.minValue) - this.getTargetP(generator);
        return askedPower < availablePower ? availablePower / askedPower : 100.0;
    }

    @Override
    public double getSteadyStatePower(Network network, double asked, Scalable.ScalingConvention scalingConvention) {
        Generator generator = network.getGenerator(this.id);
        if (generator == null) {
            LOGGER.warn("Generator {} not found", (Object)this.id);
            return 0.0;
        }
        return scalingConvention == Scalable.ScalingConvention.GENERATOR ? this.getTargetP(generator) : -this.getTargetP(generator);
    }

    protected void setTargetP(Generator g, double value) {
        g.setTargetP(value);
    }

    protected double getTargetP(Generator g) {
        return g.getTargetP();
    }
}

