/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification.scalable;

import com.powsybl.iidm.modification.scalable.AbstractInjectionScalable;
import com.powsybl.iidm.modification.scalable.Scalable;
import com.powsybl.iidm.modification.scalable.ScalingParameters;
import com.powsybl.iidm.network.Injection;
import com.powsybl.iidm.network.Load;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Terminal;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadScalable
extends AbstractInjectionScalable {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadScalable.class);

    protected LoadScalable(String id) {
        super(id, 0.0, Double.MAX_VALUE);
    }

    protected LoadScalable(String id, double maxValue) {
        super(id, 0.0, maxValue);
    }

    protected LoadScalable(String id, double minValue, double maxValue) {
        super(id, minValue, maxValue);
    }

    @Override
    public void reset(Network n) {
        Objects.requireNonNull(n);
        Load l = n.getLoad(this.id);
        if (l != null) {
            this.setP0(l, 0.0);
        }
    }

    @Override
    public double maximumValue(Network n, Scalable.ScalingConvention scalingConvention) {
        Objects.requireNonNull(n);
        Objects.requireNonNull(scalingConvention);
        Load l = n.getLoad(this.id);
        if (l != null) {
            return scalingConvention == Scalable.ScalingConvention.LOAD ? this.maxValue : -this.minValue;
        }
        return 0.0;
    }

    @Override
    public double minimumValue(Network n, Scalable.ScalingConvention scalingConvention) {
        Objects.requireNonNull(n);
        Objects.requireNonNull(scalingConvention);
        Load l = n.getLoad(this.id);
        if (l != null) {
            return scalingConvention == Scalable.ScalingConvention.LOAD ? this.minValue : -this.maxValue;
        }
        return 0.0;
    }

    @Override
    public void filterInjections(Network n, List<Injection> injections, List<String> notFoundInjections) {
        Objects.requireNonNull(n);
        Objects.requireNonNull(injections);
        Load load = n.getLoad(this.id);
        if (load != null) {
            injections.add((Injection)load);
        } else if (notFoundInjections != null) {
            notFoundInjections.add(this.id);
        }
    }

    @Override
    public double scale(Network n, double asked, ScalingParameters parameters) {
        Objects.requireNonNull(n);
        Objects.requireNonNull(parameters);
        if (parameters.getIgnoredInjectionIds().contains(this.id)) {
            LOGGER.info("Scaling parameters' injections to be ignored contains load {}, discarded from scaling", (Object)this.id);
            return 0.0;
        }
        Load l = n.getLoad(this.id);
        if (l == null) {
            LOGGER.warn("Load {} not found", (Object)this.id);
            return 0.0;
        }
        Terminal t = l.getTerminal();
        if (!t.isConnected()) {
            if (parameters.isReconnect()) {
                t.connect();
                LOGGER.info("Connecting {}", (Object)l.getId());
            } else {
                LOGGER.info("Load {} is not connected, discarded from scaling", (Object)l.getId());
                return 0.0;
            }
        }
        return this.shiftLoad(asked, parameters, l);
    }

    private double shiftLoad(double asked, ScalingParameters parameters, Load l) {
        double done;
        double oldP0 = this.getP0(l);
        double oldQ0 = this.getQ0(l);
        if (oldP0 < this.minValue || oldP0 > this.maxValue) {
            LOGGER.error("Error scaling LoadScalable {}: Initial P is not in the range [Pmin, Pmax]", (Object)this.id);
            return 0.0;
        }
        double availableDown = oldP0 - this.minValue;
        double availableUp = this.maxValue - oldP0;
        if (parameters.getScalingConvention() == Scalable.ScalingConvention.LOAD) {
            done = asked > 0.0 ? Math.min(asked, availableUp) : -Math.min(-asked, availableDown);
            this.setP0(l, oldP0 + done);
        } else {
            done = asked > 0.0 ? Math.min(asked, availableDown) : -Math.min(-asked, availableUp);
            this.setP0(l, oldP0 - done);
        }
        LOGGER.info("Change active power setpoint of {} from {} to {} ", new Object[]{l.getId(), oldP0, this.getP0(l)});
        if (parameters.isConstantPowerFactor() && oldP0 != 0.0) {
            this.setQ0(l, this.getP0(l) * oldQ0 / oldP0);
            LOGGER.info("Change reactive power setpoint of {} from {} to {} ", new Object[]{l.getId(), oldQ0, this.getQ0(l)});
        }
        return done;
    }

    @Override
    public double getSteadyStatePower(Network network, double asked, Scalable.ScalingConvention scalingConvention) {
        Load load = network.getLoad(this.id);
        if (load == null) {
            LOGGER.warn("Load {} not found", (Object)this.id);
            return 0.0;
        }
        return scalingConvention == Scalable.ScalingConvention.LOAD ? this.getP0(load) : -this.getP0(load);
    }

    protected void setP0(Load l, double value) {
        l.setP0(value);
    }

    protected double getP0(Load l) {
        return l.getP0();
    }

    protected void setQ0(Load l, double value) {
        l.setQ0(value);
    }

    protected double getQ0(Load l) {
        return l.getQ0();
    }
}

