/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification.scalable;

import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.modification.scalable.AbstractScalable;
import com.powsybl.iidm.modification.scalable.DanglingLineScalable;
import com.powsybl.iidm.modification.scalable.GeneratorScalable;
import com.powsybl.iidm.modification.scalable.LoadScalable;
import com.powsybl.iidm.modification.scalable.Scalable;
import com.powsybl.iidm.modification.scalable.ScalingParameters;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Injection;
import com.powsybl.iidm.network.Load;
import com.powsybl.iidm.network.Network;
import java.util.List;
import java.util.Objects;

class ScalableAdapter
extends AbstractScalable {
    private final String id;

    public ScalableAdapter(String id) {
        this.id = Objects.requireNonNull(id);
    }

    public ScalableAdapter(Injection<?> injection) {
        Objects.requireNonNull(injection);
        this.id = injection.getId();
    }

    private Scalable getScalable(Network n) {
        Objects.requireNonNull(n);
        Identifiable identifiable = n.getIdentifiable(this.id);
        if (identifiable instanceof Generator) {
            return new GeneratorScalable(this.id);
        }
        if (identifiable instanceof Load) {
            return new LoadScalable(this.id);
        }
        if (identifiable instanceof DanglingLine) {
            return new DanglingLineScalable(this.id);
        }
        throw new PowsyblException("Unable to create a scalable from " + identifiable.getClass());
    }

    @Override
    public double initialValue(Network n) {
        return this.getScalable(n).initialValue(n);
    }

    @Override
    public void reset(Network n) {
        this.getScalable(n).reset(n);
    }

    @Override
    public double maximumValue(Network n, Scalable.ScalingConvention scalingConvention) {
        return this.getScalable(n).maximumValue(n, scalingConvention);
    }

    @Override
    public double minimumValue(Network n, Scalable.ScalingConvention scalingConvention) {
        return this.getScalable(n).minimumValue(n, scalingConvention);
    }

    @Override
    public void filterInjections(Network network, List<Injection> injections, List<String> notFound) {
        this.getScalable(network).filterInjections(network, injections, notFound);
    }

    @Override
    public double scale(Network n, double asked, ScalingParameters parameters) {
        return this.getScalable(n).scale(n, asked, parameters);
    }

    double availablePowerInPercentageOfAsked(Network network, double asked, double scalingPercentage, Scalable.ScalingConvention scalingConvention) {
        Objects.requireNonNull(network);
        Scalable scalable = this.getScalable(network);
        if (scalable instanceof GeneratorScalable) {
            GeneratorScalable generatorScalable = (GeneratorScalable)scalable;
            return generatorScalable.availablePowerInPercentageOfAsked(network, asked, scalingPercentage, scalingConvention);
        }
        Identifiable identifiable = network.getIdentifiable(this.id);
        throw new PowsyblException(String.format("RESPECT_OF_DISTRIBUTION mode can only be used with a Generator, not %s", identifiable.getClass()));
    }

    @Override
    public double getSteadyStatePower(Network network, double asked, Scalable.ScalingConvention scalingConvention) {
        return this.getScalable(network).getSteadyStatePower(network, asked, scalingConvention);
    }
}

