/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification.topology;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.iidm.modification.AbstractNetworkModification;
import com.powsybl.iidm.modification.NetworkModificationImpact;
import com.powsybl.iidm.modification.util.ModificationLogs;
import com.powsybl.iidm.modification.util.ModificationReports;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.BusbarSection;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Line;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.VoltageLevel;
import java.util.Objects;

abstract class AbstractLineConnectionModification<M extends AbstractLineConnectionModification<M>>
extends AbstractNetworkModification {
    protected final String bbsOrBusId;
    protected final Line line;
    protected String line1Id;
    protected String line1Name;
    protected String line2Id;
    protected String line2Name;
    protected double positionPercent;
    protected VoltageLevel voltageLevel;

    protected AbstractLineConnectionModification(double positionPercent, String bbsOrBusId, String line1Id, String line1Name, String line2Id, String line2Name, Line line) {
        this.positionPercent = positionPercent;
        this.bbsOrBusId = Objects.requireNonNull(bbsOrBusId);
        this.line1Id = Objects.requireNonNull(line1Id);
        this.line1Name = line1Name;
        this.line2Id = Objects.requireNonNull(line2Id);
        this.line2Name = line2Name;
        this.line = Objects.requireNonNull(line);
    }

    public M setLine1Id(String line1Id) {
        this.line1Id = Objects.requireNonNull(line1Id);
        return (M)this;
    }

    public M setLine1Name(String line1Name) {
        this.line1Name = line1Name;
        return (M)this;
    }

    public M setLine2Id(String line2Id) {
        this.line2Id = Objects.requireNonNull(line2Id);
        return (M)this;
    }

    public M setLine2Name(String line2Name) {
        this.line2Name = line2Name;
        return (M)this;
    }

    public M setPositionPercent(double positionPercent) {
        this.positionPercent = positionPercent;
        return (M)this;
    }

    public double getPositionPercent() {
        return this.positionPercent;
    }

    public String getBbsOrBusId() {
        return this.bbsOrBusId;
    }

    public Line getLine() {
        return this.line;
    }

    public String getLine1Id() {
        return this.line1Id;
    }

    public String getLine1Name() {
        return this.line1Name;
    }

    public String getLine2Id() {
        return this.line2Id;
    }

    public String getLine2Name() {
        return this.line2Name;
    }

    private static boolean checkPositionPercent(double positionPercent, boolean throwException, ReportNode reportNode) {
        if (Double.isNaN(positionPercent)) {
            ModificationReports.undefinedPercent(reportNode);
            ModificationLogs.logOrThrow(throwException, "Percent should not be undefined");
            return false;
        }
        return true;
    }

    protected boolean failChecks(Network network, boolean throwException, ReportNode reportNode) {
        Identifiable identifiable = network.getIdentifiable(this.bbsOrBusId);
        if (identifiable == null) {
            ModificationLogs.busOrBbsDoesNotExist(this.bbsOrBusId, reportNode, throwException);
            return true;
        }
        if (!AbstractLineConnectionModification.checkPositionPercent(this.positionPercent, throwException, reportNode)) {
            return true;
        }
        this.voltageLevel = AbstractLineConnectionModification.getVoltageLevel(identifiable, throwException, reportNode);
        return this.voltageLevel == null;
    }

    @Override
    public NetworkModificationImpact hasImpactOnNetwork(Network network) {
        this.impact = DEFAULT_IMPACT;
        Identifiable identifiable = network.getIdentifiable(this.bbsOrBusId);
        if (!AbstractLineConnectionModification.checkVoltageLevel(identifiable) || Double.isNaN(this.positionPercent)) {
            this.impact = NetworkModificationImpact.CANNOT_BE_APPLIED;
        }
        return this.impact;
    }

    private static VoltageLevel getVoltageLevel(Identifiable<?> identifiable, boolean throwException, ReportNode reportNode) {
        if (identifiable instanceof Bus) {
            Bus bus = (Bus)identifiable;
            return bus.getVoltageLevel();
        }
        if (identifiable instanceof BusbarSection) {
            BusbarSection bbs = (BusbarSection)identifiable;
            return bbs.getTerminal().getVoltageLevel();
        }
        ModificationReports.unexpectedIdentifiableType(reportNode, identifiable);
        ModificationLogs.logOrThrow(throwException, String.format("Unexpected type of identifiable %s: %s", identifiable.getId(), identifiable.getType()));
        return null;
    }
}

