/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification.topology;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.computation.ComputationManager;
import com.powsybl.iidm.modification.topology.AbstractLineDisconnectionModification;
import com.powsybl.iidm.modification.topology.NamingStrategy;
import com.powsybl.iidm.modification.topology.TopologyModificationUtils;
import com.powsybl.iidm.modification.util.ModificationLogs;
import com.powsybl.iidm.modification.util.ModificationReports;
import com.powsybl.iidm.network.Line;
import com.powsybl.iidm.network.LineAdder;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.TwoSides;
import com.powsybl.iidm.network.VoltageLevel;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevertCreateLineOnLine
extends AbstractLineDisconnectionModification<RevertCreateLineOnLine> {
    private static final Logger LOG = LoggerFactory.getLogger(RevertCreateLineOnLine.class);
    private String mergedLineId;
    private String mergedLineName;
    private static final String LINE_NOT_FOUND_REPORT_MESSAGE = "Line %s is not found";
    private static final String LINE_REMOVED_MESSAGE = "Line {} removed";

    RevertCreateLineOnLine(String lineToBeMerged1Id, String lineToBeMerged2Id, String lineToBeDeletedId, String mergedLineId, String mergedLineName) {
        super(lineToBeMerged1Id, lineToBeMerged2Id, lineToBeDeletedId);
        this.mergedLineId = Objects.requireNonNull(mergedLineId);
        this.mergedLineName = mergedLineName;
    }

    @Override
    public String getName() {
        return "RevertCreateLineOnLine";
    }

    public RevertCreateLineOnLine setLineToBeMerged1Id(String lineToBeMerged1Id) {
        this.oldLine1Id = Objects.requireNonNull(lineToBeMerged1Id);
        return this;
    }

    public RevertCreateLineOnLine setLineToBeMerged2Id(String lineToBeMerged2Id) {
        this.oldLine2Id = Objects.requireNonNull(lineToBeMerged2Id);
        return this;
    }

    public RevertCreateLineOnLine setLineToBeDeletedId(String lineToBeDeletedId) {
        this.lineToRemoveId = Objects.requireNonNull(lineToBeDeletedId);
        return this;
    }

    public RevertCreateLineOnLine setMergedLineId(String mergedLineId) {
        this.mergedLineId = Objects.requireNonNull(mergedLineId);
        return this;
    }

    public RevertCreateLineOnLine setMergedLineName(String mergedLineName) {
        this.mergedLineName = mergedLineName;
        return this;
    }

    private static Line checkAndGetLine(Network network, String lineId, ReportNode reportNode, boolean throwException) {
        Line line = network.getLine(lineId);
        if (line == null) {
            ModificationReports.notFoundLineReport(reportNode, lineId);
            ModificationLogs.logOrThrow(throwException, String.format(LINE_NOT_FOUND_REPORT_MESSAGE, lineId));
            return null;
        }
        return line;
    }

    @Override
    public void apply(Network network, NamingStrategy namingStrategy, boolean throwException, ComputationManager computationManager, ReportNode reportNode) {
        Line lineToBeMerged1 = RevertCreateLineOnLine.checkAndGetLine(network, this.oldLine1Id, reportNode, throwException);
        Line lineToBeMerged2 = RevertCreateLineOnLine.checkAndGetLine(network, this.oldLine2Id, reportNode, throwException);
        Line lineToBeDeleted = RevertCreateLineOnLine.checkAndGetLine(network, this.lineToRemoveId, reportNode, throwException);
        if (lineToBeMerged1 == null || lineToBeMerged2 == null || lineToBeDeleted == null) {
            return;
        }
        VoltageLevel teePoint = TopologyModificationUtils.findTeePoint(lineToBeMerged1, lineToBeMerged2, lineToBeDeleted);
        if (teePoint == null) {
            ModificationReports.noTeePointAndOrTappedVoltageLevelReport(reportNode, this.oldLine1Id, this.oldLine2Id, this.lineToRemoveId);
            ModificationLogs.logOrThrow(throwException, String.format("Unable to find the attachment point and the tapped voltage level from lines %s, %s and %s", this.oldLine1Id, this.oldLine2Id, this.lineToRemoveId));
            return;
        }
        VoltageLevel tappedVoltageLevel = lineToBeDeleted.getTerminal1().getVoltageLevel() == teePoint ? lineToBeDeleted.getTerminal2().getVoltageLevel() : lineToBeDeleted.getTerminal1().getVoltageLevel();
        TwoSides newLineSide1 = lineToBeMerged1.getTerminal1().getVoltageLevel() == teePoint ? TwoSides.TWO : TwoSides.ONE;
        TwoSides newLineSide2 = lineToBeMerged2.getTerminal1().getVoltageLevel() == teePoint ? TwoSides.TWO : TwoSides.ONE;
        LineAdder lineAdder = TopologyModificationUtils.createLineAdder(this.mergedLineId, this.mergedLineName, lineToBeMerged1.getTerminal(newLineSide1).getVoltageLevel().getId(), lineToBeMerged2.getTerminal(newLineSide2).getVoltageLevel().getId(), network, lineToBeMerged1, lineToBeMerged2);
        TopologyModificationUtils.attachLine(lineToBeMerged1.getTerminal(newLineSide1), lineAdder, (bus, adder) -> adder.setConnectableBus1(bus.getId()), (bus, adder) -> adder.setBus1(bus.getId()), (node, adder) -> adder.setNode1(node.intValue()));
        TopologyModificationUtils.attachLine(lineToBeMerged2.getTerminal(newLineSide2), lineAdder, (bus, adder) -> adder.setConnectableBus2(bus.getId()), (bus, adder) -> adder.setBus2(bus.getId()), (node, adder) -> adder.setNode2(node.intValue()));
        TwoSides lineToBeMerged1Side1 = newLineSide1;
        TwoSides lineToBeMerged1Side2 = newLineSide1 == TwoSides.ONE ? TwoSides.TWO : TwoSides.ONE;
        TopologyModificationUtils.LoadingLimitsBags limitsLineToBeMerged1Side1 = new TopologyModificationUtils.LoadingLimitsBags(() -> lineToBeMerged1.getActivePowerLimits(lineToBeMerged1Side1), () -> lineToBeMerged1.getApparentPowerLimits(lineToBeMerged1Side1), () -> lineToBeMerged1.getCurrentLimits(lineToBeMerged1Side1));
        TopologyModificationUtils.LoadingLimitsBags limitsLineToBeMerged1Side2 = new TopologyModificationUtils.LoadingLimitsBags(() -> lineToBeMerged1.getActivePowerLimits(lineToBeMerged1Side2), () -> lineToBeMerged1.getApparentPowerLimits(lineToBeMerged1Side2), () -> lineToBeMerged1.getCurrentLimits(lineToBeMerged1Side2));
        TwoSides lineToBeMerged2Side2 = newLineSide2;
        TwoSides lineToBeMerged2Side1 = newLineSide2 == TwoSides.ONE ? TwoSides.TWO : TwoSides.ONE;
        TopologyModificationUtils.LoadingLimitsBags limitsLineToBeMerged2Side1 = new TopologyModificationUtils.LoadingLimitsBags(() -> lineToBeMerged2.getActivePowerLimits(lineToBeMerged2Side1), () -> lineToBeMerged2.getApparentPowerLimits(lineToBeMerged2Side1), () -> lineToBeMerged2.getCurrentLimits(lineToBeMerged2Side1));
        TopologyModificationUtils.LoadingLimitsBags limitsLineToBeMerged2Side2 = new TopologyModificationUtils.LoadingLimitsBags(() -> lineToBeMerged2.getActivePowerLimits(lineToBeMerged2Side2), () -> lineToBeMerged2.getApparentPowerLimits(lineToBeMerged2Side2), () -> lineToBeMerged2.getCurrentLimits(lineToBeMerged2Side2));
        lineToBeMerged1.remove();
        ModificationReports.removedLineReport(reportNode, this.oldLine1Id);
        LOG.info(LINE_REMOVED_MESSAGE, (Object)this.oldLine1Id);
        lineToBeMerged2.remove();
        ModificationReports.removedLineReport(reportNode, this.oldLine2Id);
        LOG.info(LINE_REMOVED_MESSAGE, (Object)this.oldLine2Id);
        lineToBeDeleted.remove();
        ModificationReports.removedLineReport(reportNode, this.lineToRemoveId);
        LOG.info(LINE_REMOVED_MESSAGE, (Object)this.lineToRemoveId);
        Line line = lineAdder.add();
        TopologyModificationUtils.LoadingLimitsBags limitsSide1 = TopologyModificationUtils.mergeLimits(this.oldLine1Id, limitsLineToBeMerged1Side1, limitsLineToBeMerged1Side2, reportNode);
        TopologyModificationUtils.LoadingLimitsBags limitsSide2 = TopologyModificationUtils.mergeLimits(this.oldLine2Id, limitsLineToBeMerged2Side2, limitsLineToBeMerged2Side1, reportNode);
        TopologyModificationUtils.addLoadingLimits(line, limitsSide1, TwoSides.ONE);
        TopologyModificationUtils.addLoadingLimits(line, limitsSide2, TwoSides.TWO);
        ModificationReports.createdLineReport(reportNode, this.mergedLineId);
        LOG.info("New line {} created, replacing lines {}, {} and {}", new Object[]{this.mergedLineId, this.oldLine1Id, this.oldLine2Id, this.lineToRemoveId});
        TopologyModificationUtils.removeVoltageLevelAndSubstation(teePoint, reportNode);
        TopologyModificationUtils.removeVoltageLevelAndSubstation(tappedVoltageLevel, reportNode);
    }

    public String getLineToBeMerged1Id() {
        return this.oldLine1Id;
    }

    public String getLineToBeMerged2Id() {
        return this.oldLine2Id;
    }

    public String getLineToBeDeletedId() {
        return this.lineToRemoveId;
    }

    public String getMergedLineId() {
        return this.mergedLineId;
    }

    public String getMergedLineName() {
        return this.mergedLineName;
    }
}

