/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification.topology;

import com.google.common.collect.ImmutableList;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.iidm.modification.topology.NamingStrategy;
import com.powsybl.iidm.modification.util.ModificationReports;
import com.powsybl.iidm.network.ActivePowerLimits;
import com.powsybl.iidm.network.ApparentPowerLimits;
import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.BusbarSection;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.CurrentLimits;
import com.powsybl.iidm.network.IdentifiableType;
import com.powsybl.iidm.network.Injection;
import com.powsybl.iidm.network.Line;
import com.powsybl.iidm.network.LineAdder;
import com.powsybl.iidm.network.LoadingLimits;
import com.powsybl.iidm.network.LoadingLimitsAdder;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.SwitchKind;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.TwoSides;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.extensions.BusbarSectionPosition;
import com.powsybl.iidm.network.extensions.ConnectablePosition;
import com.powsybl.math.graph.TraverseResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.Range;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TopologyModificationUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(TopologyModificationUtils.class);

    private TopologyModificationUtils() {
    }

    static LineAdder createLineAdder(double percent, String id, String name, String voltageLevelId1, String voltageLevelId2, Network network, Line line) {
        return ((LineAdder)((LineAdder)((LineAdder)((LineAdder)network.newLine().setId(id)).setName(name)).setVoltageLevel1(voltageLevelId1)).setVoltageLevel2(voltageLevelId2)).setR(line.getR() * percent / 100.0).setX(line.getX() * percent / 100.0).setG1(line.getG1() * percent / 100.0).setB1(line.getB1() * percent / 100.0).setG2(line.getG2() * percent / 100.0).setB2(line.getB2() * percent / 100.0);
    }

    static LineAdder createLineAdder(String id, String name, String voltageLevelId1, String voltageLevelId2, Network network, Line line1, Line line2) {
        return ((LineAdder)((LineAdder)((LineAdder)((LineAdder)network.newLine().setId(id)).setName(name)).setVoltageLevel1(voltageLevelId1)).setVoltageLevel2(voltageLevelId2)).setR(line1.getR() + line2.getR()).setX(line1.getX() + line2.getX()).setG1(line1.getG1() + line2.getG1()).setB1(line1.getB1() + line2.getB1()).setG2(line1.getG2() + line2.getG2()).setB2(line1.getB2() + line2.getB2());
    }

    static void attachLine(Terminal terminal, LineAdder adder, BiConsumer<Bus, LineAdder> connectableBusSetter, BiConsumer<Bus, LineAdder> busSetter, BiConsumer<Integer, LineAdder> nodeSetter) {
        if (terminal.getVoltageLevel().getTopologyKind() == TopologyKind.BUS_BREAKER) {
            connectableBusSetter.accept(terminal.getBusBreakerView().getConnectableBus(), adder);
            Bus bus = terminal.getBusBreakerView().getBus();
            if (bus != null) {
                busSetter.accept(bus, adder);
            }
        } else if (terminal.getVoltageLevel().getTopologyKind() == TopologyKind.NODE_BREAKER) {
            int node = terminal.getNodeBreakerView().getNode();
            nodeSetter.accept(node, adder);
        } else {
            throw new IllegalStateException();
        }
    }

    public static void addLoadingLimits(Line created, LoadingLimitsBags limits, TwoSides side) {
        if (side == TwoSides.ONE) {
            limits.getActivePowerLimits().ifPresent(lim -> TopologyModificationUtils.addLoadingLimits(created.newActivePowerLimits1(), lim));
            limits.getApparentPowerLimits().ifPresent(lim -> TopologyModificationUtils.addLoadingLimits(created.newApparentPowerLimits1(), lim));
            limits.getCurrentLimits().ifPresent(lim -> TopologyModificationUtils.addLoadingLimits(created.newCurrentLimits1(), lim));
        } else {
            limits.getActivePowerLimits().ifPresent(lim -> TopologyModificationUtils.addLoadingLimits(created.newActivePowerLimits2(), lim));
            limits.getApparentPowerLimits().ifPresent(lim -> TopologyModificationUtils.addLoadingLimits(created.newApparentPowerLimits2(), lim));
            limits.getCurrentLimits().ifPresent(lim -> TopologyModificationUtils.addLoadingLimits(created.newCurrentLimits2(), lim));
        }
    }

    private static <L extends LoadingLimits, A extends LoadingLimitsAdder<L, A>> void addLoadingLimits(A adder, LoadingLimitsBag limits) {
        adder.setPermanentLimit(limits.getPermanentLimit());
        for (TemporaryLimitsBag tl : limits.getTemporaryLimits()) {
            adder.beginTemporaryLimit().setName(tl.getName()).setAcceptableDuration(tl.getAcceptableDuration()).setFictitious(tl.isFictitious()).setValue(tl.getValue()).endTemporaryLimit();
        }
        adder.add();
    }

    static void removeVoltageLevelAndSubstation(VoltageLevel voltageLevel, ReportNode reportNode) {
        Optional substation = voltageLevel.getSubstation();
        String vlId = voltageLevel.getId();
        boolean noMoreEquipments = voltageLevel.getConnectableStream().noneMatch(c -> c.getType() != IdentifiableType.BUSBAR_SECTION);
        if (!noMoreEquipments) {
            ModificationReports.voltageLevelRemovingEquipmentsLeftReport(reportNode, vlId);
            LOGGER.warn("Voltage level {} still contains equipments", (Object)vlId);
        }
        voltageLevel.remove();
        ModificationReports.voltageLevelRemovedReport(reportNode, vlId);
        LOGGER.info("Voltage level {} removed", (Object)vlId);
        substation.ifPresent(s -> {
            if (s.getVoltageLevelStream().count() == 0L) {
                String substationId = s.getId();
                s.remove();
                ModificationReports.substationRemovedReport(reportNode, substationId);
                LOGGER.info("Substation {} removed", (Object)substationId);
            }
        });
    }

    static void createNBBreaker(int node1, int node2, String id, VoltageLevel.NodeBreakerView view, boolean open) {
        ((VoltageLevel.NodeBreakerView.SwitchAdder)((VoltageLevel.NodeBreakerView.SwitchAdder)view.newSwitch().setId(id)).setEnsureIdUnicity(true)).setKind(SwitchKind.BREAKER).setOpen(open).setRetained(true).setNode1(node1).setNode2(node2).add();
    }

    static void createNBDisconnector(int node1, int node2, String id, VoltageLevel.NodeBreakerView view, boolean open) {
        ((VoltageLevel.NodeBreakerView.SwitchAdder)((VoltageLevel.NodeBreakerView.SwitchAdder)view.newSwitch().setId(id)).setEnsureIdUnicity(true)).setKind(SwitchKind.DISCONNECTOR).setOpen(open).setNode1(node1).setNode2(node2).add();
    }

    static void createBusBreakerSwitch(String busId1, String busId2, String id, VoltageLevel.BusBreakerView view) {
        ((VoltageLevel.BusBreakerView.SwitchAdder)((VoltageLevel.BusBreakerView.SwitchAdder)view.newSwitch().setId(id)).setEnsureIdUnicity(true)).setOpen(false).setBus1(busId1).setBus2(busId2).add();
    }

    static NavigableMap<Integer, List<Integer>> getSliceOrdersMap(VoltageLevel voltageLevel) {
        LinkedHashMap<BusbarSection, Set> connectablesByBbs = new LinkedHashMap<BusbarSection, Set>();
        voltageLevel.getConnectableStream(BusbarSection.class).forEach(bbs -> TopologyModificationUtils.fillConnectablesMap(bbs, connectablesByBbs));
        LinkedHashMap<Integer, Set> connectablesBySectionIndex = new LinkedHashMap<Integer, Set>();
        connectablesByBbs.forEach((bbs, connectables) -> {
            BusbarSectionPosition bbPosition = (BusbarSectionPosition)bbs.getExtension(BusbarSectionPosition.class);
            if (bbPosition != null) {
                connectablesBySectionIndex.merge(bbPosition.getSectionIndex(), (Set)connectables, (l1, l2) -> {
                    l1.addAll(l2);
                    return l1;
                });
            }
        });
        TreeMap<Integer, List<Integer>> ordersBySectionIndex = new TreeMap<Integer, List<Integer>>();
        connectablesBySectionIndex.forEach((sectionIndex, connectables) -> {
            ArrayList orders = new ArrayList();
            connectables.forEach(connectable -> TopologyModificationUtils.addOrderPositions(connectable, voltageLevel, orders));
            ordersBySectionIndex.put((Integer)sectionIndex, orders);
        });
        return ordersBySectionIndex;
    }

    static void fillConnectablesMap(final BusbarSection bbs, final Map<BusbarSection, Set<Connectable<?>>> connectablesByBbs) {
        BusbarSectionPosition bbPosition = (BusbarSectionPosition)bbs.getExtension(BusbarSectionPosition.class);
        final int bbSection = bbPosition.getSectionIndex();
        if (connectablesByBbs.containsKey(bbs)) {
            return;
        }
        final Set connectables = connectablesByBbs.compute(bbs, (k, v) -> new LinkedHashSet());
        bbs.getTerminal().traverse(new Terminal.TopologyTraverser(){

            public TraverseResult traverse(Terminal terminal, boolean connected) {
                if (terminal.getVoltageLevel() != bbs.getTerminal().getVoltageLevel()) {
                    return TraverseResult.TERMINATE_PATH;
                }
                Connectable connectable = terminal.getConnectable();
                if (connectable instanceof BusbarSection) {
                    BusbarSection otherBbs = (BusbarSection)connectable;
                    BusbarSectionPosition otherBbPosition = (BusbarSectionPosition)otherBbs.getExtension(BusbarSectionPosition.class);
                    if (otherBbPosition.getSectionIndex() == bbSection) {
                        connectablesByBbs.put(otherBbs, connectables);
                    } else {
                        return TraverseResult.TERMINATE_PATH;
                    }
                }
                connectables.add(connectable);
                return TraverseResult.CONTINUE;
            }

            public TraverseResult traverse(Switch aSwitch) {
                return TraverseResult.CONTINUE;
            }
        });
    }

    static List<BusbarSection> getParallelBusbarSections(VoltageLevel voltageLevel, BusbarSectionPosition position) {
        return voltageLevel.getNodeBreakerView().getBusbarSectionStream().filter(b -> b.getExtension(BusbarSectionPosition.class) != null).filter(b -> ((BusbarSectionPosition)b.getExtension(BusbarSectionPosition.class)).getSectionIndex() == position.getSectionIndex()).toList();
    }

    static void createNodeBreakerSwitchesTopology(VoltageLevel voltageLevel, int connectableNode, int forkNode, NamingStrategy namingStrategy, String baseId, BusbarSection bbs) {
        TopologyModificationUtils.createNodeBreakerSwitchesTopology(voltageLevel, connectableNode, forkNode, namingStrategy, baseId, List.of(bbs), bbs);
    }

    static void createNodeBreakerSwitchesTopology(VoltageLevel voltageLevel, int connectableNode, int forkNode, NamingStrategy namingStrategy, String baseId, List<BusbarSection> bbsList, BusbarSection bbs) {
        TopologyModificationUtils.createNBBreaker(connectableNode, forkNode, namingStrategy.getBreakerId(baseId), voltageLevel.getNodeBreakerView(), false);
        TopologyModificationUtils.createDisconnectorTopology(voltageLevel, forkNode, namingStrategy, baseId, bbsList, bbs);
    }

    static void createDisconnectorTopology(VoltageLevel voltageLevel, int forkNode, NamingStrategy namingStrategy, String baseId, List<BusbarSection> bbsList, BusbarSection bbs) {
        TopologyModificationUtils.createDisconnectorTopology(voltageLevel, forkNode, namingStrategy, baseId, bbsList, bbs, 0);
    }

    static void createDisconnectorTopology(VoltageLevel voltageLevel, int forkNode, NamingStrategy namingStrategy, String baseId, List<BusbarSection> bbsList, BusbarSection bbs, int side) {
        bbsList.forEach(b -> {
            int bbsNode = b.getTerminal().getNodeBreakerView().getNode();
            TopologyModificationUtils.createNBDisconnector(forkNode, bbsNode, namingStrategy.getDisconnectorId((BusbarSection)b, baseId, forkNode, bbsNode, side), voltageLevel.getNodeBreakerView(), b != bbs);
        });
    }

    public static Optional<Range<Integer>> getUnusedOrderPositionsBefore(BusbarSection bbs) {
        int max;
        BusbarSectionPosition busbarSectionPosition = (BusbarSectionPosition)bbs.getExtension(BusbarSectionPosition.class);
        if (busbarSectionPosition == null) {
            throw new PowsyblException("busbarSection has no BusbarSectionPosition extension");
        }
        VoltageLevel voltageLevel = bbs.getTerminal().getVoltageLevel();
        NavigableMap<Integer, List<Integer>> allOrders = TopologyModificationUtils.getSliceOrdersMap(voltageLevel);
        int sectionIndex = busbarSectionPosition.getSectionIndex();
        Optional<Integer> previousSliceMax = TopologyModificationUtils.getMaxOrderUsedBefore(allOrders, sectionIndex);
        Optional sliceMin = ((List)allOrders.get(sectionIndex)).stream().min(Comparator.naturalOrder());
        int min = previousSliceMax.map(o -> o + 1).orElse(0);
        return Optional.ofNullable(min <= (max = sliceMin.or(() -> TopologyModificationUtils.getMinOrderUsedAfter(allOrders, sectionIndex)).map(o -> o - 1).orElse(Integer.MAX_VALUE).intValue()) ? Range.of((Comparable)Integer.valueOf(min), (Comparable)Integer.valueOf(max)) : null);
    }

    public static Optional<Range<Integer>> getUnusedOrderPositionsAfter(BusbarSection bbs) {
        int max;
        BusbarSectionPosition busbarSectionPosition = (BusbarSectionPosition)bbs.getExtension(BusbarSectionPosition.class);
        if (busbarSectionPosition == null) {
            throw new PowsyblException("busbarSection has no BusbarSectionPosition extension");
        }
        VoltageLevel voltageLevel = bbs.getTerminal().getVoltageLevel();
        NavigableMap<Integer, List<Integer>> allOrders = TopologyModificationUtils.getSliceOrdersMap(voltageLevel);
        int sectionIndex = busbarSectionPosition.getSectionIndex();
        Optional<Integer> nextSliceMin = TopologyModificationUtils.getMinOrderUsedAfter(allOrders, sectionIndex);
        Optional sliceMax = ((List)allOrders.get(sectionIndex)).stream().max(Comparator.naturalOrder());
        int min = sliceMax.or(() -> TopologyModificationUtils.getMaxOrderUsedBefore(allOrders, sectionIndex)).map(o -> o + 1).orElse(0);
        return Optional.ofNullable(min <= (max = nextSliceMin.map(o -> o - 1).orElse(Integer.MAX_VALUE).intValue()) ? Range.of((Comparable)Integer.valueOf(min), (Comparable)Integer.valueOf(max)) : null);
    }

    public static Optional<Range<Integer>> getPositionRange(BusbarSection bbs) {
        BusbarSectionPosition positionExtension = (BusbarSectionPosition)bbs.getExtension(BusbarSectionPosition.class);
        if (positionExtension != null) {
            VoltageLevel voltageLevel = bbs.getTerminal().getVoltageLevel();
            NavigableMap<Integer, List<Integer>> allOrders = TopologyModificationUtils.getSliceOrdersMap(voltageLevel);
            int sectionIndex = positionExtension.getSectionIndex();
            int max = TopologyModificationUtils.getMinOrderUsedAfter(allOrders, sectionIndex).map(o -> o - 1).orElse(Integer.MAX_VALUE);
            int min = TopologyModificationUtils.getMaxOrderUsedBefore(allOrders, sectionIndex).map(o -> o + 1).orElse(0);
            return Optional.ofNullable(min <= max ? Range.of((Comparable)Integer.valueOf(min), (Comparable)Integer.valueOf(max)) : null);
        }
        return Optional.of(Range.of((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(Integer.MAX_VALUE)));
    }

    public static Optional<Integer> getMaxOrderUsedBefore(NavigableMap<Integer, List<Integer>> allOrders, int section) {
        Map.Entry<Integer, List<Integer>> lowerEntry;
        int s = section;
        while ((lowerEntry = allOrders.lowerEntry(s)) != null) {
            s = lowerEntry.getKey();
            if (lowerEntry.getValue().isEmpty()) continue;
        }
        return Optional.ofNullable(lowerEntry).flatMap(entry -> ((List)entry.getValue()).stream().max(Comparator.naturalOrder()));
    }

    public static Optional<Integer> getMinOrderUsedAfter(NavigableMap<Integer, List<Integer>> allOrders, int section) {
        Map.Entry<Integer, List<Integer>> higherEntry;
        int s = section;
        while ((higherEntry = allOrders.higherEntry(s)) != null) {
            s = higherEntry.getKey();
            if (higherEntry.getValue().isEmpty()) continue;
        }
        return Optional.ofNullable(higherEntry).flatMap(entry -> ((List)entry.getValue()).stream().min(Comparator.naturalOrder()));
    }

    public static Set<Integer> getFeederPositions(VoltageLevel voltageLevel) {
        HashSet<Integer> feederPositionsOrders = new HashSet<Integer>();
        voltageLevel.getConnectables().forEach(connectable -> TopologyModificationUtils.addOrderPositions(connectable, voltageLevel, feederPositionsOrders));
        return feederPositionsOrders;
    }

    public static Map<String, List<Integer>> getFeederPositionsByConnectable(VoltageLevel voltageLevel) {
        HashMap<String, List<Integer>> feederPositionsOrders = new HashMap<String, List<Integer>>();
        TopologyModificationUtils.getFeedersByConnectable(voltageLevel).forEach((k, v) -> {
            ArrayList orders = new ArrayList();
            v.forEach(feeder -> feeder.getOrder().ifPresent(orders::add));
            if (orders.size() > 1) {
                Collections.sort(orders);
            }
            feederPositionsOrders.put((String)k, orders);
        });
        return feederPositionsOrders;
    }

    private static void addOrderPositions(Connectable<?> connectable, VoltageLevel voltageLevel, Collection<Integer> feederPositionsOrders) {
        TopologyModificationUtils.addOrderPositions(connectable, voltageLevel, feederPositionsOrders, false, ReportNode.NO_OP);
    }

    private static void addOrderPositions(Connectable<?> connectable, VoltageLevel voltageLevel, Collection<Integer> feederPositionsOrders, boolean throwException, ReportNode reportNode) {
        ConnectablePosition position = (ConnectablePosition)connectable.getExtension(ConnectablePosition.class);
        if (position != null) {
            List<Integer> orders = TopologyModificationUtils.getOrderPositions(position, voltageLevel, connectable, throwException, reportNode);
            feederPositionsOrders.addAll(orders);
        }
    }

    public static Map<String, List<ConnectablePosition.Feeder>> getFeedersByConnectable(VoltageLevel voltageLevel) {
        HashMap<String, List<ConnectablePosition.Feeder>> feedersByConnectable = new HashMap<String, List<ConnectablePosition.Feeder>>();
        voltageLevel.getConnectables().forEach(connectable -> {
            ConnectablePosition position = (ConnectablePosition)connectable.getExtension(ConnectablePosition.class);
            if (position != null) {
                List<ConnectablePosition.Feeder> feeder = TopologyModificationUtils.getFeeders(position, voltageLevel, connectable, false, ReportNode.NO_OP);
                feedersByConnectable.put(connectable.getId(), feeder);
            }
        });
        return feedersByConnectable;
    }

    private static List<Integer> getOrderPositions(ConnectablePosition<?> position, VoltageLevel voltageLevel, Connectable<?> connectable, boolean throwException, ReportNode reportNode) {
        List<ConnectablePosition.Feeder> feeders;
        if (connectable instanceof Injection) {
            feeders = TopologyModificationUtils.getInjectionFeeder(position);
        } else if (connectable instanceof Branch) {
            feeders = TopologyModificationUtils.getBranchFeeders(position, voltageLevel, (Branch)connectable);
        } else if (connectable instanceof ThreeWindingsTransformer) {
            ThreeWindingsTransformer twt = (ThreeWindingsTransformer)connectable;
            feeders = TopologyModificationUtils.get3wtFeeders(position, voltageLevel, twt);
        } else {
            LOGGER.error("Given connectable not supported: {}", (Object)connectable.getClass().getName());
            ModificationReports.connectableNotSupported(reportNode, connectable);
            if (throwException) {
                throw new IllegalStateException("Given connectable not supported: " + connectable.getClass().getName());
            }
            return Collections.emptyList();
        }
        ArrayList<Integer> orders = new ArrayList<Integer>();
        feeders.forEach(feeder -> feeder.getOrder().ifPresent(orders::add));
        if (orders.size() > 1) {
            Collections.sort(orders);
        }
        return orders;
    }

    private static List<ConnectablePosition.Feeder> getFeeders(ConnectablePosition<?> position, VoltageLevel voltageLevel, Connectable<?> connectable, boolean throwException, ReportNode reportNode) {
        if (connectable instanceof Injection) {
            return TopologyModificationUtils.getInjectionFeeder(position);
        }
        if (connectable instanceof Branch) {
            return TopologyModificationUtils.getBranchFeeders(position, voltageLevel, (Branch)connectable);
        }
        if (connectable instanceof ThreeWindingsTransformer) {
            ThreeWindingsTransformer twt = (ThreeWindingsTransformer)connectable;
            return TopologyModificationUtils.get3wtFeeders(position, voltageLevel, twt);
        }
        LOGGER.error("Given connectable not supported: {}", (Object)connectable.getClass().getName());
        ModificationReports.connectableNotSupported(reportNode, connectable);
        if (throwException) {
            throw new IllegalStateException("Given connectable not supported: " + connectable.getClass().getName());
        }
        return Collections.emptyList();
    }

    private static List<ConnectablePosition.Feeder> getInjectionFeeder(ConnectablePosition<?> position) {
        return Optional.ofNullable(position.getFeeder()).map(List::of).orElse(Collections.emptyList());
    }

    private static List<ConnectablePosition.Feeder> getBranchFeeders(ConnectablePosition<?> position, VoltageLevel voltageLevel, Branch<?> branch) {
        ArrayList<ConnectablePosition.Feeder> feeders = new ArrayList<ConnectablePosition.Feeder>();
        if (branch.getTerminal1().getVoltageLevel() == voltageLevel) {
            Optional.ofNullable(position.getFeeder1()).ifPresent(feeders::add);
        }
        if (branch.getTerminal2().getVoltageLevel() == voltageLevel) {
            Optional.ofNullable(position.getFeeder2()).ifPresent(feeders::add);
        }
        return feeders;
    }

    private static List<ConnectablePosition.Feeder> get3wtFeeders(ConnectablePosition<?> position, VoltageLevel voltageLevel, ThreeWindingsTransformer twt) {
        ArrayList<ConnectablePosition.Feeder> feeders = new ArrayList<ConnectablePosition.Feeder>();
        if (twt.getLeg1().getTerminal().getVoltageLevel() == voltageLevel) {
            Optional.ofNullable(position.getFeeder1()).ifPresent(feeders::add);
        }
        if (twt.getLeg2().getTerminal().getVoltageLevel() == voltageLevel) {
            Optional.ofNullable(position.getFeeder2()).ifPresent(feeders::add);
        }
        if (twt.getLeg3().getTerminal().getVoltageLevel() == voltageLevel) {
            Optional.ofNullable(position.getFeeder3()).ifPresent(feeders::add);
        }
        return feeders;
    }

    public static BusbarSection getFirstBusbarSection(VoltageLevel voltageLevel) {
        BusbarSection bbs = voltageLevel.getNodeBreakerView().getBusbarSectionStream().anyMatch(b -> b.getExtension(BusbarSectionPosition.class) != null) ? (BusbarSection)voltageLevel.getNodeBreakerView().getBusbarSectionStream().min(Comparator.comparingInt(b -> {
            BusbarSectionPosition position = (BusbarSectionPosition)b.getExtension(BusbarSectionPosition.class);
            return position == null ? Integer.MAX_VALUE : position.getSectionIndex();
        }).thenComparingInt(b -> {
            BusbarSectionPosition position = (BusbarSectionPosition)b.getExtension(BusbarSectionPosition.class);
            return position == null ? Integer.MAX_VALUE : position.getBusbarIndex();
        })).orElse(null) : (BusbarSection)voltageLevel.getNodeBreakerView().getBusbarSectionStream().findFirst().orElse(null);
        if (bbs == null) {
            throw new PowsyblException(String.format("Voltage level %s has no busbar section.", voltageLevel.getId()));
        }
        return bbs;
    }

    private static Optional<LoadingLimitsBag> mergeLimits(String lineId, Optional<LoadingLimitsBag> limits1, Optional<LoadingLimitsBag> limitsTeePointSide, ReportNode reportNode) {
        Optional<LoadingLimitsBag> limits;
        double permanentLimit = limits1.map(LoadingLimitsBag::getPermanentLimit).orElse(Double.NaN);
        List temporaryLimits1 = limits1.map(LoadingLimitsBag::getTemporaryLimits).orElse(new ArrayList());
        List temporaryLimitsTeePointSide = limitsTeePointSide.map(LoadingLimitsBag::getTemporaryLimits).orElse(new ArrayList());
        ArrayList<TemporaryLimitsBag> temporaryLimits = new ArrayList();
        if (!limitsTeePointSide.isPresent()) {
            limits = limits1;
        } else {
            if (Double.isNaN(permanentLimit)) {
                permanentLimit = limitsTeePointSide.get().getPermanentLimit();
            } else if (!Double.isNaN(limitsTeePointSide.get().getPermanentLimit())) {
                permanentLimit = Math.min(permanentLimit, limitsTeePointSide.get().getPermanentLimit());
            }
            if (!temporaryLimits1.isEmpty() && !temporaryLimitsTeePointSide.isEmpty()) {
                LOGGER.warn("Temporary limits on both sides for line {} : They are ignored", (Object)lineId);
                ModificationReports.ignoreTemporaryLimitsOnBothLineSides(reportNode, lineId);
            } else {
                temporaryLimits = !temporaryLimits1.isEmpty() ? temporaryLimits1 : temporaryLimitsTeePointSide;
            }
            limits = Optional.of(new LoadingLimitsBag(permanentLimit, temporaryLimits));
        }
        return limits;
    }

    public static LoadingLimitsBags mergeLimits(String lineId, LoadingLimitsBags limits, LoadingLimitsBags limitsTeePointSide, ReportNode reportNode) {
        Optional<LoadingLimitsBag> activePowerLimits = TopologyModificationUtils.mergeLimits(lineId, limits.getActivePowerLimits(), limitsTeePointSide.getActivePowerLimits(), reportNode);
        Optional<LoadingLimitsBag> apparentPowerLimits = TopologyModificationUtils.mergeLimits(lineId, limits.getApparentPowerLimits(), limitsTeePointSide.getApparentPowerLimits(), reportNode);
        Optional<LoadingLimitsBag> currentLimits = TopologyModificationUtils.mergeLimits(lineId, limits.getCurrentLimits(), limitsTeePointSide.getCurrentLimits(), reportNode);
        return new LoadingLimitsBags(activePowerLimits.orElse(null), apparentPowerLimits.orElse(null), currentLimits.orElse(null));
    }

    public static VoltageLevel findTeePoint(Line line1, Line line2, Line line3) {
        Map<VoltageLevel, Long> countVoltageLevels = Stream.of(line1, line2, line3).map(Connectable::getTerminals).flatMap(Collection::stream).collect(Collectors.groupingBy(Terminal::getVoltageLevel, Collectors.counting()));
        Map.Entry commonVlMapEntry = Collections.max(countVoltageLevels.entrySet(), Map.Entry.comparingByValue());
        if (countVoltageLevels.size() == 4 && (Long)commonVlMapEntry.getValue() == 3L) {
            return (VoltageLevel)commonVlMapEntry.getKey();
        }
        return null;
    }

    public static final class LoadingLimitsBags {
        private final LoadingLimitsBag activePowerLimits;
        private final LoadingLimitsBag apparentPowerLimits;
        private final LoadingLimitsBag currentLimits;

        public LoadingLimitsBags(Supplier<Optional<ActivePowerLimits>> activePowerLimitsGetter, Supplier<Optional<ApparentPowerLimits>> apparentPowerLimitsGetter, Supplier<Optional<CurrentLimits>> currentLimitsGetter) {
            this.activePowerLimits = activePowerLimitsGetter.get().map(LoadingLimitsBag::new).orElse(null);
            this.apparentPowerLimits = apparentPowerLimitsGetter.get().map(LoadingLimitsBag::new).orElse(null);
            this.currentLimits = currentLimitsGetter.get().map(LoadingLimitsBag::new).orElse(null);
        }

        LoadingLimitsBags(LoadingLimitsBag activePowerLimits, LoadingLimitsBag apparentPowerLimits, LoadingLimitsBag currentLimits) {
            this.activePowerLimits = activePowerLimits;
            this.apparentPowerLimits = apparentPowerLimits;
            this.currentLimits = currentLimits;
        }

        Optional<LoadingLimitsBag> getActivePowerLimits() {
            return Optional.ofNullable(this.activePowerLimits);
        }

        Optional<LoadingLimitsBag> getApparentPowerLimits() {
            return Optional.ofNullable(this.apparentPowerLimits);
        }

        Optional<LoadingLimitsBag> getCurrentLimits() {
            return Optional.ofNullable(this.currentLimits);
        }
    }

    private static final class LoadingLimitsBag {
        private final double permanentLimit;
        private List<TemporaryLimitsBag> temporaryLimits = new ArrayList<TemporaryLimitsBag>();

        private LoadingLimitsBag(LoadingLimits limits) {
            this.permanentLimit = limits.getPermanentLimit();
            for (LoadingLimits.TemporaryLimit tl : limits.getTemporaryLimits()) {
                this.temporaryLimits.add(new TemporaryLimitsBag(tl));
            }
        }

        private LoadingLimitsBag(double permanentLimit, List<TemporaryLimitsBag> temporaryLimitsBags) {
            this.permanentLimit = permanentLimit;
            this.temporaryLimits = temporaryLimitsBags;
        }

        private double getPermanentLimit() {
            return this.permanentLimit;
        }

        private List<TemporaryLimitsBag> getTemporaryLimits() {
            return ImmutableList.copyOf(this.temporaryLimits);
        }
    }

    private static final class TemporaryLimitsBag {
        private final String name;
        private final int acceptableDuration;
        private final boolean fictitious;
        private final double value;

        TemporaryLimitsBag(LoadingLimits.TemporaryLimit temporaryLimit) {
            this.name = temporaryLimit.getName();
            this.acceptableDuration = temporaryLimit.getAcceptableDuration();
            this.fictitious = temporaryLimit.isFictitious();
            this.value = temporaryLimit.getValue();
        }

        private String getName() {
            return this.name;
        }

        private int getAcceptableDuration() {
            return this.acceptableDuration;
        }

        private boolean isFictitious() {
            return this.fictitious;
        }

        private double getValue() {
            return this.value;
        }
    }
}

