/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification.util;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.iidm.modification.util.ModificationReports;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ModificationLogs {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModificationLogs.class);

    private ModificationLogs() {
    }

    public static void logOrThrow(boolean throwException, String message) {
        if (throwException) {
            throw new PowsyblException(message);
        }
        LOGGER.warn("Error while applying modification : {}", (Object)message);
    }

    public static void busOrBbsDoesNotExist(String bbsId, ReportNode reportNode, boolean throwException) {
        ModificationReports.notFoundBusOrBusbarSectionReport(reportNode, bbsId);
        ModificationLogs.logOrThrow(throwException, String.format("Bus or busbar section %s not found", bbsId));
    }
}

