/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification.util;

import com.powsybl.iidm.network.ActivePowerLimitsAdder;
import com.powsybl.iidm.network.ApparentPowerLimitsAdder;
import com.powsybl.iidm.network.CurrentLimitsAdder;
import com.powsybl.iidm.network.LoadingLimits;
import com.powsybl.iidm.network.LoadingLimitsAdder;
import com.powsybl.iidm.network.OperationalLimitsGroup;
import com.powsybl.iidm.network.PhaseTapChanger;
import com.powsybl.iidm.network.PhaseTapChangerAdder;
import com.powsybl.iidm.network.PhaseTapChangerStep;
import com.powsybl.iidm.network.RatioTapChanger;
import com.powsybl.iidm.network.RatioTapChangerAdder;
import com.powsybl.iidm.network.RatioTapChangerStep;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.extensions.ThreeWindingsTransformerFortescue;
import com.powsybl.iidm.network.extensions.ThreeWindingsTransformerFortescueAdder;
import com.powsybl.iidm.network.extensions.ThreeWindingsTransformerPhaseAngleClockAdder;
import com.powsybl.iidm.network.extensions.ThreeWindingsTransformerToBeEstimatedAdder;
import com.powsybl.iidm.network.extensions.TwoWindingsTransformerFortescue;
import com.powsybl.iidm.network.extensions.TwoWindingsTransformerFortescueAdder;
import com.powsybl.iidm.network.extensions.TwoWindingsTransformerPhaseAngleClock;
import com.powsybl.iidm.network.extensions.TwoWindingsTransformerPhaseAngleClockAdder;
import com.powsybl.iidm.network.extensions.TwoWindingsTransformerToBeEstimated;
import com.powsybl.iidm.network.extensions.TwoWindingsTransformerToBeEstimatedAdder;
import com.powsybl.iidm.network.extensions.WindingConnectionType;
import com.powsybl.iidm.network.util.LoadingLimitsUtil;
import org.apache.commons.math3.complex.Complex;

public final class TransformerUtils {
    private TransformerUtils() {
    }

    public static void copyAndAddRatioTapChanger(RatioTapChangerAdder rtcAdder, RatioTapChanger rtc) {
        TransformerUtils.copyCommonRatioTapChanger(rtcAdder, rtc);
        rtc.getAllSteps().keySet().stream().sorted().forEach(step -> ((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)rtcAdder.beginStep()).setR(((RatioTapChangerStep)rtc.getStep(step.intValue())).getR())).setX(((RatioTapChangerStep)rtc.getStep(step.intValue())).getX())).setG(((RatioTapChangerStep)rtc.getStep(step.intValue())).getG())).setB(((RatioTapChangerStep)rtc.getStep(step.intValue())).getB())).setRho(((RatioTapChangerStep)rtc.getStep(step.intValue())).getRho())).endStep());
        rtcAdder.add();
    }

    public static void copyAndMoveAndAddRatioTapChanger(RatioTapChangerAdder rtcAdder, RatioTapChanger rtc) {
        TransformerUtils.copyCommonRatioTapChanger(rtcAdder, rtc);
        rtc.getAllSteps().keySet().stream().sorted().forEach(step -> {
            double rho = ((RatioTapChangerStep)rtc.getStep(step.intValue())).getRho();
            double r = ((RatioTapChangerStep)rtc.getStep(step.intValue())).getR();
            double x = ((RatioTapChangerStep)rtc.getStep(step.intValue())).getX();
            double g = ((RatioTapChangerStep)rtc.getStep(step.intValue())).getG();
            double b = ((RatioTapChangerStep)rtc.getStep(step.intValue())).getB();
            Complex ratio = TransformerUtils.obtainComplexRatio(1.0 / rho, 0.0);
            Complex movedRatio = ratio.reciprocal();
            double rCorrection = 100.0 * (TransformerUtils.impedanceConversion(1.0 + r / 100.0, ratio) - 1.0);
            double xCorrection = 100.0 * (TransformerUtils.impedanceConversion(1.0 + x / 100.0, ratio) - 1.0);
            double gCorrection = 100.0 * (TransformerUtils.admittanceConversion(1.0 + g / 100.0, ratio) - 1.0);
            double bCorrection = 100.0 * (TransformerUtils.admittanceConversion(1.0 + b / 100.0, ratio) - 1.0);
            ((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)rtcAdder.beginStep()).setR(rCorrection)).setX(xCorrection)).setG(gCorrection)).setB(bCorrection)).setRho(1.0 / movedRatio.abs())).endStep();
        });
        rtcAdder.add();
    }

    private static void copyCommonRatioTapChanger(RatioTapChangerAdder rtcAdder, RatioTapChanger rtc) {
        ((RatioTapChangerAdder)((RatioTapChangerAdder)((RatioTapChangerAdder)((RatioTapChangerAdder)rtcAdder.setTapPosition(rtc.getTapPosition())).setTargetV(rtc.getTargetV()).setLoadTapChangingCapabilities(rtc.hasLoadTapChangingCapabilities()).setRegulationMode(rtc.getRegulationMode()).setRegulationValue(rtc.getRegulationValue()).setLowTapPosition(rtc.getLowTapPosition())).setRegulating(rtc.isRegulating())).setRegulationTerminal(rtc.getRegulationTerminal())).setTargetDeadband(rtc.getTargetDeadband());
    }

    public static void copyAndAddPhaseTapChanger(PhaseTapChangerAdder ptcAdder, PhaseTapChanger ptc) {
        TransformerUtils.copyCommonPhaseTapChanger(ptcAdder, ptc);
        ptc.getAllSteps().keySet().stream().sorted().forEach(step -> ((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)ptcAdder.beginStep()).setR(((PhaseTapChangerStep)ptc.getStep(step.intValue())).getR())).setX(((PhaseTapChangerStep)ptc.getStep(step.intValue())).getX())).setG(((PhaseTapChangerStep)ptc.getStep(step.intValue())).getG())).setB(((PhaseTapChangerStep)ptc.getStep(step.intValue())).getB())).setRho(((PhaseTapChangerStep)ptc.getStep(step.intValue())).getRho())).setAlpha(((PhaseTapChangerStep)ptc.getStep(step.intValue())).getAlpha())).endStep());
        ptcAdder.add();
    }

    public static void copyAndMoveAndAddPhaseTapChanger(PhaseTapChangerAdder ptcAdder, PhaseTapChanger ptc) {
        TransformerUtils.copyCommonPhaseTapChanger(ptcAdder, ptc);
        ptc.getAllSteps().keySet().stream().sorted().forEach(step -> {
            double rho = ((PhaseTapChangerStep)ptc.getStep(step.intValue())).getRho();
            double alpha = ((PhaseTapChangerStep)ptc.getStep(step.intValue())).getAlpha();
            double r = ((PhaseTapChangerStep)ptc.getStep(step.intValue())).getR();
            double x = ((PhaseTapChangerStep)ptc.getStep(step.intValue())).getX();
            double g = ((PhaseTapChangerStep)ptc.getStep(step.intValue())).getG();
            double b = ((PhaseTapChangerStep)ptc.getStep(step.intValue())).getB();
            Complex ratio = TransformerUtils.obtainComplexRatio(1.0 / rho, -alpha);
            Complex movedRatio = ratio.reciprocal();
            double rCorrection = 100.0 * (TransformerUtils.impedanceConversion(1.0 + r / 100.0, ratio) - 1.0);
            double xCorrection = 100.0 * (TransformerUtils.impedanceConversion(1.0 + x / 100.0, ratio) - 1.0);
            double gCorrection = 100.0 * (TransformerUtils.admittanceConversion(1.0 + g / 100.0, ratio) - 1.0);
            double bCorrection = 100.0 * (TransformerUtils.admittanceConversion(1.0 + b / 100.0, ratio) - 1.0);
            ((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)ptcAdder.beginStep()).setR(rCorrection)).setX(xCorrection)).setG(gCorrection)).setB(bCorrection)).setRho(1.0 / movedRatio.abs())).setAlpha(-Math.toDegrees(movedRatio.getArgument()))).endStep();
        });
        ptcAdder.add();
    }

    private static void copyCommonPhaseTapChanger(PhaseTapChangerAdder ptcAdder, PhaseTapChanger ptc) {
        ((PhaseTapChangerAdder)((PhaseTapChangerAdder)((PhaseTapChangerAdder)((PhaseTapChangerAdder)ptcAdder.setTapPosition(ptc.getTapPosition())).setRegulationMode(ptc.getRegulationMode()).setRegulationValue(ptc.getRegulationValue()).setLowTapPosition(ptc.getLowTapPosition())).setRegulationTerminal(ptc.getRegulationTerminal())).setTargetDeadband(ptc.getTargetDeadband())).setRegulating(ptc.isRegulating());
    }

    private static Complex obtainComplexRatio(double ratio, double angle) {
        return new Complex(ratio * Math.cos(Math.toRadians(angle)), ratio * Math.sin(Math.toRadians(angle)));
    }

    public static double impedanceConversion(double impedance, Complex a) {
        return impedance * a.abs() * a.abs();
    }

    public static double impedanceConversion(double impedance, double a) {
        return impedance * a * a;
    }

    public static double admittanceConversion(double admittance, Complex a) {
        return admittance / (a.abs() * a.abs());
    }

    public static double admittanceConversion(double admittance, double a) {
        return admittance / (a * a);
    }

    public static void copyOperationalLimitsGroup(OperationalLimitsGroup destination, OperationalLimitsGroup source) {
        source.getActivePowerLimits().ifPresent(activePowerLimits -> ((ActivePowerLimitsAdder)LoadingLimitsUtil.initializeFromLoadingLimits((LoadingLimitsAdder)destination.newActivePowerLimits(), (LoadingLimits)activePowerLimits)).add());
        source.getApparentPowerLimits().ifPresent(apparentPowerLimits -> ((ApparentPowerLimitsAdder)LoadingLimitsUtil.initializeFromLoadingLimits((LoadingLimitsAdder)destination.newApparentPowerLimits(), (LoadingLimits)apparentPowerLimits)).add());
        source.getCurrentLimits().ifPresent(currentLimits -> ((CurrentLimitsAdder)LoadingLimitsUtil.initializeFromLoadingLimits((LoadingLimitsAdder)destination.newCurrentLimits(), (LoadingLimits)currentLimits)).add());
    }

    public static void copyTerminalActiveAndReactivePower(Terminal destinationTerminal, Terminal sourceTerminal) {
        destinationTerminal.setP(sourceTerminal.getP());
        destinationTerminal.setQ(sourceTerminal.getQ());
    }

    public static void copyAndAddFortescue(TwoWindingsTransformerFortescueAdder t2wFortescueAdder, ThreeWindingsTransformerFortescue.LegFortescue legFortescue) {
        t2wFortescueAdder.withConnectionType1(legFortescue.getConnectionType()).withFreeFluxes(legFortescue.isFreeFluxes()).withGroundingR1(legFortescue.getGroundingR()).withGroundingX1(legFortescue.getGroundingX()).withRz(legFortescue.getRz()).withXz(legFortescue.getXz()).withConnectionType2(WindingConnectionType.Y).withGroundingR2(0.0).withGroundingX2(0.0);
        t2wFortescueAdder.add();
    }

    public static void copyAndAddFortescue(ThreeWindingsTransformerFortescueAdder t3wFortescue, TwoWindingsTransformerFortescue t2w1Fortescue, boolean isWellOrientedT2w1, TwoWindingsTransformerFortescue t2w2Fortescue, boolean isWellOrientedT2w2, TwoWindingsTransformerFortescue t2w3Fortescue, boolean isWellOrientedT2w3) {
        TransformerUtils.copyFortescueLeg(t3wFortescue.leg1(), t2w1Fortescue, isWellOrientedT2w1);
        TransformerUtils.copyFortescueLeg(t3wFortescue.leg2(), t2w2Fortescue, isWellOrientedT2w2);
        TransformerUtils.copyFortescueLeg(t3wFortescue.leg3(), t2w3Fortescue, isWellOrientedT2w3);
        t3wFortescue.add();
    }

    private static void copyFortescueLeg(ThreeWindingsTransformerFortescueAdder.LegFortescueAdder legFortescueAdder, TwoWindingsTransformerFortescue t2wFortescue, boolean isWellOrientedT2w) {
        if (t2wFortescue != null) {
            legFortescueAdder.withConnectionType(isWellOrientedT2w ? t2wFortescue.getConnectionType1() : t2wFortescue.getConnectionType2()).withFreeFluxes(t2wFortescue.isFreeFluxes()).withGroundingR(isWellOrientedT2w ? t2wFortescue.getGroundingR1() : t2wFortescue.getGroundingR2()).withGroundingX(isWellOrientedT2w ? t2wFortescue.getGroundingX1() : t2wFortescue.getGroundingX2()).withRz(t2wFortescue.getRz()).withXz(t2wFortescue.getXz());
        }
    }

    public static void copyAndAddPhaseAngleClock(TwoWindingsTransformerPhaseAngleClockAdder phaseAngleClockAdder, int phaseAngleClock) {
        phaseAngleClockAdder.withPhaseAngleClock(phaseAngleClock);
        phaseAngleClockAdder.add();
    }

    public static void copyAndAddPhaseAngleClock(ThreeWindingsTransformerPhaseAngleClockAdder phaseAngleClockAdder, TwoWindingsTransformerPhaseAngleClock t2w2PhaseAngleClock, TwoWindingsTransformerPhaseAngleClock t2w3PhaseAngleClock) {
        if (t2w2PhaseAngleClock != null) {
            phaseAngleClockAdder.withPhaseAngleClockLeg2(t2w2PhaseAngleClock.getPhaseAngleClock());
        }
        if (t2w3PhaseAngleClock != null) {
            phaseAngleClockAdder.withPhaseAngleClockLeg3(t2w3PhaseAngleClock.getPhaseAngleClock());
        }
        phaseAngleClockAdder.add();
    }

    public static void copyAndAddToBeEstimated(TwoWindingsTransformerToBeEstimatedAdder toBeEstimatedAdder, boolean shouldEstimateRatioTapChanger, boolean shouldEstimatePhaseTapChanger) {
        toBeEstimatedAdder.withRatioTapChangerStatus(shouldEstimateRatioTapChanger).withPhaseTapChangerStatus(shouldEstimatePhaseTapChanger);
        toBeEstimatedAdder.add();
    }

    public static void copyAndAddToBeEstimated(ThreeWindingsTransformerToBeEstimatedAdder toBeEstimatedAdder, TwoWindingsTransformerToBeEstimated t2w1ToBeEstimated, TwoWindingsTransformerToBeEstimated t2w2ToBeEstimated, TwoWindingsTransformerToBeEstimated t2w3ToBeEstimated) {
        if (t2w1ToBeEstimated != null) {
            toBeEstimatedAdder.withRatioTapChanger1Status(t2w1ToBeEstimated.shouldEstimateRatioTapChanger()).withPhaseTapChanger1Status(t2w1ToBeEstimated.shouldEstimatePhaseTapChanger());
        }
        if (t2w2ToBeEstimated != null) {
            toBeEstimatedAdder.withRatioTapChanger2Status(t2w2ToBeEstimated.shouldEstimateRatioTapChanger()).withPhaseTapChanger2Status(t2w2ToBeEstimated.shouldEstimatePhaseTapChanger());
        }
        if (t2w3ToBeEstimated != null) {
            toBeEstimatedAdder.withRatioTapChanger3Status(t2w3ToBeEstimated.shouldEstimateRatioTapChanger()).withPhaseTapChanger3Status(t2w3ToBeEstimated.shouldEstimatePhaseTapChanger());
        }
        toBeEstimatedAdder.add();
    }
}

