/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.computation.ComputationManager;
import com.powsybl.iidm.modification.AbstractNetworkModification;
import com.powsybl.iidm.modification.NetworkModificationImpact;
import com.powsybl.iidm.modification.topology.NamingStrategy;
import com.powsybl.iidm.modification.util.ModificationLogs;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Switch;
import java.util.Objects;

public class CloseSwitch
extends AbstractNetworkModification {
    private final String switchId;

    public CloseSwitch(String switchId) {
        this.switchId = Objects.requireNonNull(switchId);
    }

    @Override
    public String getName() {
        return "CloseSwitch";
    }

    @Override
    public void apply(Network network, NamingStrategy namingStrategy, boolean throwException, ComputationManager computationManager, ReportNode reportNode) {
        Switch sw = network.getSwitch(this.switchId);
        if (sw == null) {
            ModificationLogs.logOrThrow(throwException, "Switch '" + this.switchId + "' not found");
        } else {
            sw.setOpen(false);
        }
    }

    @Override
    public NetworkModificationImpact hasImpactOnNetwork(Network network) {
        this.impact = DEFAULT_IMPACT;
        Switch sw = network.getSwitch(this.switchId);
        if (sw == null) {
            this.impact = NetworkModificationImpact.CANNOT_BE_APPLIED;
        } else if (!sw.isOpen()) {
            this.impact = NetworkModificationImpact.NO_IMPACT_ON_NETWORK;
        }
        return this.impact;
    }
}

