/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification.topology;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.commons.report.TypedValue;
import com.powsybl.computation.ComputationManager;
import com.powsybl.iidm.modification.AbstractNetworkModification;
import com.powsybl.iidm.modification.NetworkModificationImpact;
import com.powsybl.iidm.modification.topology.NamingStrategy;
import com.powsybl.iidm.modification.topology.TopologyModificationUtils;
import com.powsybl.iidm.modification.util.ModificationLogs;
import com.powsybl.iidm.modification.util.ModificationReports;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.BusbarSection;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.extensions.ConnectablePosition;
import com.powsybl.iidm.network.extensions.ConnectablePositionAdder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.commons.lang3.Range;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractCreateConnectableFeederBays
extends AbstractNetworkModification {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractCreateConnectableFeederBays.class);
    private static final String POSITION_ORDER_STRING = "PositionOrder ";
    protected final int[] sides;

    protected abstract String getBusOrBusbarSectionId(int var1);

    protected abstract void setBus(int var1, Bus var2, String var3);

    protected abstract void setNode(int var1, int var2, String var3);

    protected abstract Connectable<?> add();

    protected abstract VoltageLevel getVoltageLevel(int var1, Connectable<?> var2);

    protected abstract Integer getPositionOrder(int var1);

    protected abstract Optional<String> getFeederName(int var1);

    protected abstract ConnectablePosition.Direction getDirection(int var1);

    protected abstract int getNode(int var1, Connectable<?> var2);

    protected abstract ConnectablePositionAdder.FeederAdder<?> getFeederAdder(int var1, ConnectablePositionAdder<?> var2);

    protected abstract boolean getLogOrThrowIfIncorrectPositionOrder(int var1);

    protected AbstractCreateConnectableFeederBays(int ... sides) {
        this.sides = Arrays.copyOf(sides, sides.length);
    }

    @Override
    public void apply(Network network, NamingStrategy namingStrategy, boolean throwException, ComputationManager computationManager, ReportNode reportNode) {
        if (!this.setAdderConnectivity(network, reportNode, throwException)) {
            return;
        }
        Map<Integer, Boolean> createExtension = this.getCreateExtensionBySideMap(network, throwException, reportNode);
        if (createExtension.isEmpty()) {
            return;
        }
        Connectable<?> connectable = this.add();
        if (!AbstractCreateConnectableFeederBays.checkNetworks(connectable, network, reportNode, throwException)) {
            return;
        }
        LOGGER.info("New connectable {} of type {} created", (Object)connectable.getId(), (Object)connectable.getType());
        ModificationReports.createdConnectable(reportNode, connectable);
        this.createExtensionAndTopology(createExtension, connectable, network, namingStrategy, reportNode);
    }

    private Map<Integer, Boolean> getCreateExtensionBySideMap(Network network, boolean throwException, ReportNode reportNode) {
        HashMap<Integer, Boolean> createExtensionMap = new HashMap<Integer, Boolean>();
        for (int side : this.sides) {
            Optional<Boolean> createExtension = this.checkIfExtensionShouldBeCreated(network, side, throwException, reportNode);
            if (createExtension.isEmpty()) {
                return new HashMap<Integer, Boolean>();
            }
            createExtensionMap.put(side, createExtension.get());
        }
        return createExtensionMap;
    }

    private Optional<Boolean> checkIfExtensionShouldBeCreated(Network network, int side, boolean throwException, ReportNode reportNode) {
        String busOrBusbarSectionId = this.getBusOrBusbarSectionId(side);
        Identifiable busOrBusbarSection = network.getIdentifiable(busOrBusbarSectionId);
        if (!(busOrBusbarSection instanceof BusbarSection)) {
            return Optional.of(false);
        }
        BusbarSection busbarSection = (BusbarSection)busOrBusbarSection;
        VoltageLevel voltageLevel = busbarSection.getTerminal().getVoltageLevel();
        Set<Integer> takenFeederPositions = TopologyModificationUtils.getFeederPositions(voltageLevel);
        if (takenFeederPositions.isEmpty() && voltageLevel.getConnectableStream().anyMatch(c -> !(c instanceof BusbarSection))) {
            LOGGER.warn("No ConnectablePosition extension found on voltageLevel {}. The ConnectablePosition extension is not created.", (Object)voltageLevel.getId());
            ModificationReports.noConnectablePositionExtension(reportNode, voltageLevel);
            return Optional.of(false);
        }
        if (!this.checkOrderValue(side, busbarSection, takenFeederPositions, reportNode, throwException)) {
            if (this.getLogOrThrowIfIncorrectPositionOrder(side)) {
                return Optional.empty();
            }
            return Optional.of(false);
        }
        return Optional.of(true);
    }

    @Override
    public NetworkModificationImpact hasImpactOnNetwork(Network network) {
        this.impact = DEFAULT_IMPACT;
        for (int side : this.sides) {
            String busOrBusbarSectionId = this.getBusOrBusbarSectionId(side);
            Identifiable busOrBusbarSection = network.getIdentifiable(busOrBusbarSectionId);
            if (busOrBusbarSection instanceof BusbarSection) {
                if (this.getPositionOrder(side) != null && this.getPositionOrder(side) >= 0) continue;
                this.impact = NetworkModificationImpact.CANNOT_BE_APPLIED;
                return this.impact;
            }
            if (busOrBusbarSection instanceof Bus) continue;
            this.impact = NetworkModificationImpact.CANNOT_BE_APPLIED;
            return this.impact;
        }
        return this.impact;
    }

    private boolean checkOrders(int side, Identifiable<?> busOrBusbarSection, ReportNode reportNode, boolean throwException) {
        VoltageLevel voltageLevel;
        Integer positionOrder = this.getPositionOrder(side);
        if (busOrBusbarSection instanceof BusbarSection) {
            BusbarSection bbs = (BusbarSection)busOrBusbarSection;
            voltageLevel = bbs.getTerminal().getVoltageLevel();
            if (positionOrder == null) {
                ModificationReports.unexpectedNullPositionOrder(reportNode, voltageLevel.getId());
                ModificationLogs.logOrThrow(throwException, "Position order is null for attachment in node-breaker voltage level " + voltageLevel.getId());
                return false;
            }
            if (positionOrder < 0) {
                ModificationReports.unexpectedNegativePositionOrder(reportNode, positionOrder, voltageLevel.getId());
                ModificationLogs.logOrThrow(throwException, "Position order is negative for attachment in node-breaker voltage level " + voltageLevel.getId() + ": " + positionOrder);
                return false;
            }
        }
        if (positionOrder != null && busOrBusbarSection instanceof Bus) {
            Bus bus = (Bus)busOrBusbarSection;
            voltageLevel = bus.getVoltageLevel();
            ModificationReports.ignoredPositionOrder(reportNode, positionOrder, voltageLevel);
            LOGGER.warn("Voltage level {} is BUS_BREAKER. Position order {} is ignored", (Object)voltageLevel.getId(), (Object)positionOrder);
        }
        return true;
    }

    private boolean checkOrderValue(int side, BusbarSection busbarSection, Set<Integer> takenFeederPositions, ReportNode reportNode, boolean throwException) {
        Integer positionOrder = this.getPositionOrder(side);
        boolean logOrThrowIfIncorrectPositionOrder = this.getLogOrThrowIfIncorrectPositionOrder(side);
        if (takenFeederPositions.contains(positionOrder)) {
            String msg = POSITION_ORDER_STRING + positionOrder + " already taken.";
            this.logAndReport(logOrThrowIfIncorrectPositionOrder, throwException, msg, severity -> ModificationReports.positionOrderAlreadyTakenReport(reportNode, positionOrder, severity));
            return false;
        }
        Optional<Range<Integer>> rangeOpt = TopologyModificationUtils.getPositionRange(busbarSection);
        if (rangeOpt.isEmpty()) {
            String msg = "Positions of adjacent busbar sections do not leave slots for new positions on busbar section '" + busbarSection.getId() + "'.";
            this.logAndReport(logOrThrowIfIncorrectPositionOrder, throwException, msg, severity -> ModificationReports.positionNoSlotLeftByAdjacentBbsReport(reportNode, busbarSection.getId(), severity));
            return false;
        }
        Range<Integer> range = rangeOpt.get();
        if (positionOrder < (Integer)range.getMinimum()) {
            String msg = POSITION_ORDER_STRING + positionOrder + " too low (<" + range.getMinimum() + ").";
            this.logAndReport(logOrThrowIfIncorrectPositionOrder, throwException, msg, severity -> ModificationReports.positionOrderTooLowReport(reportNode, (Integer)range.getMinimum(), positionOrder, severity));
            return false;
        }
        if (positionOrder > (Integer)range.getMaximum()) {
            String msg = POSITION_ORDER_STRING + positionOrder + " too high (>" + range.getMaximum() + ").";
            this.logAndReport(logOrThrowIfIncorrectPositionOrder, throwException, msg, severity -> ModificationReports.positionOrderTooHighReport(reportNode, (Integer)range.getMaximum(), positionOrder, severity));
            return false;
        }
        return true;
    }

    private void logAndReport(boolean logOrThrowIfIncorrectPositionOrder, boolean throwException, String message, Consumer<TypedValue> report) {
        TypedValue severity = logOrThrowIfIncorrectPositionOrder ? TypedValue.ERROR_SEVERITY : TypedValue.WARN_SEVERITY;
        report.accept(severity);
        if (logOrThrowIfIncorrectPositionOrder) {
            ModificationLogs.logOrThrow(throwException, message);
        } else {
            LOGGER.warn(message);
        }
    }

    private boolean setAdderConnectivity(Network network, ReportNode reportNode, boolean throwException) {
        HashMap<VoltageLevel, Integer> firstAvailableNodes = new HashMap<VoltageLevel, Integer>();
        for (int side : this.sides) {
            String busOrBusbarSectionId = this.getBusOrBusbarSectionId(side);
            Identifiable busOrBusbarSection = network.getIdentifiable(busOrBusbarSectionId);
            if (busOrBusbarSection == null) {
                ModificationLogs.busOrBbsDoesNotExist(busOrBusbarSectionId, reportNode, throwException);
                return false;
            }
            if (busOrBusbarSection instanceof Bus) {
                Bus bus = (Bus)busOrBusbarSection;
                this.checkOrders(side, (Identifiable<?>)bus, reportNode, throwException);
                this.setBus(side, bus, bus.getVoltageLevel().getId());
                continue;
            }
            if (busOrBusbarSection instanceof BusbarSection) {
                BusbarSection bbs = (BusbarSection)busOrBusbarSection;
                VoltageLevel voltageLevel = bbs.getTerminal().getVoltageLevel();
                if (!this.checkOrders(side, (Identifiable<?>)bbs, reportNode, throwException)) {
                    return false;
                }
                int connectableNode = firstAvailableNodes.compute(voltageLevel, this::getNextAvailableNode);
                this.setNode(side, connectableNode, voltageLevel.getId());
                continue;
            }
            ModificationReports.unsupportedIdentifiableType(reportNode, busOrBusbarSection.getType(), busOrBusbarSectionId);
            ModificationLogs.logOrThrow(throwException, String.format("Unsupported type %s for identifiable %s", busOrBusbarSection.getType(), busOrBusbarSectionId));
            return false;
        }
        return true;
    }

    private int getNextAvailableNode(VoltageLevel vl, Integer node) {
        return node == null ? vl.getNodeBreakerView().getMaximumNodeIndex() + 1 : node + 1;
    }

    private static boolean checkNetworks(Connectable<?> connectable, Network network, ReportNode reportNode, boolean throwException) {
        if (connectable.getNetwork() != network) {
            connectable.remove();
            ModificationReports.networkMismatchReport(reportNode, connectable.getId(), connectable.getType());
            ModificationLogs.logOrThrow(throwException, String.format("Network given in parameters and in connectableAdder are different. Connectable %s of type %s was added then removed", connectable.getId(), connectable.getType()));
            return false;
        }
        return true;
    }

    private void createExtensionAndTopology(Map<Integer, Boolean> createExtension, Connectable<?> connectable, Network network, NamingStrategy namingStrategy, ReportNode reportNode) {
        String connectableId = connectable.getId();
        boolean createConnectablePosition = false;
        ConnectablePositionAdder connectablePositionAdder = (ConnectablePositionAdder)connectable.newExtension(ConnectablePositionAdder.class);
        for (int side : this.sides) {
            VoltageLevel voltageLevel = this.getVoltageLevel(side, connectable);
            String busOrBusbarSectionId = this.getBusOrBusbarSectionId(side);
            if (voltageLevel.getTopologyKind() != TopologyKind.NODE_BREAKER) continue;
            int positionOrder = this.getPositionOrder(side);
            if (Boolean.TRUE.equals(createExtension.get(side))) {
                this.getFeederAdder(side, connectablePositionAdder).withDirection(this.getDirection(side)).withOrder(positionOrder).withName(this.getFeederName(side).orElse(connectableId)).add();
                createConnectablePosition = true;
            }
            int connectableNode = this.getNode(side, connectable);
            TopologyModificationUtils.createTopologyWithConnectableNode(side, busOrBusbarSectionId, network, voltageLevel, connectableNode, connectable, namingStrategy, reportNode);
        }
        if (createConnectablePosition) {
            connectablePositionAdder.add();
        }
    }
}

