/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification.topology;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.computation.ComputationManager;
import com.powsybl.iidm.modification.topology.AbstractLineConnectionModification;
import com.powsybl.iidm.modification.topology.NamingStrategy;
import com.powsybl.iidm.modification.topology.TopologyModificationUtils;
import com.powsybl.iidm.modification.util.ModificationReports;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.BusAdder;
import com.powsybl.iidm.network.BusbarSection;
import com.powsybl.iidm.network.Line;
import com.powsybl.iidm.network.LineAdder;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.TwoSides;
import com.powsybl.iidm.network.extensions.BusbarSectionPosition;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectVoltageLevelOnLine
extends AbstractLineConnectionModification<ConnectVoltageLevelOnLine> {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectVoltageLevelOnLine.class);

    ConnectVoltageLevelOnLine(double positionPercent, String bbsOrBusId, String line1Id, String line1Name, String line2Id, String line2Name, Line line) {
        super(positionPercent, bbsOrBusId, line1Id, line1Name, line2Id, line2Name, line);
    }

    @Override
    public String getName() {
        return "ConnectVoltageLevelOnLine";
    }

    @Override
    public void apply(Network network, NamingStrategy namingStrategy, boolean throwException, ComputationManager computationManager, ReportNode reportNode) {
        if (this.failChecks(network, throwException, reportNode)) {
            return;
        }
        LineAdder adder1 = TopologyModificationUtils.createLineAdder(this.positionPercent, this.line1Id, this.line1Name, this.line.getTerminal1().getVoltageLevel().getId(), this.voltageLevel.getId(), network, this.line);
        LineAdder adder2 = TopologyModificationUtils.createLineAdder(100.0 - this.positionPercent, this.line2Id, this.line2Name, this.voltageLevel.getId(), this.line.getTerminal2().getVoltageLevel().getId(), network, this.line);
        TopologyModificationUtils.attachLine(this.line.getTerminal1(), adder1, (bus, adder) -> adder.setConnectableBus1(bus.getId()), (bus, adder) -> adder.setBus1(bus.getId()), (node, adder) -> adder.setNode1(node.intValue()));
        TopologyModificationUtils.attachLine(this.line.getTerminal2(), adder2, (bus, adder) -> adder.setConnectableBus2(bus.getId()), (bus, adder) -> adder.setBus2(bus.getId()), (node, adder) -> adder.setNode2(node.intValue()));
        TopologyModificationUtils.LoadingLimitsBags limits1 = new TopologyModificationUtils.LoadingLimitsBags(() -> ((Line)this.line).getActivePowerLimits1(), () -> ((Line)this.line).getApparentPowerLimits1(), () -> ((Line)this.line).getCurrentLimits1());
        TopologyModificationUtils.LoadingLimitsBags limits2 = new TopologyModificationUtils.LoadingLimitsBags(() -> ((Line)this.line).getActivePowerLimits2(), () -> ((Line)this.line).getApparentPowerLimits2(), () -> ((Line)this.line).getCurrentLimits2());
        TopologyKind topologyKind = this.voltageLevel.getTopologyKind();
        if (topologyKind == TopologyKind.BUS_BREAKER) {
            Bus bus2 = network.getBusBreakerView().getBus(this.bbsOrBusId);
            Bus bus1 = ((BusAdder)this.voltageLevel.getBusBreakerView().newBus().setId(namingStrategy.getBusId(this.line1Id))).add();
            Bus bus22 = ((BusAdder)this.voltageLevel.getBusBreakerView().newBus().setId(namingStrategy.getBusId(this.line2Id))).add();
            TopologyModificationUtils.createBusBreakerSwitch(bus1.getId(), bus2.getId(), namingStrategy.getSwitchId(this.line1Id, 1), this.voltageLevel.getBusBreakerView());
            TopologyModificationUtils.createBusBreakerSwitch(bus2.getId(), bus22.getId(), namingStrategy.getSwitchId(this.line2Id, 2), this.voltageLevel.getBusBreakerView());
            adder1.setBus2(bus1.getId());
            adder2.setBus1(bus22.getId());
        } else if (topologyKind == TopologyKind.NODE_BREAKER) {
            int firstAvailableNode = this.voltageLevel.getNodeBreakerView().getMaximumNodeIndex() + 1;
            adder1.setNode2(firstAvailableNode);
            adder2.setNode1(firstAvailableNode + 3);
            BusbarSection bbs = network.getBusbarSection(this.bbsOrBusId);
            BusbarSectionPosition position = (BusbarSectionPosition)bbs.getExtension(BusbarSectionPosition.class);
            if (position == null) {
                TopologyModificationUtils.createNodeBreakerSwitchesTopology(this.voltageLevel, firstAvailableNode, firstAvailableNode + 1, namingStrategy, this.line1Id, bbs);
                TopologyModificationUtils.createNodeBreakerSwitchesTopology(this.voltageLevel, firstAvailableNode + 3, firstAvailableNode + 2, namingStrategy, this.line2Id, bbs);
                LOG.warn("No busbar section position extension found on {}, only one disconnector is created.", (Object)bbs.getId());
                ModificationReports.noBusbarSectionPositionExtensionReport(reportNode, bbs);
            } else {
                List<BusbarSection> bbsList = TopologyModificationUtils.getParallelBusbarSections(this.voltageLevel, position);
                TopologyModificationUtils.createNodeBreakerSwitchesTopology(this.voltageLevel, firstAvailableNode, firstAvailableNode + 1, namingStrategy, this.line1Id, bbsList, bbs);
                TopologyModificationUtils.createNodeBreakerSwitchesTopology(this.voltageLevel, firstAvailableNode + 3, firstAvailableNode + 2, namingStrategy, this.line2Id, bbsList, bbs);
            }
        } else {
            throw new IllegalStateException();
        }
        String originalLineId = this.line.getId();
        this.line.remove();
        Line line1 = adder1.add();
        Line line2 = adder2.add();
        TopologyModificationUtils.addLoadingLimits(line1, limits1, TwoSides.ONE);
        TopologyModificationUtils.addLoadingLimits(line2, limits2, TwoSides.TWO);
        LOG.info("Voltage level {} connected to lines {} and {} replacing line {}.", new Object[]{this.voltageLevel.getId(), this.line1Id, this.line2Id, originalLineId});
        ModificationReports.connectVoltageLevelToLines(reportNode, this.voltageLevel.getId(), this.line1Id, this.line2Id, originalLineId);
    }
}

