/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification.topology;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.computation.ComputationManager;
import com.powsybl.iidm.modification.AbstractNetworkModification;
import com.powsybl.iidm.modification.NetworkModificationImpact;
import com.powsybl.iidm.modification.topology.NamingStrategy;
import com.powsybl.iidm.modification.topology.RemoveFeederBay;
import com.powsybl.iidm.modification.util.ModificationLogs;
import com.powsybl.iidm.modification.util.ModificationReports;
import com.powsybl.iidm.network.HvdcConverterStation;
import com.powsybl.iidm.network.HvdcLine;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.ShuntCompensator;
import com.powsybl.iidm.network.VoltageLevel;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveHvdcLine
extends AbstractNetworkModification {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoveHvdcLine.class);
    private final String hvdcLineId;
    private final List<String> shuntCompensatorIds;

    RemoveHvdcLine(String hvdcLineId, List<String> shuntCompensatorIds) {
        this.hvdcLineId = Objects.requireNonNull(hvdcLineId);
        this.shuntCompensatorIds = Objects.requireNonNull(shuntCompensatorIds);
    }

    @Override
    public String getName() {
        return "RemoveHvdcLine";
    }

    @Override
    public void apply(Network network, NamingStrategy namingStrategy, boolean throwException, ComputationManager computationManager, ReportNode reportNode) {
        HvdcLine hvdcLine = network.getHvdcLine(this.hvdcLineId);
        if (hvdcLine != null) {
            HvdcConverterStation hvdcConverterStation1 = hvdcLine.getConverterStation1();
            HvdcConverterStation hvdcConverterStation2 = hvdcLine.getConverterStation2();
            Set shunts = null;
            if (hvdcConverterStation1.getHvdcType() == HvdcConverterStation.HvdcType.LCC) {
                shunts = this.shuntCompensatorIds.stream().map(id -> RemoveHvdcLine.getShuntCompensator(id, network, throwException, reportNode)).filter(Objects::nonNull).collect(Collectors.toCollection(LinkedHashSet::new));
            } else if (!this.shuntCompensatorIds.isEmpty()) {
                String shuntIds = String.join((CharSequence)",", this.shuntCompensatorIds);
                LOGGER.warn("Shunts {} are ignored since converter stations {} and {} are VSC", new Object[]{shuntIds, hvdcConverterStation1.getId(), hvdcConverterStation2.getId()});
                ModificationReports.ignoredVscShunts(reportNode, shuntIds, hvdcConverterStation1.getId(), hvdcConverterStation2.getId());
            }
            hvdcLine.remove();
            ModificationReports.removedHvdcLineReport(reportNode, this.hvdcLineId);
            LOGGER.info("Hvdc line {} has been removed", (Object)this.hvdcLineId);
            RemoveHvdcLine.removeShuntCompensators(network, hvdcConverterStation1, hvdcConverterStation2, shunts, throwException, computationManager, reportNode);
            RemoveHvdcLine.removeConverterStations(network, hvdcConverterStation1, hvdcConverterStation2, throwException, computationManager, reportNode);
        } else {
            LOGGER.error("Hvdc Line {} not found", (Object)this.hvdcLineId);
            ModificationReports.notFoundHvdcLineReport(reportNode, this.hvdcLineId);
            ModificationLogs.logOrThrow(throwException, "Hvdc Line " + this.hvdcLineId + " not found");
        }
    }

    @Override
    public NetworkModificationImpact hasImpactOnNetwork(Network network) {
        this.impact = DEFAULT_IMPACT;
        if (network.getHvdcLine(this.hvdcLineId) == null) {
            this.impact = NetworkModificationImpact.CANNOT_BE_APPLIED;
        }
        return this.impact;
    }

    private static ShuntCompensator getShuntCompensator(String id, Network network, boolean throwException, ReportNode reportNode) {
        ShuntCompensator sc = network.getShuntCompensator(id);
        if (sc == null) {
            ModificationReports.notFoundShuntReport(reportNode, id);
            ModificationLogs.logOrThrow(throwException, "Shunt " + id + " not found");
            return null;
        }
        return sc;
    }

    private static void removeShuntCompensators(Network network, HvdcConverterStation<?> hvdcConverterStation1, HvdcConverterStation<?> hvdcConverterStation2, Set<ShuntCompensator> shunts, boolean throwException, ComputationManager computationManager, ReportNode reportNode) {
        if (shunts == null) {
            return;
        }
        VoltageLevel vl1 = hvdcConverterStation1.getTerminal().getVoltageLevel();
        VoltageLevel vl2 = hvdcConverterStation2.getTerminal().getVoltageLevel();
        for (ShuntCompensator shuntCompensator : shunts) {
            VoltageLevel shuntVl = shuntCompensator.getTerminal().getVoltageLevel();
            String shuntId = shuntCompensator.getId();
            if (vl1 == shuntVl || vl2 == shuntVl) {
                new RemoveFeederBay(shuntId).apply(network, throwException, computationManager, reportNode);
                ModificationReports.removedShuntCompensatorReport(reportNode, shuntId);
                LOGGER.info("Shunt compensator {} has been removed", (Object)shuntId);
                continue;
            }
            LOGGER.warn("Shunt compensator {} has been ignored because it is not in the same voltage levels as the Lcc ({} or {})", new Object[]{shuntId, vl1.getId(), vl2.getId()});
            ModificationReports.ignoredShuntInAnotherVoltageLevel(reportNode, shuntId, vl1.getId(), vl2.getId());
        }
    }

    private static void removeConverterStations(Network network, HvdcConverterStation<?> hvdcConverterStation1, HvdcConverterStation<?> hvdcConverterStation2, boolean throwException, ComputationManager computationManager, ReportNode reportNode) {
        String station1Id = hvdcConverterStation1.getId();
        String station2Id = hvdcConverterStation2.getId();
        HvdcConverterStation.HvdcType station1Type = hvdcConverterStation1.getHvdcType();
        HvdcConverterStation.HvdcType station2Type = hvdcConverterStation2.getHvdcType();
        new RemoveFeederBay(station1Id).apply(network, throwException, computationManager, reportNode);
        new RemoveFeederBay(station2Id).apply(network, throwException, computationManager, reportNode);
        RemoveHvdcLine.reportConverterStationRemoved(reportNode, station1Id, station1Type);
        RemoveHvdcLine.reportConverterStationRemoved(reportNode, station2Id, station2Type);
    }

    private static void reportConverterStationRemoved(ReportNode reportNode, String stationId, HvdcConverterStation.HvdcType converterStationType) {
        if (converterStationType == HvdcConverterStation.HvdcType.LCC) {
            ModificationReports.removedLccConverterStationReport(reportNode, stationId);
            LOGGER.info("Lcc converter station {} has been removed", (Object)stationId);
        } else if (converterStationType == HvdcConverterStation.HvdcType.VSC) {
            ModificationReports.removedVscConverterStationReport(reportNode, stationId);
            LOGGER.info("Vsc converter station {} has been removed", (Object)stationId);
        }
    }
}

