/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification.topology;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.computation.ComputationManager;
import com.powsybl.iidm.modification.AbstractNetworkModification;
import com.powsybl.iidm.modification.NetworkModificationImpact;
import com.powsybl.iidm.modification.topology.NamingStrategy;
import com.powsybl.iidm.modification.topology.RemoveFeederBayBuilder;
import com.powsybl.iidm.modification.topology.RemoveHvdcLineBuilder;
import com.powsybl.iidm.modification.util.ModificationLogs;
import com.powsybl.iidm.modification.util.ModificationReports;
import com.powsybl.iidm.network.HvdcConverterStation;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.VoltageLevel;
import java.util.Objects;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveVoltageLevel
extends AbstractNetworkModification {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoveVoltageLevel.class);
    private final String voltageLevelId;

    public RemoveVoltageLevel(String voltageLevelId) {
        this.voltageLevelId = Objects.requireNonNull(voltageLevelId);
    }

    @Override
    public String getName() {
        return "RemoveVoltageLevel";
    }

    @Override
    public void apply(Network network, NamingStrategy namingStrategy, boolean throwException, ComputationManager computationManager, ReportNode reportNode) {
        VoltageLevel voltageLevel = network.getVoltageLevel(this.voltageLevelId);
        if (voltageLevel == null) {
            ModificationReports.notFoundVoltageLevelReport(reportNode, this.voltageLevelId);
            ModificationLogs.logOrThrow(throwException, "Voltage level not found: " + this.voltageLevelId);
            return;
        }
        voltageLevel.getConnectables(HvdcConverterStation.class).forEach(hcs -> {
            if (hcs.getHvdcLine() != null) {
                new RemoveHvdcLineBuilder().withHvdcLineId(hcs.getHvdcLine().getId()).build().apply(network, throwException, computationManager, reportNode);
            }
        });
        voltageLevel.getDanglingLines().forEach(dl -> dl.getTieLine().ifPresent(tieLine -> {
            String tlId = tieLine.getId();
            String pairingKey = tieLine.getPairingKey();
            tieLine.remove();
            ModificationReports.removedTieLineReport(reportNode, tlId, pairingKey);
            LOGGER.info("Tie line {} removed", (Object)tlId);
        }));
        Consumer<String> removeConnectableFeederBay = id -> new RemoveFeederBayBuilder().withConnectableId((String)id).build().apply(network, throwException, computationManager, reportNode);
        voltageLevel.getLines().forEach(line -> removeConnectableFeederBay.accept(line.getId()));
        voltageLevel.getTwoWindingsTransformers().forEach(transformer -> removeConnectableFeederBay.accept(transformer.getId()));
        voltageLevel.getThreeWindingsTransformers().forEach(transformer -> removeConnectableFeederBay.accept(transformer.getId()));
        voltageLevel.getConnectables().forEach(connectable -> {
            String connectableId = connectable.getId();
            connectable.remove();
            ModificationReports.removedConnectableReport(reportNode, connectableId);
            LOGGER.info("Connectable {} removed", (Object)connectableId);
        });
        voltageLevel.remove();
        ModificationReports.removedVoltageLevelReport(reportNode, this.voltageLevelId);
        LOGGER.info("Voltage level {}, its equipments and the branches it is connected to have been removed", (Object)this.voltageLevelId);
    }

    @Override
    public NetworkModificationImpact hasImpactOnNetwork(Network network) {
        this.impact = DEFAULT_IMPACT;
        if (network.getVoltageLevel(this.voltageLevelId) == null) {
            this.impact = NetworkModificationImpact.CANNOT_BE_APPLIED;
        }
        return this.impact;
    }
}

