/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification.tripping;

import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.modification.tripping.AbstractTripping;
import com.powsybl.iidm.network.HvdcLine;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.Terminal;
import java.util.Objects;
import java.util.Set;

public class HvdcLineTripping
extends AbstractTripping {
    private final String voltageLevelId;

    public HvdcLineTripping(String hvdcLineId) {
        this(hvdcLineId, null);
    }

    public HvdcLineTripping(String hvdcLineId, String voltageLevelId) {
        super(hvdcLineId);
        this.voltageLevelId = voltageLevelId;
    }

    @Override
    public String getName() {
        return "HvdcLineTripping";
    }

    @Override
    public void traverse(Network network, Set<Switch> switchesToOpen, Set<Terminal> terminalsToDisconnect, Set<Terminal> traversedTerminals) {
        Objects.requireNonNull(network);
        HvdcLine hvdcLine = network.getHvdcLine(this.id);
        if (hvdcLine == null) {
            throw new PowsyblException("HVDC line '" + hvdcLine + "' not found");
        }
        Terminal terminal1 = hvdcLine.getConverterStation1().getTerminal();
        Terminal terminal2 = hvdcLine.getConverterStation2().getTerminal();
        this.traverseDoubleSidedEquipment(this.voltageLevelId, terminal1, terminal2, switchesToOpen, terminalsToDisconnect, traversedTerminals, hvdcLine.getType().name());
    }
}

